/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlName;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

class Select {
    boolean isPreProcess;
    boolean isDistinctSelect;
    private boolean isDistinctAggregate;
    private boolean isAggregated;
    private boolean isGrouped;
    private Object[] aggregateRow;
    private int aggregateCount;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression havingCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iOrderLen;
    Select sUnion;
    HsqlName sIntoTable;
    int intoType = 2;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    int limitStart = 0;
    int limitCount = 0;

    Select() {
    }

    void setPreProcess() {
        this.isPreProcess = true;
    }

    void resolve() throws SQLException {
        int n = this.tFilter.length;
        int n2 = 0;
        while (n2 < n) {
            this.resolve(this.tFilter[n2], true);
            ++n2;
        }
    }

    void resolve(TableFilter tableFilter, boolean bl) throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.resolve(tableFilter);
            if (tableFilter != null && bl) {
                tableFilter.setCondition(this.eCondition);
            }
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].resolve(tableFilter);
            ++n2;
        }
    }

    void checkResolved() throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.checkResolved();
        }
        int n = this.eColumn.length;
        int n2 = 0;
        while (n2 < n) {
            this.eColumn[n2].checkResolved();
            ++n2;
        }
    }

    Object getValue(int n) throws SQLException {
        this.resolve();
        Result result = this.getResult(2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        Trace.check(n2 == 1 && n3 == 1, 17);
        Object object = result.rRoot.data[0];
        if (result.colType[0] == n) {
            return object;
        }
        return Column.convertObject(object, n);
    }

    Result getResult(int n) throws SQLException {
        Object object;
        int n2;
        this.resolve();
        this.checkResolved();
        if (this.sUnion != null && this.sUnion.iResultLen != this.iResultLen) {
            throw Trace.error(5);
        }
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
        }
        int n3 = this.eColumn.length;
        Result result = new Result(n3);
        int n4 = 0;
        while (n4 < n3) {
            Expression expression = this.eColumn[n4];
            result.colType[n4] = expression.getDataType();
            result.colSize[n4] = expression.getColumnSize();
            result.colScale[n4] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
                if (!this.isGrouped && expression.isDistinctAggregate()) {
                    this.isDistinctAggregate = true;
                }
            }
            ++n4;
        }
        if (this.isAggregated) {
            this.aggregateRow = new Object[n3];
        }
        if (n == 0) {
            n = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = n;
        } else {
            this.limitCount = n > this.limitCount ? this.limitCount : n;
            n = this.limitCount;
        }
        boolean bl = false;
        if (!(n == 0 || this.isDistinctSelect || this.isDistinctAggregate || this.isGrouped || this.sUnion != null || this.iOrderLen != 0)) {
            bl = true;
        }
        int n5 = bl ? this.limitStart + n : Integer.MAX_VALUE;
        this.buildResult(result, n5);
        if (this.isAggregated && !this.isGrouped && !this.isDistinctAggregate) {
            this.addAggregateRow(result, this.aggregateRow, n3, this.aggregateCount);
        } else if (this.isGrouped) {
            this.groupResult(result);
        } else if (this.isDistinctAggregate) {
            result.removeDuplicates();
            this.buildDistinctAggregates(result);
            n2 = 0;
            while (n2 < n3) {
                object = this.eColumn[n2];
                ((Expression)object).setDistinctAggregate(false);
                result.colType[n2] = ((Expression)object).getDataType();
                result.colSize[n2] = ((Expression)object).getColumnSize();
                result.colScale[n2] = ((Expression)object).getColumnScale();
                ++n2;
            }
        }
        if (this.isDistinctSelect) {
            n2 = result.getColumnCount();
            result.setColumnCount(this.iResultLen);
            result.removeDuplicates();
            result.setColumnCount(n2);
        }
        if (this.iOrderLen != 0) {
            int[] nArray = new int[this.iOrderLen];
            object = new int[this.iOrderLen];
            int n6 = this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
            int n7 = 0;
            while (n7 < this.iOrderLen) {
                nArray[n7] = n6;
                object[n7] = this.eColumn[n6].isDescending() ? -1 : 1;
                ++n6;
                ++n7;
            }
            result.sortResult(nArray, (int[])object);
        }
        result.setColumnCount(this.iResultLen);
        int n8 = 0;
        while (n8 < this.iResultLen) {
            object = this.eColumn[n8];
            result.sLabel[n8] = ((Expression)object).getAlias();
            result.isLabelQuoted[n8] = ((Expression)object).isAliasQuoted();
            result.sTable[n8] = ((Expression)object).getTableName();
            result.sName[n8] = ((Expression)object).getColumnName();
            ++n8;
        }
        result.trimResult(this.limitStart, this.limitCount);
        if (this.sUnion != null) {
            object = this.sUnion.getResult(0);
            if (this.iUnionType == 1) {
                result.append((Result)object);
                result.removeDuplicates();
            } else if (this.iUnionType == 2) {
                result.append((Result)object);
            } else if (this.iUnionType == 3) {
                result.removeDifferent((Result)object);
            } else if (this.iUnionType == 4) {
                result.removeSecond((Result)object);
            }
        }
        return result;
    }

    private void updateAggregateRow(Object[] objectArray, Object[] objectArray2, int n) throws SQLException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.eColumn[n2].getDataType();
            switch (this.eColumn[n2].getType()) {
                case 45: {
                    Integer n4 = objectArray2[n2] == null ? Expression.INTEGER_0 : Expression.INTEGER_1;
                    objectArray[n2] = Column.sum(objectArray[n2], n4, 4);
                    break;
                }
                case 40: 
                case 41: 
                case 44: {
                    objectArray[n2] = Column.sum(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                case 42: {
                    objectArray[n2] = Column.min(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                case 43: {
                    objectArray[n2] = Column.max(objectArray[n2], objectArray2[n2], n3);
                    break;
                }
                default: {
                    objectArray[n2] = objectArray2[n2];
                }
            }
            ++n2;
        }
    }

    private void addAggregateRow(Result result, Object[] objectArray, int n, int n2) throws SQLException {
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.eColumn[n3].getType();
            if (n4 == 44) {
                objectArray[n3] = Column.avg(objectArray[n3], this.eColumn[n3].getDataType(), n2);
            } else if (n4 == 40 && objectArray[n3] == null) {
                objectArray[n3] = Expression.INTEGER_0;
            }
            ++n3;
        }
        result.add(objectArray);
    }

    private void buildResult(Result result, int n) throws SQLException {
        int n2 = this.eColumn.length;
        int n3 = 0;
        int n4 = this.tFilter.length;
        boolean[] blArray = new boolean[n4];
        int n5 = 0;
        boolean bl = this.isAggregated && !this.isGrouped && !this.isDistinctAggregate;
        while (n5 >= 0 && !this.isPreProcess) {
            boolean bl2;
            TableFilter tableFilter = this.tFilter[n5];
            blArray[n5] = !blArray[n5] ? (bl2 = tableFilter.findFirst()) : (bl2 = tableFilter.next());
            if (!bl2) {
                --n5;
                continue;
            }
            if (n5 < n4 - 1) {
                ++n5;
                continue;
            }
            if (this.eCondition != null && !this.eCondition.test()) continue;
            Object[] objectArray = new Object[n2];
            int n6 = 0;
            while (n6 < n2) {
                objectArray[n6] = this.eColumn[n6].getValue();
                ++n6;
            }
            ++n3;
            if (bl) {
                this.updateAggregateRow(this.aggregateRow, objectArray, n2);
                continue;
            }
            result.add(objectArray);
            if (n3 >= n) break;
        }
        if (bl) {
            this.aggregateCount = n3;
        }
    }

    private void groupResult(Result result) throws SQLException {
        int n = this.eColumn.length;
        int n2 = 0;
        int[] nArray = new int[this.iGroupLen];
        int[] nArray2 = new int[this.iGroupLen];
        int n3 = this.iResultLen;
        int n4 = 0;
        while (n4 < this.iGroupLen) {
            nArray[n4] = n3++;
            nArray2[n4] = 1;
            ++n4;
        }
        result.sortResult(nArray, nArray2);
        Record record = result.rRoot;
        Result result2 = new Result(n);
        do {
            Object[] objectArray = new Object[n];
            n2 = 0;
            boolean bl = false;
            while (record != null && !bl) {
                ++n2;
                int n5 = this.iResultLen;
                while (n5 < this.iResultLen + this.iGroupLen) {
                    if (record.next == null) {
                        bl = true;
                    } else if (Column.compare(record.data[n5], record.next.data[n5], result.colType[n5]) != 0) {
                        bl = true;
                    }
                    ++n5;
                }
                this.updateAggregateRow(objectArray, record.data, n);
                record = record.next;
            }
            if (!this.isAggregated && n2 <= 0) continue;
            this.addAggregateRow(result2, objectArray, n, n2);
        } while (record != null);
        result.setRows(result2);
    }

    private void buildDistinctAggregates(Result result) throws SQLException {
        int n = this.eColumn.length;
        int n2 = 0;
        Record record = result.rRoot;
        Result result2 = new Result(n);
        Object[] objectArray = new Object[n];
        n2 = 0;
        while (record != null) {
            ++n2;
            this.updateAggregateRow(objectArray, record.data, n);
            record = record.next;
        }
        if (this.isAggregated || n2 > 0) {
            this.addAggregateRow(result2, objectArray, n, n2);
        }
        result.setRows(result2);
    }
}

