/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.SigarException;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.plugins.jmx.JMXServerComponent;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CassandraNodeComponent
extends JMXServerComponent<ResourceComponent<?>>
implements OperationFacet {
    private Log log = LogFactory.getLog(CassandraNodeComponent.class);
    private Session cassandraSession;
    private String host;

    public void start(ResourceContext context) throws Exception {
        super.start(context);
        this.host = context.getPluginConfiguration().getSimpleValue("host", "localhost");
        String clusterName = context.getPluginConfiguration().getSimpleValue("clusterName", "unknown");
        String username = context.getPluginConfiguration().getSimpleValue("username", "cassandra");
        String password = context.getPluginConfiguration().getSimpleValue("password", "cassandra");
        String authenticatorClassName = context.getPluginConfiguration().getSimpleValue("authenticator", "org.apache.cassandra.auth.AllowAllAuthenticator");
        Integer nativePort = 9042;
        try {
            nativePort = Integer.parseInt(context.getPluginConfiguration().getSimpleValue("nativeTransportPort", "9042"));
        }
        catch (Exception e) {
            this.log.debug((Object)"Native transport port parsing failed...", (Throwable)e);
        }
        try {
            Cluster.Builder clusterBuilder = Cluster.builder().addContactPoints(new String[]{this.host}).withoutMetrics().withPort(nativePort.intValue());
            if (authenticatorClassName.endsWith("PasswordAuthenticator")) {
                clusterBuilder = clusterBuilder.withCredentials(username, password);
            }
            this.cassandraSession = clusterBuilder.build().connect(clusterName);
        }
        catch (Exception e) {
            this.log.error((Object)("Connect to Cassandra " + this.host + ":" + nativePort), (Throwable)e);
            throw e;
        }
    }

    public void stop() {
        this.log.info((Object)"Shutting down");
        this.cassandraSession.getCluster().shutdown();
    }

    public AvailabilityType getAvailability() {
        ResourceContext context = this.getResourceContext();
        ProcessInfo processInfo = context.getNativeProcess();
        if (processInfo == null) {
            return AvailabilityType.UNKNOWN;
        }
        ProcessInfo.ProcessInfoSnapshot processInfoSnaphot = processInfo.priorSnaphot();
        if (processInfoSnaphot.isRunning()) {
            return AvailabilityType.UP;
        }
        return AvailabilityType.DOWN;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("shutdown")) {
            return this.shutdownNode();
        }
        if (name.equals("start")) {
            return this.startNode();
        }
        if (name.equals("restart")) {
            return this.restartNode();
        }
        if (name.equals("updateSeedsList")) {
            return this.updateSeedsList(parameters);
        }
        return null;
    }

    protected OperationResult shutdownNode() {
        ResourceContext context = this.getResourceContext();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Starting shutdown operation on " + CassandraNodeComponent.class.getName() + " with resource key " + context.getResourceKey()));
        }
        EmsConnection emsConnection = this.getEmsConnection();
        EmsBean storageService = emsConnection.getBean("org.apache.cassandra.db:type=StorageService");
        Class[] emptyParams = new Class[]{};
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Disabling thrift...");
        }
        EmsOperation operation = storageService.getOperation("stopRPCServer", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Disabling gossip...");
        }
        operation = storageService.getOperation("stopGossiping", emptyParams);
        operation.invoke((Object[])emptyParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initiating drain...");
        }
        operation = storageService.getOperation("drain", emptyParams);
        operation.invoke((Object[])emptyParams);
        ProcessInfo process = context.getNativeProcess();
        long pid = process.getPid();
        try {
            process.kill("KILL");
            return new OperationResult("Successfully shut down Cassandra daemon with pid " + pid);
        }
        catch (SigarException e) {
            this.log.warn((Object)("Failed to shut down Cassandra node with pid " + pid), (Throwable)e);
            OperationResult failure = new OperationResult("Failed to shut down Cassandra node with pid " + pid);
            failure.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
            return failure;
        }
    }

    protected OperationResult startNode() {
        ResourceContext context = this.getResourceContext();
        Configuration pluginConfig = context.getPluginConfiguration();
        String baseDir = pluginConfig.getSimpleValue("baseDir");
        File binDir = new File(baseDir, "bin");
        File startScript = new File(binDir, this.getStartScript());
        ProcessExecution scriptExe = ProcessExecutionUtility.createProcessExecution((File)startScript);
        SystemInfo systemInfo = context.getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(scriptExe);
        if (results.getError() == null) {
            return new OperationResult("Successfully started Cassandra daemon");
        }
        OperationResult failure = new OperationResult("Failed to start Cassandra daemon");
        failure.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)results.getError()));
        return failure;
    }

    protected OperationResult restartNode() {
        OperationResult result = this.shutdownNode();
        if (result.getErrorMessage() == null) {
            result = this.startNode();
        }
        return result;
    }

    protected OperationResult updateSeedsList(Configuration params) {
        PropertyList list = params.getList("seedsList");
        List<String> addresses = this.getAddresses(list);
        OperationResult result = new OperationResult();
        try {
            this.updateSeedsList(addresses);
        }
        catch (Exception e) {
            this.log.error((Object)"An error occurred while updating the seeds list property", (Throwable)e);
            Throwable rootCause = ThrowableUtil.getRootCause((Throwable)e);
            result.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)rootCause));
        }
        return result;
    }

    protected List<String> getAddresses(PropertyList seedsList) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Property property : seedsList.getList()) {
            PropertySimple simple = (PropertySimple)property;
            addresses.add(simple.getStringValue());
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSeedsList(List<String> addresses) throws IOException {
        block9: {
            ResourceContext context = this.getResourceContext();
            Configuration pluginConfig = context.getPluginConfiguration();
            String yamlProp = pluginConfig.getSimpleValue("yamlConfiguration");
            if (yamlProp == null || yamlProp.isEmpty()) {
                throw new IllegalStateException("Plugin configuration property [yamlConfiguration] is undefined. This property must specify be set and specify the location of cassandra.yaml in order to complete this operation");
            }
            File yamlFile = new File(yamlProp);
            if (!yamlFile.exists()) {
                throw new IllegalStateException("Plug configuration property [yamlConfiguration] has as its value a non-existent file.");
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            Map cassandraConfig = (Map)yaml.load((InputStream)new FileInputStream(yamlFile));
            List seedProviderList = (List)cassandraConfig.get("seed_provider");
            Map seedProvider = (Map)seedProviderList.get(0);
            List paramsList = (List)seedProvider.get("parameters");
            Map params = (Map)paramsList.get(0);
            params.put("seeds", StringUtil.listToString(addresses));
            File yamlFileBackup = new File(yamlProp + ".bak" + new Date().getTime());
            StreamUtil.copy((InputStream)new FileInputStream(yamlFile), (OutputStream)new FileOutputStream(yamlFileBackup), (boolean)true);
            if (!yamlFile.delete()) {
                String msg = "Failed to delete [" + yamlFile + "] in preparation of writing updated configuration. The " + "changes will be aborted.";
                this.log.error((Object)msg);
                this.deleteYamlBackupFile(yamlFileBackup);
                throw new IOException(msg);
            }
            FileWriter writer = new FileWriter(yamlFile);
            try {
                yaml.dump((Object)cassandraConfig, (Writer)writer);
                this.deleteYamlBackupFile(yamlFileBackup);
            }
            catch (Exception e) {
                this.log.error((Object)("An error occurred while trying to write the updated configuration back to " + yamlFile), (Throwable)e);
                this.log.error((Object)("Reverting changes to " + yamlFile));
                if (yamlFile.delete()) {
                    StreamUtil.copy((InputStream)new FileInputStream(yamlFileBackup), (OutputStream)new FileOutputStream(yamlFile));
                    this.deleteYamlBackupFile(yamlFileBackup);
                    break block9;
                }
                String msg = "Failed updates to " + yamlFile.getName() + " cannot be rolled back. The file cannot be " + "deleted. " + yamlFile + " should be replaced by " + yamlFileBackup;
                this.log.error((Object)msg);
                throw new IOException(msg);
            }
            finally {
                writer.close();
            }
        }
    }

    private void deleteYamlBackupFile(File yamlBackup) {
        if (!yamlBackup.delete()) {
            this.log.warn((Object)("Failed to delete Cassandra configuration backup file [" + yamlBackup + "]. This file " + "should be deleted."));
        }
    }

    private String getStartScript() {
        ResourceContext context = this.getResourceContext();
        SystemInfo systemInfo = context.getSystemInformation();
        if (systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS) {
            return "cassandra.bat";
        }
        return "cassandra";
    }

    public Session getCassandraSession() {
        return this.cassandraSession;
    }

    public String getHost() {
        return this.host;
    }
}

