/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jmx.JMXDiscoveryComponent;
import org.yaml.snakeyaml.Yaml;

public class CassandraNodeDiscoveryComponent
extends JMXDiscoveryComponent {
    private static final Log log = LogFactory.getLog(CassandraNodeDiscoveryComponent.class);
    protected static final String HOST_PROPERTY = "host";
    protected static final String CLUSTER_NAME_PROPERTY = "clusterName";
    protected static final String NATIVE_TRANSPORT_PORT_PROPERTY = "nativeTransportPort";
    protected static final String JMX_PORT_PROPERTY = "jmxPort";
    protected static final String AUTHENTICATOR_PROPERTY = "authenticator";
    protected static final String USERNAME_PROPERTY = "username";
    protected static final String PASSWORD_PROPERTY = "password";
    protected static final String YAML_PROPERTY = "yamlConfiguration";
    protected static final String BASEDIR_PROPERTY = "baseDir";
    protected static final String DEFAULT_RHQ_CLUSTER = "rhq";
    private static final String RESOURCE_NAME = "Cassandra";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext context) {
        HashSet<DiscoveredResourceDetails> cassandraNodes = new HashSet<DiscoveredResourceDetails>();
        for (DiscoveredResourceDetails discoveredResource : this.scanForResources(context)) {
            if (!this.isCassandraNode(discoveredResource)) continue;
            cassandraNodes.add(discoveredResource);
        }
        return cassandraNodes;
    }

    protected Set<DiscoveredResourceDetails> scanForResources(ResourceDiscoveryContext context) {
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        List processScanResults = context.getAutoDiscoveredProcesses();
        for (ProcessScanResult processScanResult : processScanResults) {
            DiscoveredResourceDetails discoveredDetails = this.getDetails(context, processScanResult);
            if (discoveredDetails == null) continue;
            details.add(discoveredDetails);
        }
        return details;
    }

    protected boolean isCassandraNode(DiscoveredResourceDetails discoveredResource) {
        return !DEFAULT_RHQ_CLUSTER.equals(discoveredResource.getPluginConfiguration().getSimpleValue(CLUSTER_NAME_PROPERTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveredResourceDetails getDetails(ResourceDiscoveryContext<?> context, ProcessScanResult processScanResult) {
        Configuration pluginConfig = context.getDefaultPluginConfiguration();
        String jmxPort = null;
        StringBuilder commandLineBuilder = new StringBuilder(400);
        int classpathIndex = -1;
        ProcessInfo processInfo = processScanResult.getProcessInfo();
        String[] arguments = processInfo.getCommandLine();
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if (arg.startsWith("-Dcom.sun.management.jmxremote.port")) {
                String[] jmxPortArg = arg.split("=");
                jmxPort = jmxPortArg[1];
            }
            if (arg.startsWith("-cp") || arg.startsWith("-classpath")) {
                classpathIndex = i;
            }
            commandLineBuilder.append(arg);
            commandLineBuilder.append(' ');
        }
        pluginConfig.put((Property)new PropertySimple("commandLine", (Object)commandLineBuilder.toString()));
        if (classpathIndex != -1 && classpathIndex + 1 < arguments.length) {
            String[] classpathEntries = arguments[classpathIndex + 1].split(File.pathSeparator);
            File yamlConfigurationPath = null;
            for (String classpathEntry : classpathEntries) {
                if (!classpathEntry.endsWith("conf") || (yamlConfigurationPath = new File(classpathEntry)).isAbsolute()) continue;
                try {
                    yamlConfigurationPath = new File(processInfo.getExecutable().getCwd(), classpathEntry);
                }
                catch (Exception e) {
                    log.error((Object)"Error creating path for yaml file.", (Throwable)e);
                }
            }
            if (yamlConfigurationPath != null) {
                InputStream inputStream = null;
                try {
                    File yamlConfigurationFile = new File(yamlConfigurationPath, "cassandra.yaml");
                    pluginConfig.put((Property)new PropertySimple(YAML_PROPERTY, (Object)yamlConfigurationFile.getAbsolutePath()));
                    inputStream = new FileInputStream(yamlConfigurationFile);
                    Yaml yaml = new Yaml();
                    Map parsedProperties = (Map)yaml.load(inputStream);
                    if (parsedProperties.get("cluster_name") != null) {
                        pluginConfig.put((Property)new PropertySimple(CLUSTER_NAME_PROPERTY, parsedProperties.get("cluster_name")));
                    }
                    if (parsedProperties.get("listen_address") != null) {
                        pluginConfig.put((Property)new PropertySimple(HOST_PROPERTY, parsedProperties.get("listen_address")));
                    }
                    if (parsedProperties.get("native_transport_port") != null) {
                        pluginConfig.put((Property)new PropertySimple(NATIVE_TRANSPORT_PORT_PROPERTY, parsedProperties.get("native_transport_port")));
                    }
                    if (parsedProperties.get(AUTHENTICATOR_PROPERTY) != null) {
                        pluginConfig.put((Property)new PropertySimple(AUTHENTICATOR_PROPERTY, parsedProperties.get(AUTHENTICATOR_PROPERTY)));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"YAML Configuration load exception ", (Throwable)e);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Unable to close stream for yaml configuration", (Throwable)e);
                    }
                }
            }
        }
        if (jmxPort != null) {
            pluginConfig.put((Property)new PropertySimple(JMX_PORT_PROPERTY, (Object)jmxPort));
            pluginConfig.put((Property)new PropertySimple("type", (Object)J2SE5ConnectionTypeDescriptor.class.getName()));
            pluginConfig.put((Property)new PropertySimple("connectorAddress", (Object)("service:jmx:rmi:///jndi/rmi://" + pluginConfig.getSimpleValue(HOST_PROPERTY) + ":" + jmxPort + "/jmxrmi")));
        }
        String resourceKey = "Cassandra (" + pluginConfig.getSimpleValue(HOST_PROPERTY) + ") " + jmxPort;
        String resourceName = RESOURCE_NAME;
        String path = processInfo.getExecutable().getCwd();
        pluginConfig.put((Property)new PropertySimple(BASEDIR_PROPERTY, (Object)new File(path).getParentFile().getAbsolutePath()));
        pluginConfig.put((Property)new PropertySimple(USERNAME_PROPERTY, (Object)this.getDefaultUserName()));
        pluginConfig.put((Property)new PropertySimple(PASSWORD_PROPERTY, (Object)this.getDefaultPassword()));
        return new DiscoveredResourceDetails(context.getResourceType(), resourceKey, resourceName, null, null, pluginConfig, processInfo);
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext inventoriedResource) {
        return null;
    }

    protected String getDefaultUserName() {
        return "cassandra";
    }

    protected String getDefaultPassword() {
        return "cassandra";
    }
}

