/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra;

import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.file.FileUtil;
import org.rhq.plugins.cassandra.CassandraNodeComponent;
import org.rhq.plugins.cassandra.ComplexConfigurationResourceComponent;
import org.rhq.plugins.cassandra.KeyspaceComponent;

public class ColumnFamilyComponent
extends ComplexConfigurationResourceComponent {
    private Log log = LogFactory.getLog(ColumnFamilyComponent.class);

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration config = super.loadResourceConfiguration();
        if (this.log.isDebugEnabled()) {
            ResourceContext context = this.getResourceContext();
            this.log.debug((Object)("Loading resource context for column family " + context.getResourceKey()));
        }
        config.put((Property)new PropertySimple("gc_grace_seconds", (Object)this.getGCGraceSeconds()));
        config.put((Property)this.getSnapshotsWithDetails());
        return config;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("repair")) {
            String columnFamilyName = this.getResourceContext().getPluginConfiguration().getSimpleValue("name");
            return this.getParentKeyspace().repairKeyspace(columnFamilyName);
        }
        if (name.equals("compact")) {
            String columnFamilyName = this.getResourceContext().getPluginConfiguration().getSimpleValue("name");
            return this.getParentKeyspace().compactKeyspace(columnFamilyName);
        }
        if (name.equals("takeSnapshot")) {
            String columnFamilyName = this.getResourceContext().getResourceKey();
            return this.getParentKeyspace().takeSnapshot(parameters, columnFamilyName);
        }
        if (name.equals("restoreSnapshot")) {
            return this.restoreSnapshot(parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updating resource configuration for column family " + this.getResourceContext().getResourceKey()));
        }
        try {
            Configuration updatedConfig = report.getConfiguration();
            String gcGraceSeconds = updatedConfig.getSimpleValue("gc_grace_seconds", "864000");
            this.setGCGraceSeconds(gcGraceSeconds);
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            String msg = "Failed to update resource configuration for column family " + this.getResourceContext().getResourceKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)msg, (Throwable)e);
            } else if (this.log.isWarnEnabled()) {
                this.log.warn((Object)msg);
            }
            report.setErrorMessageFromThrowable((Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
        report.getConfiguration().remove("gc_grace_seconds");
        report.getConfiguration().remove("snapshots");
        super.updateResourceConfiguration(report);
    }

    private void setGCGraceSeconds(String gcGraceSeconds) {
        Session session = this.getParentKeyspace().getCassandraSession();
        Update.Where q = QueryBuilder.update((String)"system", (String)"schema_columnfamilies").with(QueryBuilder.set((String)"gc_grace_seconds", (Object)gcGraceSeconds)).where(QueryBuilder.eq((String)"columnfamily_name", (Object)this.getResourceContext().getResourceKey())).and(QueryBuilder.eq((String)"keyspace_name", (Object)this.getParentKeyspace().getKeyspaceName()));
        session.execute((Query)q);
    }

    private Integer getGCGraceSeconds() {
        Session session = this.getParentKeyspace().getCassandraSession();
        Select.Where q = QueryBuilder.select((String[])new String[]{"gc_grace_seconds"}).from("system", "schema_columnfamilies").where(QueryBuilder.eq((String)"columnfamily_name", (Object)this.getResourceContext().getResourceKey())).and(QueryBuilder.eq((String)"keyspace_name", (Object)this.getParentKeyspace().getKeyspaceName()));
        ResultSet resultSet = session.execute((Query)q);
        if (!resultSet.isExhausted()) {
            return resultSet.one().getInt("gc_grace_seconds");
        }
        return null;
    }

    private PropertyList getSnapshotsWithDetails() {
        PropertyList listOfSnapshots = new PropertyList("snapshots");
        KeyspaceComponent parentKeyspace = this.getParentKeyspace();
        PropertyList parentDataFileLocations = parentKeyspace.getKeySpaceDataFileLocations();
        for (Property directory : parentDataFileLocations.getList()) {
            File[] files;
            String directoryName = ((PropertySimple)directory).getStringValue();
            directoryName = directoryName + "/" + this.getResourceContext().getPluginConfiguration().getSimpleValue("name");
            File snapshotDirectory = new File(directoryName = directoryName + "/snapshots");
            if (!snapshotDirectory.exists()) continue;
            for (File individualSnapshot : files = snapshotDirectory.listFiles()) {
                if (!individualSnapshot.isDirectory()) continue;
                PropertyMap snapshotDetails = new PropertyMap("snapshot");
                snapshotDetails.put((Property)new PropertySimple("name", (Object)individualSnapshot.getName()));
                snapshotDetails.put((Property)new PropertySimple("folder", (Object)individualSnapshot.getAbsolutePath()));
                listOfSnapshots.add((Property)snapshotDetails);
            }
        }
        return listOfSnapshots;
    }

    private OperationResult restoreSnapshot(Configuration parameters) {
        OperationResult result = new OperationResult();
        String requestedSnapshotName = parameters.getSimpleValue("snapshotName");
        PropertyList listOfSnapShots = this.getSnapshotsWithDetails();
        String snapshotDirectoryName = null;
        for (Property property : listOfSnapShots.getList()) {
            String snapshotName = ((PropertyMap)property).getSimpleValue("name", null);
            if (!requestedSnapshotName.equals(snapshotName)) continue;
            snapshotDirectoryName = ((PropertyMap)property).getSimpleValue("folder", null);
            break;
        }
        if (snapshotDirectoryName == null) {
            result.setErrorMessage("Restore failed! The snapshot does not exist!");
            return result;
        }
        File snapshotDirectory = new File(snapshotDirectoryName);
        if (!snapshotDirectory.exists() || !snapshotDirectory.isDirectory()) {
            result.setErrorMessage("Restore failed! The snapshot does not exist on disk!");
            return result;
        }
        CassandraNodeComponent node = this.getParentKeyspace().getCassandraNodeComponent();
        node.shutdownNode();
        KeyspaceComponent parentKeyspace = this.getParentKeyspace();
        parentKeyspace.clearCommitLog();
        PropertyList parentDataFileLocations = parentKeyspace.getKeySpaceDataFileLocations();
        for (Property dataFileDirectoryProperty : parentDataFileLocations.getList()) {
            File[] filesToBeRestored;
            String columnFamilyDirectoryName = ((PropertySimple)dataFileDirectoryProperty).getStringValue();
            File columnFamilyDirectory = new File(columnFamilyDirectoryName = columnFamilyDirectoryName + "/" + this.getResourceContext().getPluginConfiguration().getSimpleValue("name"));
            if (!columnFamilyDirectory.exists()) continue;
            File[] originalColumnFamilyDataFiles = columnFamilyDirectory.listFiles();
            if (originalColumnFamilyDataFiles != null) {
                for (File file : originalColumnFamilyDataFiles) {
                    if (!file.isFile()) continue;
                    file.delete();
                }
            }
            if ((filesToBeRestored = snapshotDirectory.listFiles()) == null) continue;
            for (File fileToBeRestored : filesToBeRestored) {
                if (!fileToBeRestored.isFile()) continue;
                File destinationFile = new File(columnFamilyDirectory, fileToBeRestored.getName());
                try {
                    FileUtil.copyFile((File)fileToBeRestored, (File)destinationFile);
                }
                catch (Exception e) {
                    result.setErrorMessage("Restore failed! The file copying process failed!");
                    return result;
                }
            }
        }
        node.startNode();
        result.setSimpleResult("Snapshot restored succesfully...");
        return result;
    }

    private KeyspaceComponent getParentKeyspace() {
        return (KeyspaceComponent)this.getResourceContext().getParentResourceComponent();
    }
}

