/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.cassandra.util;

import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;

public class KeyspaceService {
    public static final String STORAGE_SERVICE_BEAN = "org.apache.cassandra.db:type=StorageService";
    public static final String REPAIR_OPERATION = "forceTableRepair";
    public static final String REPAIR_PRIMARY_RANGE = "forceTableRepairPrimaryRange";
    public static final String CLEANUP_OPERATION = "forceTableCleanup";
    public static final String COMPACT_OPERATION = "forceTableCompaction";
    public static final String SNAPSHOT_OPERATION = "takeSnapshot";
    public static final String CF_SNAPSHOT_OPERATION = "takeColumnFamilySnapshot";
    private EmsConnection emsConnection;

    public KeyspaceService(EmsConnection emsConnection) {
        this.emsConnection = emsConnection;
    }

    public void repair(String keyspace, String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(REPAIR_OPERATION, new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, String[].class});
        operation.invoke(new Object[]{keyspace, true, true, columnFamilies});
    }

    public void repairPrimaryRange(String keyspace, String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(REPAIR_PRIMARY_RANGE, new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, String[].class});
        operation.invoke(new Object[]{keyspace, true, true, columnFamilies});
    }

    public void cleanup(String keyspace) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(CLEANUP_OPERATION, new Class[]{String.class, String[].class});
        operation.invoke(new Object[]{keyspace, new String[0]});
    }

    public void compact(String keyspace, String ... columnFamilies) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(COMPACT_OPERATION, new Class[]{String.class, String[].class});
        operation.invoke(new Object[]{keyspace, columnFamilies});
    }

    public void takeSnapshot(String keyspace, String snapshotName) {
        EmsBean emsBean = this.loadBean(STORAGE_SERVICE_BEAN);
        EmsOperation operation = emsBean.getOperation(SNAPSHOT_OPERATION, new Class[]{String.class, String[].class});
        operation.invoke(new Object[]{snapshotName, new String[]{keyspace}});
    }

    private EmsBean loadBean(String objectName) {
        EmsBean bean = this.emsConnection.getBean(objectName);
        if (bean == null) {
            this.emsConnection.queryBeans(objectName);
            bean = this.emsConnection.getBean(objectName);
        }
        return bean;
    }
}

