/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mazz.i18n.Logger;
import mazz.i18n.Msg;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtil;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.ExtendedSQLException;
import org.rhq.core.db.TypeMap;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Data;
import org.rhq.core.db.setup.DataSet;
import org.rhq.core.db.setup.Index;
import org.rhq.core.db.setup.Table;
import org.rhq.core.db.setup.View;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DBSetup {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(DBSetup.class);
    private static final Msg MSG = DbUtilsI18NFactory.getMsg();
    private static final String DBSETUP_ROOT_ELEMENT_NAME = "dbsetup";
    private String m_jdbcUrl;
    private String m_username;
    private String m_password;
    private boolean m_consoleMode;
    private Connection m_connection;
    private DatabaseType m_databaseType;
    private boolean m_doDisconnect = true;

    public DBSetup(String jdbc_url, String username, String password) {
        this.m_jdbcUrl = jdbc_url;
        this.m_username = username;
        this.m_password = password;
        this.m_consoleMode = false;
    }

    public DBSetup(String jdbc_url, String username, String password, boolean consoleMode) {
        this.m_jdbcUrl = jdbc_url;
        this.m_username = username;
        this.m_password = password;
        this.m_consoleMode = consoleMode;
    }

    public DBSetup(Connection connection) throws Exception {
        this.m_connection = connection;
        this.m_databaseType = DatabaseTypeFactory.getDatabaseType(connection);
        this.m_consoleMode = false;
        this.m_connection.setAutoCommit(false);
        this.m_doDisconnect = false;
    }

    public static void main(String[] args) {
        boolean do_export = false;
        boolean do_setup = false;
        boolean do_clear = false;
        boolean do_uninstall = false;
        boolean do_uninstallsetup = false;
        String op_requested = "";
        String jdbc_url = null;
        String jdbc_user = null;
        String jdbc_password = null;
        String dbsetup_file = null;
        try {
            if (args.length >= 2) {
                for (String arg : args) {
                    if (arg.startsWith("-op=")) {
                        op_requested = arg.substring(arg.indexOf(61) + 1);
                        do_export = op_requested.equals("export");
                        do_setup = op_requested.equals("setup");
                        do_clear = op_requested.equals("clear");
                        do_uninstall = op_requested.equals("uninstall");
                        do_uninstallsetup = op_requested.equals("uninstallsetup");
                        continue;
                    }
                    if (arg.startsWith("-jdbcurl=")) {
                        jdbc_url = arg.substring(arg.indexOf(61) + 1);
                        continue;
                    }
                    if (arg.startsWith("-jdbcuser=")) {
                        jdbc_user = arg.substring(arg.indexOf(61) + 1);
                        continue;
                    }
                    if (arg.startsWith("-jdbcpassword=")) {
                        jdbc_password = arg.substring(arg.indexOf(61) + 1);
                        continue;
                    }
                    if (arg.startsWith("-file=")) {
                        dbsetup_file = arg.substring(arg.indexOf(61) + 1);
                        continue;
                    }
                    throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.bad-arg", new Object[]{arg}));
                }
            } else {
                throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.help", new Object[0]));
            }
            if (!(do_export || do_setup || do_clear || do_uninstall || do_uninstallsetup)) {
                throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.bad-op", new Object[]{op_requested}));
            }
            if (do_export) {
                if (dbsetup_file == null || dbsetup_file.trim().length() == 0) {
                    throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.bad-dbsetup-file", new Object[]{dbsetup_file}));
                }
            } else {
                File f = new File(dbsetup_file);
                if (!f.exists()) {
                    throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.bad-dbsetup-file", new Object[]{dbsetup_file}));
                }
                dbsetup_file = f.getAbsolutePath();
            }
            if (jdbc_url == null) {
                throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.bad-jdbcurl", new Object[0]));
            }
            if (dbsetup_file == null) {
                throw new IllegalArgumentException(MSG.getMsg("DBSetup.cmdline.bad-dbsetup-file", new Object[]{""}));
            }
        }
        catch (Exception iae) {
            System.out.println(MSG.getMsg("DBSetup.cmdline.usage", new Object[]{iae.getMessage()}));
            return;
        }
        DBSetup dbsetup = new DBSetup(jdbc_url, jdbc_user, jdbc_password);
        try {
            boolean ok = true;
            if (do_export) {
                dbsetup.export(dbsetup_file);
                ok = true;
            }
            if (do_setup) {
                dbsetup.setup(dbsetup_file);
                ok = true;
            } else if (do_clear) {
                ok = dbsetup.clear(dbsetup_file);
            } else if (do_uninstall) {
                ok = dbsetup.uninstall(dbsetup_file);
            } else if (do_uninstallsetup && (ok = dbsetup.uninstall(dbsetup_file))) {
                dbsetup.setup(dbsetup_file);
            }
            if (ok) {
                System.out.println(MSG.getMsg("DBSetup.cmdline.ok", new Object[0]));
            } else {
                System.out.println(MSG.getMsg("DBSetup.cmdline.not-ok", new Object[0]));
            }
        }
        catch (Exception e) {
            System.out.println(MSG.getMsg("DBSetup.cmdline.error", new Object[]{e.getMessage()}));
            e.printStackTrace(System.out);
        }
    }

    private Node copyNode(Document target, Node source, boolean deep) {
        Node ret_new_node;
        String node_name = source.getNodeName();
        String node_value = source.getNodeValue();
        switch (source.getNodeType()) {
            case 1: {
                Element new_elem = target.createElement(node_name);
                ret_new_node = new_elem;
                NamedNodeMap map = source.getAttributes();
                for (int iMap = 0; iMap < map.getLength(); ++iMap) {
                    Node attr = map.item(iMap);
                    new_elem.setAttribute(attr.getNodeName(), attr.getNodeValue());
                }
                break;
            }
            case 8: {
                ret_new_node = target.createComment(node_name);
                break;
            }
            case 3: {
                ret_new_node = target.createTextNode(node_name);
                break;
            }
            default: {
                ret_new_node = null;
            }
        }
        if (ret_new_node != null) {
            ret_new_node.setNodeValue(node_value);
            if (deep) {
                this.importChildNodes(ret_new_node, source, deep);
            }
        }
        return ret_new_node;
    }

    private void importNodeAfter(Node after, Node source, boolean deep) {
        Node nodeNew = this.copyNode(after.getOwnerDocument(), source, deep);
        Node nodeNext = after.getNextSibling();
        if (nodeNext != null) {
            after.getParentNode().insertBefore(nodeNew, after);
        } else {
            after.getParentNode().appendChild(nodeNew);
        }
    }

    private void importChildNodes(Node parent, Node source, boolean deep) {
        NodeList listChildren = source.getChildNodes();
        for (int i = 0; i < listChildren.getLength(); ++i) {
            parent.appendChild(this.copyNode(parent.getOwnerDocument(), listChildren.item(i), deep));
        }
    }

    private Document readDocument(String file) throws IOException, SAXException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(file);
        Document docResult = stream == null ? this.readDocument(file, null) : this.readDocument(stream, null);
        return docResult;
    }

    private Document readDocument(Object source, Node after) throws IOException, SAXException {
        Document ret_document_result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler());
            File source_file = null;
            if (source instanceof String) {
                source_file = new File((String)source);
                ret_document_result = builder.parse(source_file);
            } else if (source instanceof InputStream) {
                ret_document_result = builder.parse((InputStream)source);
            } else {
                throw new IOException("source=" + source.getClass());
            }
            Element node_root = ret_document_result.getDocumentElement();
            if (!node_root.getNodeName().equalsIgnoreCase(DBSETUP_ROOT_ELEMENT_NAME)) {
                if (source instanceof String) {
                    throw new IOException(LOG.getMsgString("DBSetup.source-not-valid", new Object[]{source.toString()}));
                }
                throw new IOException(LOG.getMsgString("DBSetup.source-not-valid", new Object[]{"<stream>"}));
            }
            NodeList listNodes = node_root.getChildNodes();
            for (int iNode = 0; iNode < listNodes.getLength(); ++iNode) {
                Node node = listNodes.item(iNode);
                if (node.getNodeName().equalsIgnoreCase("include")) {
                    NamedNodeMap map = node.getAttributes();
                    for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                        Node nodeMap = map.item(iAttr);
                        if (!nodeMap.getNodeName().equalsIgnoreCase("file")) continue;
                        File fileInclude = new File(nodeMap.getNodeValue());
                        if (!fileInclude.isAbsolute()) {
                            if (!(source instanceof String)) {
                                throw new IOException(LOG.getMsgString("DBSetup.path-not-relative-to-stream", new Object[0]));
                            }
                            fileInclude = new File(source_file.getParentFile(), nodeMap.getNodeValue());
                        }
                        this.readDocument(fileInclude.getAbsolutePath(), node);
                        node_root.removeChild(node);
                    }
                    continue;
                }
                if (after == null) continue;
                this.importNodeAfter(after, node, true);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return ret_document_result;
    }

    public void setup(String file_name) throws Exception {
        this.setup(file_name, null, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(String file_name, String table_name, boolean data_only, boolean do_delete) throws Exception {
        int created_views = 0;
        int created_tables = 0;
        int created_indexes = 0;
        try {
            Document doc = this.readDocument(file_name);
            Element root_node = doc.getDocumentElement();
            this.connect();
            this.log(LogPriority.DEBUG, "DBSetup.connected-to-db", this.m_jdbcUrl, this.m_username);
            Collection<TypeMap> column_types_map = TypeMap.loadKnownTypeMaps();
            List<Table> tables = Table.getTables(root_node, this.getDatabaseType(), this);
            for (Table table : tables) {
                if (table.isObsolete()) {
                    this.log(LogPriority.DEBUG, "DBSetup.ignoring-obsolete-table", table.getName());
                    continue;
                }
                if (table_name != null) {
                    if (!table_name.equalsIgnoreCase(table.getName())) continue;
                    if (do_delete) {
                        table.clear();
                    }
                }
                this.log(LogPriority.DEBUG, "DBSetup.setting-up-table", table.getName());
                if (!data_only) {
                    try {
                        if (table.getColumns().size() > 0) {
                            table.create(column_types_map);
                            ++created_tables;
                            this.log(LogPriority.DEBUG, "DBSetup.created-table", table.getName());
                        }
                    }
                    catch (SQLException e) {
                        this.handleFatalSQLException(e, "DBSetup.created-table-error", table.getName());
                    }
                    Collection<Index> indexes = table.getIndexes();
                    for (Index index : indexes) {
                        try {
                            index.create();
                            this.log(LogPriority.DEBUG, "DBSetup.created-index", index.getName(), index.getTable().getName());
                            ++created_indexes;
                        }
                        catch (SQLException e) {
                            this.handleFatalSQLException(e, "DBSetup.created-index-error", index.getName(), index.getTable().getName());
                        }
                    }
                }
                try {
                    DataSet dataset = table.getDataSet();
                    int rows_created = dataset.create();
                    this.log(LogPriority.DEBUG, "DBSetup.created-rows", rows_created, table.getName());
                }
                catch (SQLException e) {
                    this.handleFatalSQLException(e, "DBSetup.created-rows-error", table.getName());
                }
            }
            List<View> views = View.getViews(root_node, this.getDatabaseType(), this);
            for (View view : views) {
                this.log(LogPriority.DEBUG, "DBSetup.setting-up-view", view.getName());
                if (data_only) continue;
                try {
                    view.create(column_types_map);
                    this.log(LogPriority.DEBUG, "DBSetup.created-view", view.getName());
                    ++created_views;
                }
                catch (SQLException e) {
                    this.handleFatalSQLException(e, "DBSetup.created-view-error", view.getName());
                }
            }
            this.log(LogPriority.INFO, "DBSetup.setup.tables.created", created_tables);
            this.log(LogPriority.INFO, "DBSetup.setup.indexes.created", created_indexes);
            this.log(LogPriority.INFO, "DBSetup.setup.views.created", created_views);
        }
        finally {
            this.disconnect();
        }
    }

    private void handleFatalSQLException(SQLException e, String msg_key, Object ... params) throws SQLException {
        String err_msg = this.m_consoleMode ? MSG.getMsg(msg_key, params) : LOG.getMsgString(msg_key, params);
        String exception_string = DbUtil.getSQLExceptionString(e);
        String full_error_msg = err_msg + " [" + exception_string + ']';
        SQLException wrapper_exception = new SQLException(full_error_msg, e.getSQLState(), e.getErrorCode());
        wrapper_exception.initCause(e);
        this.log(LogPriority.FATAL, e, "DBSetup.fata-sql-exception", full_error_msg);
        throw wrapper_exception;
    }

    public boolean clear(String file_name) throws Exception {
        return this.clear(file_name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear(String file_name, String table_name) throws Exception {
        boolean ret_ok = false;
        int modified_tables_count = 0;
        int failed_tables_count = 0;
        try {
            Document doc = this.readDocument(file_name);
            Element root_node = doc.getDocumentElement();
            this.connect();
            this.log(LogPriority.DEBUG, "DBSetup.connected-to-db", this.m_jdbcUrl, this.m_username);
            List<Table> tables = Table.getTables(root_node, this.getDatabaseType(), this);
            ArrayList<Table> failed_tables = new ArrayList<Table>();
            Collections.reverse(tables);
            for (Table table : tables) {
                if (table_name != null && table.getName().compareToIgnoreCase(table_name) != 0) continue;
                try {
                    table.clear();
                    ++modified_tables_count;
                    this.log(LogPriority.DEBUG, "DBSetup.cleared-table", table.getName());
                }
                catch (SQLException e) {
                    ++failed_tables_count;
                    failed_tables.add(table);
                    this.log(LogPriority.DEBUG, "DBSetup.cleared-table-error-first-pass", table.getName(), DbUtil.getSQLExceptionString(e));
                }
            }
            if (failed_tables.size() > 0) {
                this.log(LogPriority.DEBUG, "DBSetup.clear-second-pass", failed_tables.size());
                for (Table table : failed_tables) {
                    if (table_name != null && table.getName().compareToIgnoreCase(table_name) != 0) continue;
                    try {
                        table.clear();
                        ++modified_tables_count;
                        --failed_tables_count;
                        this.log(LogPriority.DEBUG, "DBSetup.cleared-table", table.getName());
                    }
                    catch (SQLException e) {
                        this.log(LogPriority.DEBUG, "DBSetup.cleared-table-error-second-pass", table.getName(), DbUtil.getSQLExceptionString(e));
                    }
                }
            }
            this.log(LogPriority.INFO, "DBSetup.clear.tables.cleared", modified_tables_count);
            this.log(LogPriority.INFO, "DBSetup.clear.tables.failed", failed_tables_count);
            ret_ok = failed_tables_count == 0;
        }
        finally {
            this.disconnect();
        }
        return ret_ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uninstall(String file_name) throws Exception {
        boolean ret_ok = false;
        int uninstalled_views = 0;
        int failed_views = 0;
        int modified_tables = 0;
        int failed_tables = 0;
        try {
            Document doc = this.readDocument(file_name);
            Element root_node = doc.getDocumentElement();
            this.connect();
            this.log(LogPriority.DEBUG, "DBSetup.connected-to-db", this.m_jdbcUrl, this.m_username);
            List<View> views = View.getViews(root_node, this.getDatabaseType(), this);
            for (View view : views) {
                try {
                    view.drop();
                    ++uninstalled_views;
                    this.log(LogPriority.DEBUG, "DBSetup.dropped-view", view.getName());
                }
                catch (SQLException e) {
                    ++failed_views;
                    this.log(LogPriority.ERROR, "DBSetup.dropped-view-error", view.getName(), DbUtil.getSQLExceptionString(e));
                }
            }
            View.uninstallCleanup(this);
            List<Table> tables = Table.getTables(root_node, this.getDatabaseType(), this);
            Collections.reverse(tables);
            for (Table table : tables) {
                try {
                    table.drop();
                    ++modified_tables;
                    this.log(LogPriority.DEBUG, "DBSetup.dropped-table", table.getName());
                }
                catch (SQLException e) {
                    ++failed_tables;
                    this.log(LogPriority.ERROR, "DBSetup.dropped-table-error", table.getName(), DbUtil.getSQLExceptionString(e));
                }
            }
            Table.uninstallCleanup(this);
            this.log(LogPriority.INFO, "DBSetup.uninstall.views.dropped", uninstalled_views);
            this.log(LogPriority.INFO, "DBSetup.uninstall.tables.dropped", modified_tables);
            this.log(LogPriority.INFO, "DBSetup.uninstall.views.failed", failed_views);
            this.log(LogPriority.INFO, "DBSetup.uninstall.tables.failed", failed_tables);
            ret_ok = failed_views + failed_tables == 0;
        }
        finally {
            this.disconnect();
        }
        return ret_ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String file) throws Exception {
        int created_tables = 0;
        try {
            this.connect();
            this.log(LogPriority.DEBUG, "DBSetup.connected-to-db", this.m_jdbcUrl, this.m_username);
            Document doc = this.createNewDBSetupXmlDocument();
            Comment warning = doc.createComment(MSG.getMsg("DBSetup.export.warning-notice", new Object[]{new Date()}));
            Element root_element = doc.createElement("dbsetup-export");
            doc.appendChild(warning);
            root_element.setAttribute("name", file);
            doc.appendChild(root_element);
            Collection<Table> tables = Table.getTables(this.getDatabaseType(), this, this.m_username);
            for (Table table : tables) {
                Element elemChild;
                this.log(LogPriority.DEBUG, "DBSetup.export.found-table", table.getName());
                Element elemTab = doc.createElement("table");
                elemTab.setAttribute("name", table.getName());
                root_element.appendChild(elemTab);
                for (Column col : table.getColumns()) {
                    this.log(LogPriority.DEBUG, "DBSetup.export.found-column", table.getName(), col.getName());
                    elemChild = doc.createElement("column");
                    elemChild.setAttribute("name", col.getName());
                    elemChild.setAttribute("type", col.getType());
                    elemChild.setAttribute("size", String.valueOf(col.getSize()));
                    if (col.isRequired()) {
                        elemChild.setAttribute("required", String.valueOf(col.isRequired()));
                    }
                    elemTab.appendChild(elemChild);
                }
                DataSet dataset = table.getDataSet();
                while (dataset.next()) {
                    elemChild = doc.createElement("data");
                    int iCols = table.getColumns().size();
                    for (int i = 0; i < iCols; ++i) {
                        Data data = dataset.getData(i);
                        elemChild.setAttribute(data.getColumnName(), data.getValue());
                    }
                    elemTab.appendChild(elemChild);
                }
                ++created_tables;
            }
            this.writeDBSetupXmlDocument(doc, file);
            this.log(LogPriority.INFO, "DBSetup.export.tables-created", created_tables, file);
        }
        finally {
            this.disconnect();
        }
    }

    private Document createNewDBSetupXmlDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler());
        Document docResult = builder.newDocument();
        return docResult;
    }

    private void writeDBSetupXmlDocument(Document doc, String file) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer trans = factory.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource src = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(file));
        trans.transform(src, result);
    }

    protected void doSQL(String sql) throws SQLException {
        this.doSQL(sql, false);
    }

    protected Statement doSQL(String sql, boolean returnPreparedStatement) throws SQLException {
        Statement stmt;
        this.log(LogPriority.DEBUG, "DBSetup.do-sql", sql);
        boolean committing = this.getConnection().getAutoCommit();
        if (committing) {
            this.getConnection().setAutoCommit(false);
        }
        long start = System.currentTimeMillis();
        if (returnPreparedStatement) {
            stmt = this.getConnection().prepareStatement(sql);
        } else {
            stmt = this.getConnection().createStatement();
            try {
                stmt.executeUpdate(sql);
                this.getConnection().commit();
            }
            catch (SQLException e) {
                try {
                    this.getConnection().rollback();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw new ExtendedSQLException(e, sql);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        long duration = System.currentTimeMillis() - start;
        this.getConnection().setAutoCommit(committing);
        return stmt;
    }

    protected Connection getConnection() {
        return this.m_connection;
    }

    protected DatabaseType getDatabaseType() {
        return this.m_databaseType;
    }

    protected String getJdbcUser() {
        return this.m_username;
    }

    private Connection connect() throws Exception {
        if (this.m_connection != null) {
            return this.m_connection;
        }
        this.m_connection = DbUtil.getConnection(this.m_jdbcUrl, this.m_username, this.m_password);
        try {
            this.m_databaseType = DatabaseTypeFactory.getDatabaseType(this.m_connection);
            this.m_connection.setAutoCommit(false);
        }
        catch (Exception e) {
            try {
                this.m_connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_connection = null;
            this.m_databaseType = null;
            throw e;
        }
        return this.m_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        if (!this.m_doDisconnect) {
            return;
        }
        try {
            this.m_connection.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.m_connection = null;
            this.m_databaseType = null;
        }
    }

    private void log(LogPriority priority, String msg_key, Object ... params) {
        if (this.m_consoleMode) {
            System.out.println(priority.toString() + ": " + MSG.getMsg(msg_key, params));
        } else {
            switch (priority) {
                case DEBUG: {
                    LOG.debug(msg_key, params);
                    break;
                }
                case INFO: {
                    LOG.info(msg_key, params);
                    break;
                }
                case WARN: {
                    LOG.warn(msg_key, params);
                    break;
                }
                case ERROR: {
                    LOG.error(msg_key, params);
                    break;
                }
                case FATAL: {
                    LOG.fatal(msg_key, params);
                }
            }
        }
    }

    private void log(LogPriority priority, Exception exception, String msg_key, Object ... params) {
        if (this.m_consoleMode) {
            System.out.println(priority.toString() + ": " + MSG.getMsg(msg_key, params));
            exception.printStackTrace(System.out);
        } else {
            switch (priority) {
                case DEBUG: {
                    LOG.debug((Throwable)exception, msg_key, params);
                    break;
                }
                case INFO: {
                    LOG.info((Throwable)exception, msg_key, params);
                    break;
                }
                case WARN: {
                    LOG.warn((Throwable)exception, msg_key, params);
                    break;
                }
                case ERROR: {
                    LOG.error((Throwable)exception, msg_key, params);
                    break;
                }
                case FATAL: {
                    LOG.fatal((Throwable)exception, msg_key, params);
                }
            }
        }
    }

    private static enum LogPriority {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }

    private class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private ErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            DBSetup.this.log(LogPriority.FATAL, e, "DBSetup.sax-fatal", new Object[]{e.getLineNumber(), e.getColumnNumber(), e.getMessage()});
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            DBSetup.this.log(LogPriority.ERROR, e, "DBSetup.sax-error", new Object[]{e.getLineNumber(), e.getColumnNumber(), e.getMessage()});
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            DBSetup.this.log(LogPriority.WARN, e, "DBSetup.sax-warning", new Object[]{e.getLineNumber(), e.getColumnNumber(), e.getMessage()});
        }
    }
}

