/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.upgrade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import mazz.i18n.Logger;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DbUtilsI18NFactory;
import org.rhq.core.db.upgrade.DatabaseUpgradeTask;

public class DriftPathDirectoryDatabaseUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger LOG = DbUtilsI18NFactory.getLogger(DriftPathDirectoryDatabaseUpgradeTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DatabaseType databaseType, Connection connection) throws SQLException {
        Statement s = null;
        try {
            String sql = "select d.ID, d.PATH, d.PATH_DIRECTORY from RHQ_DRIFT d";
            LOG.debug("DatabaseType.executing-sql", new Object[]{sql});
            s = connection.createStatement(1004, 1008);
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                String path = rs.getString(2);
                String dir = this.getDir(path);
                rs.updateString(3, dir);
                rs.updateRow();
            }
            databaseType.closeStatement(s);
        }
        catch (Throwable throwable) {
            databaseType.closeStatement(s);
            throw throwable;
        }
    }

    private String getDir(String path) {
        int i = path.lastIndexOf("/");
        String result = i != -1 ? path.substring(0, i) : "./";
        return result;
    }
}

