/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.LeasePinger;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.loading.RemotingClassLoader;
import org.jboss.remoting.marshal.InvalidMarshallingResource;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.UpdateableClassloaderUnMarshaller;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.util.id.GUID;

public abstract class MicroRemoteClientInvoker
extends AbstractInvoker
implements ClientInvoker {
    private static final Logger log = Logger.getLogger((Class)MicroRemoteClientInvoker.class);
    private static final String LEASE_CREATION_TIMEOUT_DEFAULT = "30000";
    private boolean trace = log.isTraceEnabled();
    protected boolean connected = false;
    private Marshaller marshaller;
    private Map unmarshallers = new WeakHashMap();
    private String dataType;
    private final Object clientLeaseLock = new Object();
    private LeasePinger leasePinger = null;
    private String invokerSessionID = new GUID().toString();
    protected boolean parentFirstClassLoading = true;
    private boolean changeInvalidStateToCannotConnect = false;
    private String leaseCreationTimeout = "30000";
    protected List connectHomes;

    public MicroRemoteClientInvoker(InvokerLocator locator) {
        super(locator);
        this.init();
    }

    public MicroRemoteClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationRequest invocationReq) throws Throwable {
        Object sessionId;
        Object returnValue = null;
        int invokeCount = 0;
        if (this.trace) {
            log.trace((Object)(this + "(" + ++invokeCount + ") invoking " + invocationReq));
        }
        Marshaller marshaller = null;
        UnMarshaller unmarshaller = null;
        RemotingClassLoader rcl = null;
        Class clazz = MicroRemoteClientInvoker.class;
        synchronized (clazz) {
            Map map;
            marshaller = this.getMarshaller();
            if (marshaller == null) {
                map = this.passConfigMapToMarshalFactory ? this.configuration : null;
                marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClassLoader(), map);
                if (marshaller == null && (marshaller = MarshalFactory.getMarshaller(this.getDataType(), this.getSerializationType())) == null) {
                    throw new InvalidMarshallingResource("Can not find a valid marshaller for data type: " + this.getDataType());
                }
                this.setMarshaller(marshaller);
            }
            if ((unmarshaller = this.getUnMarshaller()) == null) {
                map = this.passConfigMapToMarshalFactory ? this.configuration : null;
                unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClassLoader(), map);
                if (unmarshaller == null && (unmarshaller = MarshalFactory.getUnMarshaller(this.getDataType(), this.getSerializationType())) == null) {
                    throw new InvalidMarshallingResource("Can not find a valid unmarshaller for data type: " + this.getDataType());
                }
                this.setUnMarshaller(unmarshaller);
            }
            ClassLoader contextClassLoader = MicroRemoteClientInvoker.getContextClassLoader(Thread.currentThread());
            if (unmarshaller instanceof UpdateableClassloaderUnMarshaller) {
                UpdateableClassloaderUnMarshaller uclum = (UpdateableClassloaderUnMarshaller)unmarshaller;
                ClassLoader cl = uclum.getClassLoader();
                if (cl instanceof RemotingClassLoader) {
                    rcl = (RemotingClassLoader)cl;
                    rcl.setUserClassLoader(contextClassLoader);
                } else {
                    rcl = MicroRemoteClientInvoker.createRemotingClassLoader(this.getClassLoader(), contextClassLoader, this.parentFirstClassLoading);
                    unmarshaller.setClassLoader(rcl);
                }
            } else {
                rcl = MicroRemoteClientInvoker.createRemotingClassLoader(this.getClassLoader(), contextClassLoader, this.parentFirstClassLoading);
                unmarshaller.setClassLoader(rcl);
            }
        }
        Object payload = null;
        Map metadata = invocationReq.getRequestPayload();
        payload = metadata != null && metadata.get("rawPayload") != null ? invocationReq.getParameter() : invocationReq;
        try {
            sessionId = invocationReq.getSessionId();
            returnValue = this.transport((String)sessionId, payload, metadata, marshaller, unmarshaller);
            sessionId = MicroRemoteClientInvoker.class;
        }
        catch (Throwable throwable) {
            Class clazz2 = MicroRemoteClientInvoker.class;
            synchronized (clazz2) {
                rcl.unsetUserClassLoader();
            }
            throw throwable;
        }
        synchronized (sessionId) {
            rcl.unsetUserClassLoader();
        }
        if (returnValue instanceof InvocationResponse) {
            InvocationResponse response = (InvocationResponse)returnValue;
            returnValue = response.getResult();
            if (response.isException()) {
                StackTraceElement[] serverStackTrace;
                Throwable e = (Throwable)returnValue;
                if (this.trace) {
                    log.trace((Object)(this + " received a server-side exception as response to the invocation: " + e));
                }
                if (e.getCause() != null) {
                    serverStackTrace = e.getCause().getStackTrace();
                    if (serverStackTrace == null || serverStackTrace.length == 0) {
                        serverStackTrace = e.getStackTrace();
                    }
                } else {
                    serverStackTrace = e.getStackTrace();
                }
                if (serverStackTrace == null || serverStackTrace.length == 0) {
                    log.warn((Object)("An exception occurred on the server side when making remote invocation.  The exception returned from server does not include a stack trace.  Original server side exception message is " + e.getMessage()), e);
                }
                Exception clientException = new Exception();
                StackTraceElement[] clientStackTrace = clientException.getStackTrace();
                StackTraceElement[] completeStackTrace = new StackTraceElement[serverStackTrace.length + clientStackTrace.length];
                System.arraycopy(serverStackTrace, 0, completeStackTrace, 0, serverStackTrace.length);
                System.arraycopy(clientStackTrace, 0, completeStackTrace, serverStackTrace.length, clientStackTrace.length);
                Throwable responseException = null;
                responseException = e instanceof ServerInvoker.InvalidStateException && this.changeInvalidStateToCannotConnect ? new CannotConnectException(e.getMessage(), e.getCause()) : e;
                if (e.getCause() != null) {
                    responseException.getCause().setStackTrace(completeStackTrace);
                } else {
                    responseException.setStackTrace(completeStackTrace);
                }
                throw responseException;
            }
            if (this.trace) {
                log.trace((Object)(this + " received InvocationResponse so going to return response's return value of " + returnValue));
            }
        }
        return returnValue;
    }

    protected void preProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload) {
    }

    protected void postProcess(String sessionId, Object param, Map sendPayload, Map receivedPayload) {
    }

    protected abstract Object transport(String var1, Object var2, Map var3, Marshaller var4, UnMarshaller var5) throws IOException, ConnectionFailedException, ClassNotFoundException;

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void connect() throws ConnectionFailedException {
        if (!this.connected) {
            log.debug((Object)(this + " connecting"));
            this.connectHomes = this.locator.getConnectHomeList();
            if (this.locator.isMultihome() && this.connectHomes.isEmpty()) {
                this.connectHomes = this.locator.getHomeList();
            }
            this.handleConnect();
            this.connected = true;
            log.debug((Object)(this + " connected"));
        }
    }

    protected abstract void handleConnect() throws ConnectionFailedException;

    protected abstract void handleDisconnect();

    public synchronized void disconnect() {
        if (this.trace) {
            log.trace((Object)(this + " disconnecting ..."));
        }
        if (this.connected) {
            this.connected = false;
            this.handleDisconnect();
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader != null && classLoader instanceof ClassByteClassLoader) {
                this.classbyteloader.destroy();
            }
            if (this.trace) {
                log.trace((Object)(this + " disconnected"));
            }
        } else if (this.trace) {
            log.trace((Object)(this + " is not connected!"));
        }
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setUnMarshaller(UnMarshaller unmarshaller) {
        ClassLoader classLoader = MicroRemoteClientInvoker.getContextClassLoader(Thread.currentThread());
        this.unmarshallers.put(classLoader, unmarshaller);
    }

    public UnMarshaller getUnMarshaller() {
        ClassLoader classLoader = MicroRemoteClientInvoker.getContextClassLoader(Thread.currentThread());
        return (UnMarshaller)this.unmarshallers.get(classLoader);
    }

    public String getSessionId() {
        return this.invokerSessionID;
    }

    public String getLeaseCreationTimeout() {
        return this.leaseCreationTimeout;
    }

    public void setLeaseCreationTimeout(String leaseCreationTimeout) {
        this.leaseCreationTimeout = leaseCreationTimeout;
    }

    public void terminateLease(String sessionId, int disconnectTimeout) {
        this.terminateLease(sessionId, disconnectTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateLease(String sessionId, int disconnectTimeout, LeasePinger passedLeasePinger) {
        Object object = this.clientLeaseLock;
        synchronized (object) {
            if (passedLeasePinger != null && passedLeasePinger != this.leasePinger) {
                if (this.trace) {
                    log.trace((Object)(this + ": " + passedLeasePinger + " != " + this.leasePinger));
                }
                return;
            }
            if (this.trace) {
                log.trace((Object)(this + " entering terminateLease() for " + this.leasePinger));
            }
            if (this.leasePinger != null) {
                if (disconnectTimeout == -1) {
                    disconnectTimeout = Integer.parseInt(this.leaseCreationTimeout);
                }
                this.leasePinger.setDisconnectTimeout(disconnectTimeout);
                if (sessionId == null) {
                    if (this.trace) {
                        log.trace((Object)(this + " shutting down LeasePinger: " + this.leasePinger));
                    }
                    try {
                        this.leasePinger.stopPing();
                    }
                    catch (Exception e) {
                        log.debug((Object)("error shutting down lease pinger" + e.getMessage()));
                        log.trace((Object)"error shutting down lease pinger", (Throwable)e);
                    }
                    this.leasePinger = null;
                } else {
                    boolean isLastClientLease;
                    if (this.trace) {
                        log.trace((Object)(this + " removing client " + sessionId + " from LeasePinger: " + this.leasePinger));
                    }
                    if (isLastClientLease = this.leasePinger.removeClient(sessionId)) {
                        if (this.trace) {
                            log.trace((Object)(this + " shutting down LeasePinger, " + sessionId + " was last client lease: " + this.leasePinger));
                        }
                        try {
                            this.leasePinger.stopPing();
                        }
                        catch (Exception e) {
                            log.debug((Object)"error shutting down lease pinger");
                        }
                        this.leasePinger = null;
                    }
                }
            } else if (this.trace) {
                log.trace((Object)(this + " leasePinger is null: must have been shut down already"));
            }
            if (this.trace) {
                log.trace((Object)(this + " leaving terminateLease() for " + this.leasePinger));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLeasePeriod(String sessionID) {
        Object object = this.clientLeaseLock;
        synchronized (object) {
            if (this.leasePinger == null) {
                return -1L;
            }
            return this.leasePinger.getLeasePeriod(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void establishLease(String clientSessionID, Map configuration, long leasePeriod) throws Throwable {
        Client client = (Client)configuration.get("client");
        ConnectionListener listener = (ConnectionListener)configuration.remove("connectionListener");
        boolean useClientConnectionIdentity = false;
        if (configuration != null) {
            Object o = configuration.get("useClientConnectionIdentity");
            if (o instanceof String) {
                useClientConnectionIdentity = Boolean.valueOf((String)o);
            } else if (o != null) {
                log.warn((Object)("value of useClientConnectionIdentity must be a String: " + o));
            }
        }
        Object object = this.clientLeaseLock;
        synchronized (object) {
            if (this.leasePinger != null) {
                this.leasePinger.addClient(clientSessionID, configuration, leasePeriod);
                if (this.trace) {
                    log.trace((Object)(this + " added client with session ID " + clientSessionID + " to " + this.leasePinger));
                }
            } else {
                try {
                    InvocationResponse resp;
                    Boolean shouldLease;
                    InvocationRequest ir;
                    Object ret;
                    if (this.trace) {
                        log.trace((Object)(this + " sending initial lease ping to server to determine if server has leasing enabled."));
                    }
                    String leasePingerId = new GUID().toString();
                    HashMap<String, String> requestMap = new HashMap<String, String>();
                    requestMap.put("leasePingerId", leasePingerId);
                    requestMap.put("timeStamp", Long.toString(System.currentTimeMillis()));
                    requestMap.put("timeout", this.leaseCreationTimeout);
                    if (this.trace) {
                        log.trace((Object)(this + " initiating lease for leasePingerId " + leasePingerId));
                    }
                    if ((ret = this.invoke(ir = new InvocationRequest(this.invokerSessionID, null, "$PING$", requestMap, new HashMap(), null))) instanceof InvocationResponse && (shouldLease = (Boolean)(resp = (InvocationResponse)ret).getResult()).booleanValue()) {
                        Long leaseTimeoutValue;
                        long serverDefaultLeasePeriod;
                        long defaultLeasePeriod = 5000L;
                        Map respMap = resp.getPayload();
                        if (respMap != null && (serverDefaultLeasePeriod = (leaseTimeoutValue = (Long)respMap.get("clientLeasePeriod")).longValue()) > 0L) {
                            defaultLeasePeriod = serverDefaultLeasePeriod;
                        }
                        if (this.trace) {
                            log.trace((Object)("server does have leasing enabled (with default lease period of " + defaultLeasePeriod + ") and will start a new lease pinger."));
                        }
                        this.leasePinger = new LeasePinger(this, this.invokerSessionID, defaultLeasePeriod, configuration);
                        this.leasePinger.setLeasePingerId(leasePingerId);
                        this.leasePinger.setUseClientConnectionIdentity(useClientConnectionIdentity);
                        this.leasePinger.addClient(clientSessionID, configuration, leasePeriod);
                        this.leasePinger.startPing();
                    }
                }
                catch (Throwable throwable) {
                    Exception e = new Exception("Error setting up client lease");
                    e.initCause(throwable);
                    throw e;
                }
            }
            if (this.trace) {
                log.trace((Object)(this + ": client = " + client + ", listener = " + listener));
            }
            if (client != null && listener != null) {
                client.addConnectionListener(listener, configuration);
            }
        }
    }

    private String getDataType() {
        if (this.dataType == null) {
            String localDataType = this.getDataType(this.getLocator());
            if (localDataType == null) {
                localDataType = this.getDefaultDataType();
            }
            this.dataType = localDataType;
        }
        return this.dataType;
    }

    private String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null && (type = (String)params.get("datatype")) == null) {
            type = (String)params.get("dataType");
        }
        return type;
    }

    protected void init() {
        String sflag;
        Object flag = super.getConfiguration().get("classloadingParentFirstDelegation");
        if (flag == null) {
            flag = MicroRemoteClientInvoker.getSystemProperty("org.jboss.remoting.classloadingParentFirstDelegation");
        }
        boolean parentFirst = true;
        if (flag != null) {
            sflag = flag.toString();
            parentFirst = Boolean.valueOf(sflag);
        }
        this.parentFirstClassLoading = parentFirst;
        flag = this.configuration.get("changeInvalidStateToCannotConnect");
        if (flag != null) {
            sflag = flag.toString();
            this.changeInvalidStateToCannotConnect = Boolean.valueOf(sflag);
        }
        if ((flag = this.configuration.get("leaseCreationTimeout")) != null) {
            sflag = flag.toString();
            try {
                Integer.valueOf(sflag);
                this.leaseCreationTimeout = sflag;
            }
            catch (NumberFormatException e) {
                log.warn((Object)(this + " value of " + "leaseCreationTimeout" + " should be in numeric form: " + sflag + ", using " + LEASE_CREATION_TIMEOUT_DEFAULT));
            }
        }
    }

    protected abstract String getDefaultDataType();

    protected List getConnectHomes() {
        return this.connectHomes;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected LeasePinger getLeasePinger() {
        return this.leasePinger;
    }

    private static String getSystemProperty(final String name) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static RemotingClassLoader createRemotingClassLoader(final ClassLoader remotingClassLoader, final ClassLoader userClassLoader, final boolean parentFirstDelegation) {
        if (SecurityUtility.skipAccessControl()) {
            return new RemotingClassLoader(remotingClassLoader, userClassLoader, parentFirstDelegation);
        }
        return (RemotingClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new RemotingClassLoader(remotingClassLoader, userClassLoader, parentFirstDelegation);
            }
        });
    }

    private static ClassLoader getContextClassLoader(final Thread thread) {
        if (SecurityUtility.skipAccessControl()) {
            return thread.getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return thread.getContextClassLoader();
            }
        });
    }
}

