/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.ApplicationServerShutdownMethod;
import org.rhq.plugins.jbossas5.ApplicationServerSupportedOperations;

public class ApplicationServerOperationsDelegate {
    private static long STOP_WAIT_MAX = 150000L;
    private static final long STOP_WAIT_INTERVAL = 5000L;
    private static final long STOP_WAIT_FINAL = 30000L;
    private static long START_WAIT_MAX = 300000L;
    private static final long START_WAIT_INTERVAL = 5000L;
    private final Log log = LogFactory.getLog(ApplicationServerOperationsDelegate.class);
    private static final String SEPARATOR = "\n-----------------------\n";
    static final String DEFAULT_START_SCRIPT = "bin" + File.separator + "run." + (File.separatorChar == '/' ? "sh" : "bat");
    static final String DEFAULT_SHUTDOWN_SCRIPT = "bin" + File.separator + "shutdown." + (File.separatorChar == '/' ? "sh" : "bat");
    private ApplicationServerComponent serverComponent;
    private File configPath;

    public ApplicationServerOperationsDelegate(ApplicationServerComponent serverComponent) {
        this.serverComponent = serverComponent;
    }

    public OperationResult invoke(ApplicationServerSupportedOperations operation, Configuration parameters) throws InterruptedException {
        OperationResult result = null;
        switch (operation) {
            case START: {
                result = this.start();
                break;
            }
            case SHUTDOWN: {
                result = this.shutDown();
                break;
            }
            case RESTART: {
                result = this.restart();
            }
        }
        return result;
    }

    private OperationResult start() throws InterruptedException {
        OperationResult result;
        AvailabilityType avail = this.serverComponent.getAvailability();
        if (avail == AvailabilityType.UP) {
            OperationResult result2 = new OperationResult();
            result2.setErrorMessage("The server is already started.");
            return result2;
        }
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        StartScriptConfiguration startScriptConfig = new StartScriptConfiguration(pluginConfig);
        File startScriptFile = this.getStartScriptPath(startScriptConfig);
        this.validateScriptFile(startScriptFile, "startScript");
        String prefix = pluginConfig.getSimpleValue("scriptPrefix", null);
        if (prefix != null && prefix.replaceAll("\\s", "").equals("")) {
            prefix = null;
        }
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)prefix, (File)startScriptFile);
        this.addProcessExecutionArguments(processExecution, startScriptFile, startScriptConfig, false);
        Map startScriptEnv = startScriptConfig.getStartScriptEnv();
        if (!startScriptEnv.isEmpty()) {
            for (String envVarName : startScriptEnv.keySet()) {
                String envVarValue = (String)startScriptEnv.get(envVarName);
                startScriptEnv.put(envVarName, envVarValue);
            }
            processExecution.setEnvironmentVariables(startScriptEnv);
        } else {
            this.setJavaHomeEnvironmentVariable(processExecution);
        }
        this.initProcessExecution(processExecution, startScriptFile);
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        SystemInfo systemInfo = this.serverComponent.getResourceContext().getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() == null) {
            avail = this.waitForServerToStart(start);
        } else {
            this.log.error((Object)("Error from process execution while starting the AS instance. Exit code [" + results.getExitCode() + "]"), results.getError());
            avail = this.serverComponent.getAvailability();
        }
        if (avail == AvailabilityType.DOWN) {
            result = new OperationResult();
            result.setErrorMessage("The server failed to start: " + results.getCapturedOutput());
        } else {
            result = new OperationResult("The server has been started.");
        }
        return result;
    }

    private void addProcessExecutionArguments(ProcessExecution processExecution, File startScriptFile, StartScriptConfiguration startScriptConfig, boolean asSingleArg) {
        List startScriptArgs = startScriptConfig.getStartScriptArgs();
        if (startScriptArgs.isEmpty()) {
            startScriptArgs.add("-c");
            startScriptArgs.add(this.getConfigurationSet());
            String bindAddress = startScriptConfig.getPluginConfig().getSimpleValue("bindAddress", null);
            if (bindAddress != null) {
                startScriptArgs.add("-b");
                startScriptArgs.add(bindAddress);
            }
        }
        if (asSingleArg) {
            StringBuilder sb = new StringBuilder(startScriptFile.getAbsolutePath());
            for (String startScriptArg : startScriptArgs) {
                sb.append(" ");
                sb.append(startScriptArg);
            }
            processExecution.getArguments().add(sb.toString());
        } else {
            for (String startScriptArg : startScriptArgs) {
                processExecution.getArguments().add(startScriptArg);
            }
        }
    }

    private String getConfigurationSet() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        this.configPath = this.resolvePathRelativeToHomeDir(this.getRequiredPropertyValue(pluginConfig, "serverHomeDir"));
        if (!this.configPath.exists()) {
            throw new InvalidPluginConfigurationException("Configuration path '" + this.configPath + "' does not exist.");
        }
        return pluginConfig.getSimpleValue("serverName", this.configPath.getName());
    }

    private void initProcessExecution(ProcessExecution processExecution, File scriptFile) {
        processExecution.setWorkingDirectory(scriptFile.getParent());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(1000L);
        processExecution.setKillOnTimeout(false);
    }

    private void setJavaHomeEnvironmentVariable(ProcessExecution processExecution) {
        File javaHomeDir = this.getJavaHomePath();
        if (javaHomeDir == null) {
            throw new RuntimeException("JAVA_HOME environment variable must be specified via the 'javaHome' connection property in order to shut down the application server via script.");
        }
        this.validateJavaHomePathProperty();
        processExecution.getEnvironmentVariables().put("JAVA_HOME", javaHomeDir.getPath());
    }

    private OperationResult shutDown() {
        OperationResult result;
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        ApplicationServerShutdownMethod shutdownMethod = Enum.valueOf(ApplicationServerShutdownMethod.class, pluginConfig.getSimple("shutdownMethod").getStringValue());
        String errorMessage = null;
        String resultMessage = null;
        try {
            resultMessage = ApplicationServerShutdownMethod.JMX.equals((Object)shutdownMethod) ? this.shutdownViaJmx() : this.shutdownViaScript();
        }
        catch (ExecutionFailedException e) {
            errorMessage = e.getMessage();
        }
        AvailabilityType avail = this.waitForServerToShutdown();
        if (avail == AvailabilityType.UP) {
            result = new OperationResult();
            result.setErrorMessage("The server failed to shut down.");
        } else {
            result = new OperationResult();
            result.setSimpleResult(resultMessage);
            result.setErrorMessage(errorMessage);
        }
        return result;
    }

    private String shutdownViaScript() throws ExecutionFailedException {
        String password;
        String user;
        File shutdownScriptFile = this.getShutdownScriptPath();
        this.validateScriptFile(shutdownScriptFile, "shutdownScript");
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String prefix = pluginConfig.getSimple("scriptPrefix").getStringValue();
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)prefix, (File)shutdownScriptFile);
        this.initProcessExecution(processExecution, shutdownScriptFile);
        this.setJavaHomeEnvironmentVariable(processExecution);
        String server = pluginConfig.getSimple("namingURL").getStringValue();
        if (server != null) {
            processExecution.getArguments().add("--server=" + server);
        }
        if ((user = pluginConfig.getSimple("principal").getStringValue()) != null) {
            processExecution.getArguments().add("--user=" + user);
        }
        if ((password = pluginConfig.getSimple("credentials").getStringValue()) != null) {
            processExecution.getArguments().add("--password=" + password);
        }
        processExecution.getArguments().add("--shutdown");
        processExecution.getEnvironmentVariables().put("NOPAUSE", "1");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        SystemInfo systemInfo = this.serverComponent.getResourceContext().getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null || results.getExitCode() != 0) {
            throw new ExecutionFailedException("Error executing shutdown script while stopping AS instance. Shutdown script returned exit code [" + results.getExitCode() + "]" + (results.getError() != null ? ": " + results.getError().getMessage() : ""), results.getError());
        }
        return "The server has been shut down.";
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        this.log.info((Object)("Exit code from process execution: " + results.getExitCode()));
        this.log.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    private String shutdownViaJmx() throws ExecutionFailedException {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String mbeanName = pluginConfig.getSimple("shutdownMBeanName").getStringValue();
        String operationName = pluginConfig.getSimple("shutdownMBeanOperation").getStringValue();
        EmsConnection connection = this.serverComponent.getEmsConnection();
        if (connection == null) {
            throw new ExecutionFailedException("Can not connect to the server");
        }
        EmsBean bean = connection.getBean(mbeanName);
        EmsOperation operation = bean.getOperation(operationName);
        try {
            List params = operation.getParameters();
            int count = params.size();
            if (count == 0) {
                operation.invoke(new Object[0]);
            } else {
                operation.invoke(new Object[]{0});
            }
        }
        catch (RuntimeException e) {
            throw new ExecutionFailedException("Shutting down the server using JMX failed: " + e.getMessage(), e);
        }
        return "The server has been shut down.";
    }

    private void validateScriptFile(File scriptFile, String scriptPropertyName) {
        if (!scriptFile.exists()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property does not exist.");
        }
        if (scriptFile.isDirectory()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property is a directory, not a file.");
        }
    }

    private OperationResult restart() {
        try {
            this.shutDown();
        }
        catch (Exception e) {
            throw new RuntimeException("Shutdown may have failed: " + e);
        }
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Start following shutdown may have failed: " + e);
        }
        return new OperationResult("Server has been restarted.");
    }

    private AvailabilityType waitForServerToStart(long start) throws InterruptedException {
        AvailabilityType avail;
        int newValue;
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        PropertySimple property = pluginConfig.getSimple("startWaitMax");
        if (property != null && property.getIntegerValue() != null && (newValue = property.getIntegerValue().intValue()) >= 1) {
            START_WAIT_MAX = 60000L * (long)newValue;
        }
        while ((avail = this.serverComponent.getAvailability()) == AvailabilityType.DOWN && System.currentTimeMillis() < start + START_WAIT_MAX) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
        return avail;
    }

    private AvailabilityType waitForServerToShutdown() {
        AvailabilityType avail;
        int newValue;
        long start = System.currentTimeMillis();
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        PropertySimple property = pluginConfig.getSimple("stopWaitMax");
        if (property != null && property.getIntegerValue() != null && (newValue = property.getIntegerValue().intValue()) >= 1) {
            STOP_WAIT_MAX = 60000L * (long)newValue;
        }
        while ((avail = this.serverComponent.getAvailability()) == AvailabilityType.UP && System.currentTimeMillis() < start + STOP_WAIT_MAX) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return avail;
    }

    @NotNull
    public File getStartScriptPath(StartScriptConfiguration startScriptConfig) {
        File startScriptFile = startScriptConfig.getStartScript();
        if (null == startScriptFile) {
            startScriptFile = this.resolvePathRelativeToHomeDir(DEFAULT_START_SCRIPT);
        }
        return startScriptFile;
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(@NotNull String path) {
        return this.resolvePathRelativeToHomeDir(this.serverComponent.getResourceContext().getPluginConfiguration(), path);
    }

    @NotNull
    private File resolvePathRelativeToHomeDir(Configuration pluginConfig, @NotNull String path) {
        File configDir = new File(path);
        if (!configDir.isAbsolute()) {
            String jbossHomeDir = this.getRequiredPropertyValue(pluginConfig, "homeDir");
            configDir = new File(jbossHomeDir, path);
        }
        return configDir;
    }

    @NotNull
    private String getRequiredPropertyValue(@NotNull Configuration config, @NotNull String propName) {
        String propValue = config.getSimpleValue(propName, null);
        if (propValue == null) {
            throw new IllegalStateException("Required property '" + propName + "' is not set.");
        }
        return propValue;
    }

    @NotNull
    public File getShutdownScriptPath() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String shutdownScript = pluginConfig.getSimpleValue("shutdownScript", DEFAULT_SHUTDOWN_SCRIPT);
        File shutdownScriptFile = this.resolvePathRelativeToHomeDir(shutdownScript);
        return shutdownScriptFile;
    }

    @Nullable
    public File getJavaHomePath() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String javaHomePath = pluginConfig.getSimpleValue("javaHome", null);
        File javaHome = javaHomePath != null ? new File(javaHomePath) : null;
        return javaHome;
    }

    void validateJavaHomePathProperty() {
        Configuration pluginConfig = this.serverComponent.getResourceContext().getPluginConfiguration();
        String javaHome = pluginConfig.getSimpleValue("javaHome", null);
        if (javaHome != null) {
            File javaHomeDir = new File(javaHome);
            if (!javaHomeDir.isAbsolute()) {
                throw new InvalidPluginConfigurationException("javaHome connection property ('" + javaHomeDir + "') is not an absolute path. Note, on Windows, absolute paths must start with the drive letter (e.g. C:).");
            }
            if (!javaHomeDir.exists()) {
                throw new InvalidPluginConfigurationException("javaHome connection property ('" + javaHomeDir + "') does not exist.");
            }
            if (!javaHomeDir.isDirectory()) {
                throw new InvalidPluginConfigurationException("javaHome connection property ('" + javaHomeDir + "') is not a directory.");
            }
        }
    }

    private static class ExecutionFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExecutionFailedException() {
        }

        public ExecutionFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public ExecutionFailedException(String message) {
            super(message);
        }

        public ExecutionFailedException(Throwable cause) {
            super(cause);
        }
    }
}

