/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.url;

import java.net.URL;
import org.rhq.enterprise.server.plugin.pc.content.ContentProviderPackageDetails;
import org.rhq.enterprise.server.plugins.url.RemotePackageInfo;

public class FullRemotePackageInfo
extends RemotePackageInfo {
    private final ContentProviderPackageDetails details;

    public FullRemotePackageInfo(URL url, ContentProviderPackageDetails details) {
        super(details.getLocation(), url, details.getSHA256());
        this.details = details;
        RemotePackageInfo.SupportedPackageType type = new RemotePackageInfo.SupportedPackageType();
        type.packageTypeName = details.getPackageTypeName();
        type.architectureName = details.getArchitectureName();
        type.resourceTypeName = details.getContentProviderPackageDetailsKey().getResourceTypeName();
        type.resourceTypePluginName = details.getContentProviderPackageDetailsKey().getResourceTypePluginName();
        this.setSupportedPackageType(type);
    }

    public ContentProviderPackageDetails getContentSourcePackageDetails() {
        return this.details;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("FullRemotePackageInfo: ");
        str.append("location=[").append(this.getLocation());
        str.append("], url=[").append(this.getUrl());
        str.append("], sha256=[").append(this.getSHA256());
        if (this.getSupportedPackageType() != null) {
            str.append("], supportedPackageType=[").append(this.getSupportedPackageType().packageTypeName);
            str.append(",").append(this.getSupportedPackageType().architectureName);
            str.append(",").append(this.getSupportedPackageType().resourceTypeName);
            str.append(",").append(this.getSupportedPackageType().resourceTypePluginName);
            str.append("], ");
        } else {
            str.append("], supportedPackageType=[unknown], ");
        }
        str.append("details=[" + this.details + "]");
        return str.toString();
    }
}

