/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.authz.RequiredPermissions;
import org.rhq.enterprise.server.util.LookupUtil;

public class RequiredPermissionsInterceptor {
    private static Log LOG = LogFactory.getLog(RequiredPermissionsInterceptor.class);

    @AroundInvoke
    public Object checkRequiredPermissions(InvocationContext invocation_context) throws Exception {
        try {
            HashMap<Permission, String> perms_errors_list = new HashMap<Permission, String>();
            Method method = invocation_context.getMethod();
            RequiredPermissions perms_anno = method.getAnnotation(RequiredPermissions.class);
            RequiredPermission perm_anno = method.getAnnotation(RequiredPermission.class);
            if (perms_anno != null && perms_anno.value().length > 0) {
                for (RequiredPermission rq : perms_anno.value()) {
                    perms_errors_list.put(rq.value(), rq.error());
                }
            }
            if (perm_anno != null && perm_anno.value() != null) {
                perms_errors_list.put(perm_anno.value(), perm_anno.error());
            }
            Subject subject = null;
            Object[] params = invocation_context.getParameters();
            if (params != null && params.length > 0 && params[0] instanceof Subject) {
                subject = (Subject)params[0];
            }
            if (subject != null) {
                if (subject.getSessionId() != null) {
                    SubjectManagerLocal subject_manager = LookupUtil.getSubjectManager();
                    if (!subject_manager.isValidSessionId(subject.getSessionId(), subject.getName(), subject.getId())) {
                        throw this.buildPermissionException("The session ID for user [" + subject.getName() + "] is invalid!", invocation_context);
                    }
                } else {
                    throw this.buildPermissionException("The subject [" + subject.getName() + "] did not have a session", invocation_context);
                }
            }
            if (perms_errors_list.size() > 0) {
                if (subject == null) {
                    throw this.buildPermissionException("Method requires permissions but does not have a subject parameter", invocation_context);
                }
                AuthorizationManagerLocal authorization_manager = LookupUtil.getAuthorizationManager();
                Set required_permissions = perms_errors_list.keySet();
                Set<Permission> subject_permissions = authorization_manager.getExplicitGlobalPermissions(subject);
                for (Permission required_permission : required_permissions) {
                    if (!Permission.Target.GLOBAL.equals((Object)required_permission.getTarget())) {
                        throw this.buildPermissionException("@RequiredPermissions must be Permission.Target.GLOBAL: [" + required_permission + "]", invocation_context);
                    }
                    if (subject_permissions.contains(required_permission)) continue;
                    String perm_error = (String)perms_errors_list.get(required_permission);
                    String full_error = "Subject [" + subject.getName() + "] is not authorized for [" + required_permission + "]";
                    if (perm_error != null && perm_error.length() > 0) {
                        full_error = perm_error + ": " + full_error;
                    }
                    throw this.buildPermissionException(full_error, invocation_context);
                }
            }
        }
        catch (PermissionException pe) {
            LOG.debug((Object)"Interceptor detected a permission exception", (Throwable)pe);
            throw pe;
        }
        catch (Exception e) {
            PermissionException ex = this.buildPermissionException("Failed to check required permissions to invoke: ", invocation_context, e);
            LOG.debug((Object)"Permission Exception", (Throwable)ex);
            throw ex;
        }
        return invocation_context.proceed();
    }

    private PermissionException buildPermissionException(String message, InvocationContext context) {
        return this.buildPermissionException(message, context, null);
    }

    private PermissionException buildPermissionException(String message, InvocationContext context, Exception e) {
        return new PermissionException(message + ": " + this.getInvocationString(context), e);
    }

    private String getInvocationString(InvocationContext invocation) {
        StringBuffer buf = new StringBuffer("invocation: ");
        buf.append("method=" + invocation.getMethod().toGenericString());
        buf.append(",context-data=" + invocation.getContextData());
        return buf.toString();
    }
}

