/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.install.remote;

import javax.ejb.Stateless;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.install.remote.AgentInstallInfo;
import org.rhq.core.domain.install.remote.RemoteAccessInfo;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerLocal;
import org.rhq.enterprise.server.install.remote.RemoteInstallManagerRemote;
import org.rhq.enterprise.server.install.remote.SSHInstallUtility;

@Stateless
public class RemoteInstallManagerBean
implements RemoteInstallManagerLocal,
RemoteInstallManagerRemote {
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AgentInstallInfo agentInstallCheck(Subject subject, RemoteAccessInfo remoteAccessInfo) {
        SSHInstallUtility sshUtil = new SSHInstallUtility(remoteAccessInfo);
        return sshUtil.installAgent();
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AgentInstallInfo installAgent(Subject subject, RemoteAccessInfo remoteAccessInfo, String path) {
        SSHInstallUtility sshUtil = new SSHInstallUtility(remoteAccessInfo);
        return sshUtil.installAgent();
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public String[] remotePathDiscover(Subject subject, RemoteAccessInfo remoteAccessInfo, String parentPath) {
        SSHInstallUtility ssh = new SSHInstallUtility(remoteAccessInfo);
        ssh.connect();
        return ssh.pathDiscovery(parentPath);
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public String startAgent(Subject subject, RemoteAccessInfo remoteAccessInfo) {
        SSHInstallUtility sshUtil = new SSHInstallUtility(remoteAccessInfo);
        return sshUtil.agentStart();
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public String stopAgent(Subject subject, RemoteAccessInfo remoteAccessInfo) {
        SSHInstallUtility sshUtil = new SSHInstallUtility(remoteAccessInfo);
        return sshUtil.agentStop();
    }

    public String agentStatus(Subject subject, RemoteAccessInfo remoteAccessInfo) {
        if (remoteAccessInfo.getHost() == null) {
            return "Enter a host";
        }
        SSHInstallUtility sshUtil = new SSHInstallUtility(remoteAccessInfo);
        return sshUtil.agentStatus();
    }
}

