/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.license;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.license.CorruptLicenseException;
import org.rhq.enterprise.server.license.ExpirationTag;
import org.rhq.enterprise.server.license.FeatureUnavailableException;
import org.rhq.enterprise.server.license.LRES;
import org.rhq.enterprise.server.license.License;
import org.rhq.enterprise.server.license.LicenseException;
import org.rhq.enterprise.server.license.LicenseParser;
import org.rhq.enterprise.server.license.LicenseParsingException;
import org.rhq.enterprise.server.license.LicenseStoreManager;
import org.rhq.enterprise.server.license.PlatformLimitException;
import org.rhq.enterprise.server.license.UnavailableLicenseException;
import org.rhq.enterprise.server.license.UpdateTrialLicenseException;

public final class LicenseManager
implements Runnable,
Serializable {
    private static final long serialVersionUID = -3229197855347715264L;
    public static final int FEATURE_MONITOR = 2;
    private static final long WARN_EXPIRE_MILLIS = 2592000000L;
    private static Log log = LogFactory.getLog((String)LRES.get("\\hj+]`Gu.}B#/Xe`KC3~Uem)i_<)eD}BS}cuHWUV<U{hqio:.u."));
    private static LicenseManager _instance = new LicenseManager();
    private static volatile boolean _jndiBound = false;
    protected transient InitialContext ic = null;
    protected String JNDI_NAME = LRES.get("\\hj+]`Gu.}B#/Xe`KC3~Uem)i_<)eD}BS}cuHWUV<U{hqio:.u.");
    private License _license;
    private transient Thread _expirationEnforcementThread = null;
    private boolean licenseLoaded = false;
    private boolean licenseExpired = false;

    private LicenseManager() {
        try {
            this.ic = new InitialContext();
        }
        catch (Exception e) {
            LicenseManager.doHalt("HwfYs$J@ecpT6J8w.v,'oKgx{RktZwpP>6", e);
        }
    }

    public static LicenseManager instance() {
        if (!_jndiBound) {
            _instance.bind();
        }
        try {
            return (LicenseManager)LicenseManager._instance.ic.lookup(LicenseManager._instance.JNDI_NAME);
        }
        catch (Exception e) {
            LicenseManager.doHalt("M]=Lro|c?mg5!vl@Dy=^,3{fF9=*<", e);
            throw new IllegalStateException();
        }
    }

    private synchronized void bind() {
        if (_jndiBound) {
            return;
        }
        try {
            this.ic.rebind(this.JNDI_NAME, (Object)_instance);
        }
        catch (Exception e) {
            LicenseManager.doHalt("w<&mBAPT45Ci/]Ix?o&u\\|s)Ry%O%swCi/YTgwW", e);
            throw new IllegalStateException();
        }
    }

    public static void checkLicense(InputStream licenseFile) throws LicenseParsingException, UnavailableLicenseException, CorruptLicenseException, UpdateTrialLicenseException {
        LicenseParser lp = new LicenseParser();
        License license = lp.parse(licenseFile);
        LicenseStoreManager.store(license);
    }

    private final void initialize(String licenseFile) {
        File lfile = new File(licenseFile);
        try {
            if (!lfile.exists()) {
                throw new FileNotFoundException(licenseFile);
            }
            LicenseParser lp = new LicenseParser();
            this._license = lp.parse(lfile);
            this.licenseLoaded = true;
        }
        catch (Exception e) {
            this.licenseLoaded = false;
        }
    }

    protected static final void doHalt(String msg, Exception e) {
        LicenseManager.doHaltThrowable(msg, e);
    }

    private static final void doHaltThrowable(String msg, Throwable t) {
        if (t != null) {
            log.error((Object)(LRES.get(msg) + ": " + t + "\n\n" + LRES.get("=}BS}cW)5,_~mb)")));
        } else {
            log.error((Object)(LRES.get(msg) + "\n\n" + LRES.get("=}BS}cW)5,_~mb)")));
        }
        throw new IllegalStateException();
    }

    protected static final void doHalt(String msg) {
        LicenseManager.doHalt(msg, null);
    }

    public final void doStartupCheck(String licenseFile) {
        try {
            this.initialize(licenseFile);
            log.info((Object)this._license.toString());
            this.enforceExpiration();
            this.enforceServerIp();
        }
        catch (Exception e) {
        }
        catch (Throwable t) {
            throw new IllegalStateException();
        }
    }

    public boolean isLicenseExpired() {
        return this.licenseExpired;
    }

    public boolean isLicenseLoaded() {
        return this.licenseLoaded;
    }

    private final void enforceExpiration() {
        this.licenseExpired = false;
        if (this._license == null || this._license.getIsPerpetualLicense()) {
            return;
        }
        long ex = 0L;
        try {
            ex = LicenseStoreManager.store(this._license);
        }
        catch (LicenseException le) {
            this.licenseExpired = true;
            log.warn((Object)le.getMessage());
        }
        long diff = ex - System.currentTimeMillis();
        if (diff < 0L) {
            this.licenseExpired = true;
        } else if (diff < 2592000000L) {
            log.warn((Object)(LRES.get("kOl8,.6.|Z\"l6Dt6U~s_towZP1$VO;lPHk+Zej[1k-Zwp%W6JF*%r+FlKaH~M$zoEc +~9K[.=T.+o:c~]~9!}jv15{2}jeTk(Cf.?T\"JZwc") + ExpirationTag.DFORMAT.format(new Date(ex))));
        }
        if (this._expirationEnforcementThread == null) {
            this._expirationEnforcementThread = new Thread(this);
            this._expirationEnforcementThread.setDaemon(true);
            this._expirationEnforcementThread.start();
        }
    }

    public void run() {
        long millisInDay = 86400000L;
        while (true) {
            try {
                Thread.sleep(millisInDay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.enforceExpiration();
        }
    }

    private final void enforceServerIp() {
    }

    public boolean isPluginEnabled(String name) {
        if (this._license == null || this._license.getIsAnyPluginOk()) {
            return true;
        }
        boolean enabled = this._license.getPlugins().contains(name);
        return enabled;
    }

    public void enforcePlatformLimit(int count) throws PlatformLimitException {
        if (this._license == null) {
            return;
        }
        if (this._license.getPlatformsUnlimited()) {
            return;
        }
        if (count > this._license.getPlatformLimit()) {
            String msg = LRES.get("tR5o~z4. jP|zW.X5SHIdDR8z~m>)()S-zk)GUV<U~osj/{=~wzUV.$k7y+/-'k7jiV.I~biAc{z4wK]qTnW7y2/:)XojUc}Dh)idA._k.N*#-I[bz,S}z4D}BS}cW)i2_Y$,mXi/YD?oN)3-GhEj.c{`4`K)o.Ik8X") + this._license.getPlatformLimit();
            throw new PlatformLimitException(msg, this._license.getPlatformLimit());
        }
    }

    public void enforceFeatureLimit(int feature) throws FeatureUnavailableException {
        LicenseManager.enforceFeatureLimit(this._license, feature);
    }

    public static void enforceFeatureLimit(License license, int feature) throws FeatureUnavailableException {
        if (license != null && (license.getSupportLevel() & feature) == 0) {
            switch (feature) {
                case 2: {
                    throw new FeatureUnavailableException("Monitor feature is not supported");
                }
            }
            throw new FeatureUnavailableException("Unknown feature " + feature + " is not supported");
        }
    }

    public License getLicense() {
        return this._license;
    }

    public static String getLicenseFileName() {
        return LRES.get("R73u7y2Fk#:");
    }

    public long getExpiration() throws LicenseException {
        if (this._license == null || this._license.getIsPerpetualLicense()) {
            return -1L;
        }
        return LicenseStoreManager.store(this._license);
    }

    public String getLicenseInfoString() {
        return this._license.toString();
    }
}

