/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.license;

import java.util.prefs.Preferences;
import org.rhq.enterprise.server.license.BackingStore;
import org.rhq.enterprise.server.license.CorruptLicenseException;
import org.rhq.enterprise.server.license.LRES;
import org.rhq.enterprise.server.license.License;
import org.rhq.enterprise.server.license.UnavailableLicenseException;
import org.rhq.enterprise.server.license.UpdateTrialLicenseException;

public class LicenseStoreManager {
    private static long CUT_POINT = 424242L;
    private static final String PREFIX_EXPIRATION = " ZQVA`#MFBiY+\"M4}pi+F<>}Yr,Fg@;H8";
    private static final String PREFIX_DIV = "uFd>R3\"l?`ECHel-5@EH?2Y_yepz7-J";
    private static final String PREFIX_MOD = "QMG`ECH6lYnNeZ6/sJnel 3G9_*\\,l";
    private static final String PREFIX_TRIAL = "i,S,=ygsBSFzy^Rd";
    private static final String PREFIX_MAJOR_KEY = "CA\"1ye2UV<U~gHnS`";

    private LicenseStoreManager() {
    }

    public static long store(License license) throws UnavailableLicenseException, CorruptLicenseException, UpdateTrialLicenseException {
        if (!BackingStore.isAvailable()) {
            throw new UnavailableLicenseException(LRES.get("7.z|_(I{*;8e:mu)GUV<U{hX:AQ$TEjUc}IjE}dSx&x)~dS:cu)>|o.DYwX*XDGy.j];~I;hy|qG=xw)2/Tc{b +"));
        }
        Preferences prefs = Preferences.userRoot();
        String str_expiration = prefs.get(PREFIX_EXPIRATION, "");
        String str_major_key = prefs.get(PREFIX_MAJOR_KEY, "");
        String str_trial = prefs.get(PREFIX_TRIAL, "");
        long expiration = 0L;
        long quotient = 0L;
        long modulus = 0L;
        boolean trial = false;
        if ("".equals(str_expiration + str_major_key + str_trial)) {
            expiration = LicenseStoreManager.storeLicenseBits(license, prefs);
        } else {
            if (license.isTrial()) {
                try {
                    trial = Integer.parseInt(str_trial) % 2 == 1;
                }
                catch (NumberFormatException nfe) {
                    throw new CorruptLicenseException(LRES.get("T*Kac/z~JymNh1Ww2x:%x~gjmcX hwwQ@.eWR@0f.Gk*Kwh*B4wvSfhpWwia^* E_jJj 2k*{8yvzygka<2r4_wO;Xp~ItY"));
                }
                if (trial) {
                    if (!license.getMasterKey().equals(str_major_key)) {
                        throw new CorruptLicenseException(LRES.get("UmyJKX;|1{_LQc<Ih^iO^|=4:tn;/D~wMO:~`Wwiac{/d_38;JuWdkO;01P_qAy-c-qQac.I,Jj|f|1hQt8y/=4^kJj<&"));
                    }
                    try {
                        quotient = LicenseStoreManager.decode(prefs.get(PREFIX_DIV, ""));
                        modulus = LicenseStoreManager.decode(prefs.get(PREFIX_MOD, ""));
                        expiration = LicenseStoreManager.decode(str_expiration);
                    }
                    catch (NumberFormatException nfe) {
                        throw new CorruptLicenseException(LRES.get("sz,c{^4mK.;HDyhXdP0=Pm ]]:c4@ BcY=4`K,_]G,HX]kQ=Gm ]V~U,E>8/|/dRK,;-zk)z2K~uqhX8]<I(my)SL"));
                    }
                    if (quotient * CUT_POINT + modulus != expiration) {
                        throw new CorruptLicenseException(LRES.get("sz,c{^4mK.;HDyhXdP0=Pm ]]:c4@ BcY=4`K,_]G,HX]kQ=Gm ]V~U,E>8/|/dRK,;-zk)z2K~uqhX8]<I(my)SL"));
                    }
                    return license.getLicenseExpiration();
                }
                throw new UpdateTrialLicenseException(LRES.get("WX];-\\$(Xf30T.wxbaYIG5>f+:f.E4}9};]5miU}>o&^i7P|\"5^i/ZTEtHit8D.5jgVe?$5.BAY;G5H8t)`&(owo`>,)^}x.T4E48V>D$(5iUr;.7R!"));
            }
            expiration = LicenseStoreManager.storeLicenseBits(license, prefs);
        }
        return expiration;
    }

    private static long storeLicenseBits(License license, Preferences prefs) {
        long expiration = license.getLicenseExpiration();
        long quotient = expiration / CUT_POINT;
        long modulus = expiration % CUT_POINT;
        prefs.put(PREFIX_EXPIRATION, LicenseStoreManager.encode(expiration));
        prefs.put(PREFIX_DIV, LicenseStoreManager.encode(quotient));
        prefs.put(PREFIX_MOD, LicenseStoreManager.encode(modulus));
        int result = LicenseStoreManager.getModRandom(license);
        prefs.put(PREFIX_TRIAL, Integer.toString(result));
        prefs.put(PREFIX_MAJOR_KEY, license.getMasterKey());
        return expiration;
    }

    private static int getModRandom(License lic) {
        return 2 * (int)(Math.random() * 1000000.0) + (lic.isTrial() ? 1 : 0);
    }

    private static String encode(long value) {
        String temp = String.valueOf(value);
        StringBuffer buff = new StringBuffer();
        int nextNum = 0;
        int sz = temp.length();
        for (int i = 0; i < sz; ++i) {
            nextNum = temp.charAt(i) - 48;
            nextNum = (nextNum += 2 * i) % 2 == 0 ? (nextNum += 6) : (nextNum += 4);
            while (nextNum > 9) {
                nextNum -= 10;
            }
            buff.append((char)(nextNum + 48));
        }
        return buff.toString();
    }

    private static long decode(String value) {
        String temp = String.valueOf(value);
        StringBuffer buff = new StringBuffer();
        int nextNum = 0;
        int sz = temp.length();
        for (int i = 0; i < sz; ++i) {
            nextNum = temp.charAt(i) - 48;
            nextNum = nextNum % 2 == 0 ? (nextNum -= 6) : (nextNum -= 4);
            nextNum -= 2 * i;
            while (nextNum < 0) {
                nextNum += 10;
            }
            buff.append((char)(nextNum + 48));
        }
        return Long.valueOf(buff.toString());
    }
}

