/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.report;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.report.DataAccessManagerLocal;
import org.rhq.enterprise.server.report.DataAccessManagerRemote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class DataAccessManagerBean
implements DataAccessManagerLocal,
DataAccessManagerRemote {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    public List<Object[]> executeQuery(Subject subject, String query) {
        this.verifyUserIsSuperUser(subject);
        Query q = this.entityManager.createQuery(query);
        return q.getResultList();
    }

    @Override
    public List<Object[]> executeQueryWithPageControl(Subject subject, String query, PageControl pageControl) {
        this.verifyUserIsSuperUser(subject);
        Query q = this.buildQuery(query, pageControl);
        return q.getResultList();
    }

    private Query buildQuery(String queryString, PageControl pageControl) {
        boolean first = true;
        StringBuilder queryBuilder = new StringBuilder(queryString);
        for (OrderingField orderingField : pageControl.getOrderingFieldsAsArray()) {
            if (first) {
                queryBuilder.append(" ORDER BY ");
                first = false;
            } else {
                queryBuilder.append(", ");
            }
            queryBuilder.append(orderingField.getField()).append(" ").append(orderingField.getOrdering());
        }
        Query query = this.entityManager.createQuery(queryBuilder.toString());
        if (pageControl.getPageSize() > 0) {
            query.setFirstResult(pageControl.getStartRow());
            query.setMaxResults(pageControl.getPageSize());
        }
        return query;
    }

    private void verifyUserIsSuperUser(Subject subject) {
        if (!this.authorizationManager.isSystemSuperuser(subject)) {
            throw new PermissionException("Access denied. You must be logged in as the system super user.");
        }
    }
}

