/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceGroupCriteria;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.search.SearchSubsystem;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AbstractStatefulJob;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedSearchResultCountRecalculationJob
extends AbstractStatefulJob {
    private static final Log LOG = LogFactory.getLog(SavedSearchResultCountRecalculationJob.class);
    private SavedSearchManagerLocal savedSearchManager = LookupUtil.getSavedSearchManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
    private Subject overlord = LookupUtil.getSubjectManager().getOverlord();

    @Override
    public void executeJobCode(JobExecutionContext context) throws JobExecutionException {
        List<SavedSearch> staleSavedSearches = this.getSavedSearchesNeedingRecomputation();
        int errors = 0;
        int updated = 0;
        long totalMillis = 0L;
        for (SavedSearch next : staleSavedSearches) {
            if (next.isGlobal()) continue;
            try {
                PageList<Resource> results;
                ResourceCriteria criteria;
                if (next.getSearchSubsystem() == SearchSubsystem.RESOURCE) {
                    criteria = new ResourceCriteria();
                    criteria.setSearchExpression(next.getPattern());
                    totalMillis -= System.currentTimeMillis();
                    results = this.resourceManager.findResourcesByCriteria(this.overlord, criteria);
                    totalMillis += System.currentTimeMillis();
                    if (!this.processResults(next, results)) continue;
                    ++updated;
                    continue;
                }
                if (next.getSearchSubsystem() != SearchSubsystem.GROUP) continue;
                criteria = new ResourceGroupCriteria();
                criteria.setSearchExpression(next.getPattern());
                totalMillis -= System.currentTimeMillis();
                results = this.resourceGroupManager.findResourceGroupsByCriteria(this.overlord, (ResourceGroupCriteria)criteria);
                totalMillis += System.currentTimeMillis();
                if (!this.processResults(next, results)) continue;
                ++updated;
            }
            catch (Throwable t) {
                ++errors;
                LOG.error((Object)("Could not calculate result count for SavedSearch[name=" + next.getName() + ", pattern='" + next.getPattern() + "']: " + t.getMessage()));
                LOG.debug((Object)t);
            }
        }
        if (updated > 0) {
            LOG.info((Object)("Statistics: updated " + updated + " in " + totalMillis + " ms (" + errors + " errors)"));
        }
    }

    private boolean processResults(SavedSearch next, PageList<?> results) {
        if (next.getResultCount() == null || (long)results.getTotalSize() != next.getResultCount()) {
            next.setResultCount(Long.valueOf(results.getTotalSize()));
            this.savedSearchManager.updateSavedSearch(this.overlord, next);
            return true;
        }
        return false;
    }

    private List<SavedSearch> getSavedSearchesNeedingRecomputation() {
        long fiveMinutesAgo = System.currentTimeMillis() - 300000L;
        SavedSearchCriteria criteria = new SavedSearchCriteria();
        criteria.addFilterLastComputeTimeMax(Long.valueOf(fiveMinutesAgo));
        PageList<SavedSearch> results = this.savedSearchManager.findSavedSearchesByCriteria(this.overlord, criteria);
        return results;
    }
}

