/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.content.ContentAgentService;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.ContentServiceResponse;
import org.rhq.core.clientapi.server.content.DeletePackagesRequest;
import org.rhq.core.clientapi.server.content.DeployPackagesRequest;
import org.rhq.core.clientapi.server.content.RetrievePackageBitsRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.ContentRequestStatus;
import org.rhq.core.domain.content.ContentRequestType;
import org.rhq.core.domain.content.ContentServiceRequest;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.InstalledPackageHistory;
import org.rhq.core.domain.content.InstalledPackageHistoryStatus;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageInstallationStep;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemoveIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.InstalledPackageCriteria;
import org.rhq.core.domain.criteria.PackageVersionCriteria;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerRemote;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ContentManagerBean
implements ContentManagerLocal,
ContentManagerRemote {
    private static final int REQUEST_TIMEOUT = 3600000;
    public static final String UPLOAD_FILE_SIZE = "fileSize";
    public static final String UPLOAD_FILE_INSTALL_DATE = "fileInstallDate";
    public static final String UPLOAD_OWNER = "owner";
    public static final String UPLOAD_FILE_NAME = "fileName";
    public static final String UPLOAD_MD5 = "md5";
    public static final String UPLOAD_SHA256 = "sha256";
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:/RHQDS")
    private DataSource dataSource;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;

    @Override
    public void mergeDiscoveredPackages(ContentDiscoveryReport report) {
        int resourceId = report.getResourceId();
        long start = System.currentTimeMillis();
        this.log.debug((Object)("Merging [" + report.getDeployedPackages().size() + "] packages for Resource with id [" + resourceId + "]..."));
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        if (resource == null) {
            this.log.error((Object)("Invalid resource ID specified for merge. Resource ID: " + resourceId));
            return;
        }
        long timestamp = System.currentTimeMillis();
        Query currentInstalledPackageQuery = this.entityManager.createNamedQuery("InstalledPackage.findByResourceId");
        currentInstalledPackageQuery.setParameter("resourceId", (Object)resource.getId());
        HashSet doomedPackages = new HashSet(currentInstalledPackageQuery.getResultList());
        for (ResourcePackageDetails discoveredPackage : report.getDeployedPackages()) {
            Package generalPackage = null;
            PackageVersion packageVersion = null;
            Query packageQuery = this.entityManager.createNamedQuery("Package.findByNamePkgTypeResourceType");
            packageQuery.setFlushMode(FlushModeType.COMMIT);
            packageQuery.setParameter("name", (Object)discoveredPackage.getName());
            packageQuery.setParameter("packageTypeName", (Object)discoveredPackage.getPackageTypeName());
            packageQuery.setParameter("resourceTypeId", (Object)resource.getResourceType().getId());
            List resultPackages = packageQuery.getResultList();
            if (resultPackages.size() > 0) {
                generalPackage = (Package)resultPackages.get(0);
            }
            if (null != generalPackage) {
                Query packageVersionQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetails");
                packageVersionQuery.setFlushMode(FlushModeType.COMMIT);
                packageVersionQuery.setParameter("packageName", (Object)discoveredPackage.getName());
                packageVersionQuery.setParameter("packageTypeName", (Object)discoveredPackage.getPackageTypeName());
                packageVersionQuery.setParameter("resourceTypeId", (Object)resource.getResourceType().getId());
                packageVersionQuery.setParameter("architectureName", (Object)discoveredPackage.getArchitectureName());
                packageVersionQuery.setParameter("version", (Object)discoveredPackage.getVersion());
                packageVersionQuery.setParameter("sha", (Object)discoveredPackage.getSHA256());
                List resultPackageVersions = packageVersionQuery.getResultList();
                if (resultPackageVersions.size() > 0) {
                    packageVersion = (PackageVersion)resultPackageVersions.get(0);
                }
            }
            if (null == packageVersion) {
                Architecture packageArchitecture;
                if (null == generalPackage) {
                    Query packageTypeQuery = this.entityManager.createNamedQuery("PackageType.findByResourceTypeIdAndName");
                    packageTypeQuery.setFlushMode(FlushModeType.COMMIT);
                    packageTypeQuery.setParameter("typeId", (Object)resource.getResourceType().getId());
                    packageTypeQuery.setParameter("name", (Object)discoveredPackage.getPackageTypeName());
                    PackageType packageType = (PackageType)packageTypeQuery.getSingleResult();
                    generalPackage = new Package(discoveredPackage.getName(), packageType);
                    generalPackage = this.persistOrMergePackageSafely(generalPackage);
                }
                Query architectureQuery = this.entityManager.createNamedQuery("Architecture.findByName");
                architectureQuery.setFlushMode(FlushModeType.COMMIT);
                architectureQuery.setParameter("name", (Object)discoveredPackage.getArchitectureName());
                try {
                    packageArchitecture = (Architecture)architectureQuery.getSingleResult();
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not load architecture for architecture name [" + discoveredPackage.getArchitectureName() + "] for package [" + discoveredPackage.getName() + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)e)));
                    continue;
                }
                packageVersion = new PackageVersion(generalPackage, discoveredPackage.getVersion(), packageArchitecture);
                packageVersion.setDisplayName(discoveredPackage.getDisplayName());
                packageVersion.setDisplayVersion(discoveredPackage.getDisplayVersion());
                packageVersion.setFileCreatedDate(discoveredPackage.getFileCreatedDate());
                packageVersion.setFileName(discoveredPackage.getFileName());
                packageVersion.setFileSize(discoveredPackage.getFileSize());
                packageVersion.setLicenseName(discoveredPackage.getLicenseName());
                packageVersion.setLicenseVersion(discoveredPackage.getLicenseVersion());
                packageVersion.setLongDescription(discoveredPackage.getLongDescription());
                packageVersion.setMD5(discoveredPackage.getMD5());
                packageVersion.setMetadata(discoveredPackage.getMetadata());
                packageVersion.setSHA256(discoveredPackage.getSHA256());
                packageVersion.setShortDescription(discoveredPackage.getShortDescription());
                packageVersion.setExtraProperties(discoveredPackage.getExtraProperties());
                packageVersion = this.persistOrMergePackageVersionSafely(packageVersion);
            } else {
                Query installedPackageQuery = this.entityManager.createNamedQuery("InstalledPackage.findByResourceAndPackageVer");
                installedPackageQuery.setFlushMode(FlushModeType.COMMIT);
                installedPackageQuery.setParameter("resourceId", (Object)resource.getId());
                installedPackageQuery.setParameter("packageVersionId", (Object)packageVersion.getId());
                List installedPackageList = installedPackageQuery.getResultList();
                if (installedPackageList.size() > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Discovered package is already known to the inventory " + installedPackageList.iterator().next()));
                    }
                    for (InstalledPackage ip : installedPackageList) {
                        doomedPackages.remove(ip);
                    }
                    continue;
                }
            }
            InstalledPackage newlyInstalledPackage = new InstalledPackage();
            newlyInstalledPackage.setPackageVersion(packageVersion);
            newlyInstalledPackage.setResource(resource);
            newlyInstalledPackage.setInstallationDate(Long.valueOf(discoveredPackage.getInstallationTimestamp()));
            this.entityManager.persist((Object)newlyInstalledPackage);
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setDeploymentConfigurationValues(discoveredPackage.getDeploymentTimeConfiguration());
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setStatus(InstalledPackageHistoryStatus.DISCOVERED);
            history.setTimestamp(Long.valueOf(timestamp));
            this.entityManager.persist((Object)history);
            this.entityManager.flush();
        }
        int deletedPackages = 0;
        for (InstalledPackage doomedPackage : doomedPackages) {
            doomedPackage = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)doomedPackage.getId());
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setPackageVersion(doomedPackage.getPackageVersion());
            history.setResource(resource);
            history.setStatus(InstalledPackageHistoryStatus.MISSING);
            history.setTimestamp(Long.valueOf(timestamp));
            this.entityManager.persist((Object)history);
            this.entityManager.remove((Object)doomedPackage);
            if (++deletedPackages % 100 != 0) continue;
            this.entityManager.flush();
        }
        this.log.debug((Object)("Finished merging [" + report.getDeployedPackages().size() + "] packages in " + (System.currentTimeMillis() - start) + "ms"));
    }

    @Override
    public void deployPackages(Subject user, int[] resourceIds, int[] packageVersionIds) {
        for (int resourceId : resourceIds) {
            HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
            for (int packageVersionId : packageVersionIds) {
                PackageVersion packageVersion = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
                if (packageVersion == null) {
                    throw new IllegalArgumentException("PackageVersion: [" + packageVersionId + "] not found!");
                }
                ResourcePackageDetails details = ContentManagerHelper.packageVersionToDetails(packageVersion);
                details.setInstallationTimestamp(System.currentTimeMillis());
                packages.add(details);
            }
            this.deployPackages(user, resourceId, packages, null);
        }
    }

    @Override
    public void deployPackages(Subject user, int resourceId, Set<ResourcePackageDetails> packages, String requestNotes) {
        if (packages == null) {
            throw new IllegalArgumentException("packages cannot be null");
        }
        this.log.info((Object)("Deploying " + packages.size() + " packages on resource ID [" + resourceId + "]"));
        if (packages.size() == 0) {
            return;
        }
        if (!this.authorizationManager.hasResourcePermission(user, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to deploy packages for resource ID [" + resourceId + "]");
        }
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        Agent agent = resource.getAgent();
        ContentServiceRequest persistedRequest = this.contentManager.createDeployRequest(resourceId, user.getName(), packages, requestNotes);
        DeployPackagesRequest transferRequest = new DeployPackagesRequest(persistedRequest.getId(), resourceId, packages);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ContentAgentService agentService = agentClient.getContentAgentService();
            agentService.deployPackages(transferRequest);
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error while sending deploy request to agent", (Throwable)e);
            this.contentManager.failRequest(persistedRequest.getId(), e);
            throw e;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentServiceRequest createDeployRequest(int resourceId, String username, Set<ResourcePackageDetails> packages, String notes) {
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        ContentServiceRequest persistedRequest = new ContentServiceRequest(resource, username, ContentRequestType.DEPLOY);
        persistedRequest.setStatus(ContentRequestStatus.IN_PROGRESS);
        persistedRequest.setNotes(notes);
        long timestamp = System.currentTimeMillis();
        for (ResourcePackageDetails packageDetails : packages) {
            PackageDetailsKey key = packageDetails.getKey();
            Query packageVersionQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            packageVersionQuery.setParameter("packageName", (Object)key.getName());
            packageVersionQuery.setParameter("packageTypeName", (Object)key.getPackageTypeName());
            packageVersionQuery.setParameter("architectureName", (Object)key.getArchitectureName());
            packageVersionQuery.setParameter("version", (Object)key.getVersion());
            packageVersionQuery.setParameter("resourceTypeId", (Object)resource.getResourceType().getId());
            PackageVersion packageVersion = (PackageVersion)packageVersionQuery.getSingleResult();
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setContentServiceRequest(persistedRequest);
            history.setDeploymentConfigurationValues(packageDetails.getDeploymentTimeConfiguration());
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setStatus(InstalledPackageHistoryStatus.BEING_INSTALLED);
            history.setTimestamp(Long.valueOf(timestamp));
            persistedRequest.addInstalledPackageHistory(history);
        }
        this.entityManager.persist((Object)persistedRequest);
        return persistedRequest;
    }

    @Override
    public void completeDeployPackageRequest(DeployPackagesResponse response) {
        this.log.info((Object)("Completing deploy package response: " + response));
        Query query = this.entityManager.createNamedQuery("ContentServiceRequest.findById");
        query.setParameter("id", (Object)response.getRequestId());
        ContentServiceRequest persistedRequest = (ContentServiceRequest)query.getSingleResult();
        org.rhq.core.domain.resource.Resource resource = persistedRequest.getResource();
        int resourceTypeId = persistedRequest.getResource().getResourceType().getId();
        persistedRequest.setErrorMessage(response.getOverallRequestErrorMessage());
        persistedRequest.setStatus(this.translateRequestResultStatus(response.getOverallRequestResult()));
        Set requestInProgressEntries = persistedRequest.getInstalledPackageHistory();
        HashMap<PackageVersion, InstalledPackageHistory> inProgressEntries = new HashMap<PackageVersion, InstalledPackageHistory>(requestInProgressEntries.size());
        for (InstalledPackageHistory history : requestInProgressEntries) {
            inProgressEntries.put(history.getPackageVersion(), history);
        }
        long timestamp = System.currentTimeMillis();
        for (DeployIndividualPackageResponse singleResponse : response.getPackageResponses()) {
            PackageDetailsKey key = singleResponse.getKey();
            Query packageVersionQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            packageVersionQuery.setParameter("packageName", (Object)key.getName());
            packageVersionQuery.setParameter("packageTypeName", (Object)key.getPackageTypeName());
            packageVersionQuery.setParameter("architectureName", (Object)key.getArchitectureName());
            packageVersionQuery.setParameter("version", (Object)key.getVersion());
            packageVersionQuery.setParameter("resourceTypeId", (Object)resourceTypeId);
            PackageVersion packageVersion = (PackageVersion)packageVersionQuery.getSingleResult();
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setContentServiceRequest(persistedRequest);
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setTimestamp(Long.valueOf(timestamp));
            Query deploymentConfigurationQuery = this.entityManager.createNamedQuery("InstalledPackageHistory.findConfigByPackageVersionAndReq");
            deploymentConfigurationQuery.setParameter("packageVersion", (Object)packageVersion);
            deploymentConfigurationQuery.setParameter("contentServiceRequest", (Object)persistedRequest);
            deploymentConfigurationQuery.setMaxResults(1);
            Configuration deploymentConfiguration = null;
            List deploymentConfigurationResults = deploymentConfigurationQuery.getResultList();
            if (deploymentConfigurationResults.size() > 0) {
                deploymentConfiguration = (Configuration)deploymentConfigurationResults.get(0);
                deploymentConfiguration = deploymentConfiguration.deepCopy(false);
            }
            history.setDeploymentConfigurationValues(deploymentConfiguration);
            List transferObjectSteps = singleResponse.getDeploymentSteps();
            if (transferObjectSteps != null) {
                List<PackageInstallationStep> installationSteps = this.translateInstallationSteps(transferObjectSteps, history);
                history.setInstallationSteps(installationSteps);
            }
            if (singleResponse.getResult() == ContentResponseResult.SUCCESS) {
                history.setStatus(InstalledPackageHistoryStatus.INSTALLED);
            } else {
                history.setStatus(InstalledPackageHistoryStatus.FAILED);
                history.setErrorMessage(singleResponse.getErrorMessage());
            }
            this.entityManager.persist((Object)history);
            persistedRequest.addInstalledPackageHistory(history);
            inProgressEntries.remove(packageVersion);
        }
        for (InstalledPackageHistory unclosed : inProgressEntries.values()) {
            PackageVersion packageVersion = unclosed.getPackageVersion();
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setContentServiceRequest(persistedRequest);
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setTimestamp(Long.valueOf(timestamp));
            if (response.getOverallRequestResult() == ContentResponseResult.SUCCESS) {
                history.setStatus(InstalledPackageHistoryStatus.INSTALLED);
            } else {
                history.setStatus(InstalledPackageHistoryStatus.FAILED);
            }
            this.entityManager.persist((Object)history);
            persistedRequest.addInstalledPackageHistory(history);
        }
    }

    @Override
    public void deletePackages(Subject user, int[] resourceIds, int[] installedPackageIds) {
        for (int resourceId : resourceIds) {
            this.deletePackages(user, resourceId, installedPackageIds, null);
        }
    }

    @Override
    public void deletePackages(Subject user, int resourceId, int[] installedPackageIds, String requestNotes) {
        if (installedPackageIds == null) {
            throw new IllegalArgumentException("installedPackages cannot be null");
        }
        this.log.info((Object)("Deleting " + installedPackageIds.length + " from resource ID [" + resourceId + "]"));
        if (installedPackageIds.length == 0) {
            return;
        }
        if (!this.authorizationManager.hasResourcePermission(user, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to delete installedPackageIds from resource ID [" + resourceId + "]");
        }
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        Agent agent = resource.getAgent();
        ContentServiceRequest persistedRequest = this.contentManager.createRemoveRequest(resourceId, user.getName(), installedPackageIds, requestNotes);
        Query query = this.entityManager.createNamedQuery("InstalledPackage.findBySetOfIds");
        query.setParameter("packageIds", (Object)ArrayUtils.wrapInList((int[])installedPackageIds));
        List installedPackageList = query.getResultList();
        HashSet<ResourcePackageDetails> transferPackages = new HashSet<ResourcePackageDetails>(installedPackageList.size());
        for (InstalledPackage installedPackage : installedPackageList) {
            ResourcePackageDetails transferPackage = ContentManagerHelper.installedPackageToDetails(installedPackage);
            transferPackages.add(transferPackage);
        }
        DeletePackagesRequest transferRequest = new DeletePackagesRequest(persistedRequest.getId(), resourceId, transferPackages);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ContentAgentService agentService = agentClient.getContentAgentService();
            agentService.deletePackages(transferRequest);
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error while sending deploy request to agent", (Throwable)e);
            this.contentManager.failRequest(persistedRequest.getId(), e);
            throw e;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentServiceRequest createRemoveRequest(int resourceId, String username, int[] installedPackageIds, String requestNotes) {
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        ContentServiceRequest persistedRequest = new ContentServiceRequest(resource, username, ContentRequestType.DELETE);
        persistedRequest.setStatus(ContentRequestStatus.IN_PROGRESS);
        persistedRequest.setNotes(requestNotes);
        long timestamp = System.currentTimeMillis();
        for (int installedPackageId : installedPackageIds) {
            InstalledPackage ip = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)installedPackageId);
            PackageVersion packageVersion = ip.getPackageVersion();
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setContentServiceRequest(persistedRequest);
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setStatus(InstalledPackageHistoryStatus.BEING_DELETED);
            history.setTimestamp(Long.valueOf(timestamp));
            persistedRequest.addInstalledPackageHistory(history);
        }
        this.entityManager.persist((Object)persistedRequest);
        return persistedRequest;
    }

    @Override
    public void completeDeletePackageRequest(RemovePackagesResponse response) {
        this.log.info((Object)("Completing delete package response: " + response));
        Query query = this.entityManager.createNamedQuery("ContentServiceRequest.findById");
        query.setParameter("id", (Object)response.getRequestId());
        ContentServiceRequest persistedRequest = (ContentServiceRequest)query.getSingleResult();
        org.rhq.core.domain.resource.Resource resource = persistedRequest.getResource();
        int resourceTypeId = resource.getResourceType().getId();
        persistedRequest.setErrorMessage(response.getOverallRequestErrorMessage());
        persistedRequest.setStatus(this.translateRequestResultStatus(response.getOverallRequestResult()));
        Set requestInProgressEntries = persistedRequest.getInstalledPackageHistory();
        HashMap<PackageVersion, InstalledPackageHistory> inProgressEntries = new HashMap<PackageVersion, InstalledPackageHistory>(requestInProgressEntries.size());
        for (InstalledPackageHistory history : requestInProgressEntries) {
            inProgressEntries.put(history.getPackageVersion(), history);
        }
        long timestamp = System.currentTimeMillis();
        for (RemoveIndividualPackageResponse singleResponse : response.getPackageResponses()) {
            PackageDetailsKey key = singleResponse.getKey();
            Query packageVersionQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            packageVersionQuery.setParameter("packageName", (Object)key.getName());
            packageVersionQuery.setParameter("packageTypeName", (Object)key.getPackageTypeName());
            packageVersionQuery.setParameter("architectureName", (Object)key.getArchitectureName());
            packageVersionQuery.setParameter("version", (Object)key.getVersion());
            packageVersionQuery.setParameter("resourceTypeId", (Object)resourceTypeId);
            PackageVersion packageVersion = (PackageVersion)packageVersionQuery.getSingleResult();
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setContentServiceRequest(persistedRequest);
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setTimestamp(Long.valueOf(timestamp));
            if (singleResponse.getResult() == ContentResponseResult.SUCCESS) {
                history.setStatus(InstalledPackageHistoryStatus.DELETED);
            } else {
                history.setStatus(InstalledPackageHistoryStatus.FAILED);
                history.setErrorMessage(singleResponse.getErrorMessage());
            }
            this.entityManager.persist((Object)history);
            persistedRequest.addInstalledPackageHistory(history);
            inProgressEntries.remove(packageVersion);
        }
        for (InstalledPackageHistory unclosed : inProgressEntries.values()) {
            PackageVersion packageVersion = unclosed.getPackageVersion();
            InstalledPackageHistory history = new InstalledPackageHistory();
            history.setContentServiceRequest(persistedRequest);
            history.setPackageVersion(packageVersion);
            history.setResource(resource);
            history.setTimestamp(Long.valueOf(timestamp));
            if (response.getOverallRequestResult() == ContentResponseResult.SUCCESS) {
                history.setStatus(InstalledPackageHistoryStatus.DELETED);
            } else {
                history.setStatus(InstalledPackageHistoryStatus.FAILED);
            }
            this.entityManager.persist((Object)history);
            persistedRequest.addInstalledPackageHistory(history);
        }
    }

    @Override
    public void retrieveBitsFromResource(Subject user, int resourceId, int installedPackageId) {
        this.log.info((Object)("Retrieving bits for package [" + installedPackageId + "] on resource ID [" + resourceId + "]"));
        if (!this.authorizationManager.hasResourcePermission(user, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to delete package " + installedPackageId + " for resource ID [" + resourceId + "]");
        }
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        Agent agent = resource.getAgent();
        InstalledPackage installedPackage = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)installedPackageId);
        ContentServiceRequest persistedRequest = this.contentManager.createRetrieveBitsRequest(resourceId, user.getName(), installedPackageId);
        ResourcePackageDetails transferPackage = ContentManagerHelper.installedPackageToDetails(installedPackage);
        RetrievePackageBitsRequest transferRequest = new RetrievePackageBitsRequest(persistedRequest.getId(), resourceId, transferPackage);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ContentAgentService agentService = agentClient.getContentAgentService();
            agentService.retrievePackageBits(transferRequest);
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error while sending deploy request to agent", (Throwable)e);
            this.contentManager.failRequest(persistedRequest.getId(), e);
            throw e;
        }
    }

    @Override
    public byte[] getPackageBytes(Subject user, int resourceId, int installedPackageId) {
        if (!this.authorizationManager.hasResourcePermission(user, Permission.MANAGE_CONTENT, resourceId)) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to obtain package content for installed package id [" + installedPackageId + "] for resource ID [" + resourceId + "]");
        }
        try {
            InstalledPackage installedPackage = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)installedPackageId);
            PackageBits bits = installedPackage.getPackageVersion().getPackageBits();
            if (bits == null || bits.getBits().length == 0) {
                long start = System.currentTimeMillis();
                this.retrieveBitsFromResource(user, resourceId, installedPackageId);
                bits = installedPackage.getPackageVersion().getPackageBits();
                while ((bits == null || bits.getBits() == null) && System.currentTimeMillis() - start < 30000L) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.entityManager.clear();
                    installedPackage = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)installedPackageId);
                    bits = installedPackage.getPackageVersion().getPackageBits();
                }
                if (bits == null) {
                    throw new RuntimeException("Unable to retrieve package bits for resource: " + resourceId + " and package: " + installedPackageId + " before timeout.");
                }
            }
            return bits.getBits();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve package bits for resource: " + resourceId + " and package: " + installedPackageId + " before timeout.");
        }
    }

    @Override
    public List<DeployPackageStep> translateInstallationSteps(int resourceId, ResourcePackageDetails packageDetails) throws Exception {
        List packageStepList;
        this.log.info((Object)("Retrieving installation steps for package [" + packageDetails + "]"));
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        Agent agent = resource.getAgent();
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ContentAgentService agentService = agentClient.getContentAgentService();
            packageStepList = agentService.translateInstallationSteps(resourceId, packageDetails);
        }
        catch (PluginContainerException e) {
            this.log.error((Object)"Error while sending deploy request to agent", (Throwable)e);
            throw e;
        }
        return packageStepList;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ContentServiceRequest createRetrieveBitsRequest(int resourceId, String username, int installedPackageId) {
        org.rhq.core.domain.resource.Resource resource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
        ContentServiceRequest persistedRequest = new ContentServiceRequest(resource, username, ContentRequestType.GET_BITS);
        persistedRequest.setStatus(ContentRequestStatus.IN_PROGRESS);
        long timestamp = System.currentTimeMillis();
        InstalledPackage ip = (InstalledPackage)this.entityManager.find(InstalledPackage.class, (Object)installedPackageId);
        PackageVersion packageVersion = ip.getPackageVersion();
        InstalledPackageHistory history = new InstalledPackageHistory();
        history.setContentServiceRequest(persistedRequest);
        history.setPackageVersion(packageVersion);
        history.setResource(resource);
        history.setStatus(InstalledPackageHistoryStatus.BEING_RETRIEVED);
        history.setTimestamp(Long.valueOf(timestamp));
        persistedRequest.addInstalledPackageHistory(history);
        this.entityManager.persist((Object)persistedRequest);
        return persistedRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionTimeout(value=2700)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void completeRetrievePackageBitsRequest(ContentServiceResponse response, InputStream bitStream) {
        this.log.info((Object)("Completing retrieve package bits response: " + response));
        ContentServiceRequest persistedRequest = (ContentServiceRequest)this.entityManager.find(ContentServiceRequest.class, (Object)response.getRequestId());
        if (persistedRequest == null) {
            this.log.error((Object)("Attempting to complete a request that was not found in the database: " + response.getRequestId()));
            return;
        }
        org.rhq.core.domain.resource.Resource resource = persistedRequest.getResource();
        InstalledPackageHistory initialRequestHistory = (InstalledPackageHistory)persistedRequest.getInstalledPackageHistory().iterator().next();
        PackageVersion packageVersion = initialRequestHistory.getPackageVersion();
        if (response.getStatus() == ContentRequestStatus.SUCCESS) {
            try {
                Exception e22;
                Connection conn;
                block19: {
                    this.log.debug((Object)("Saving content for response: " + response));
                    PackageBits packageBits = new PackageBits();
                    this.entityManager.persist((Object)packageBits);
                    packageVersion.setPackageBits(packageBits);
                    this.entityManager.flush();
                    Long length = packageVersion.getFileSize();
                    if (length == null) {
                        File tmpFile = File.createTempFile("rhq", ".stream");
                        FileOutputStream fos = new FileOutputStream(tmpFile);
                        length = StreamUtil.copy((InputStream)bitStream, (OutputStream)fos, (boolean)true);
                        bitStream = new FileInputStream(tmpFile);
                    }
                    conn = null;
                    Statement ps = null;
                    try {
                        PackageBits bits = (PackageBits)this.entityManager.find(PackageBits.class, (Object)packageBits.getId());
                        String pkgName = "(set packageName)";
                        if (packageVersion != null && packageVersion.getGeneralPackage() != null) {
                            pkgName = packageVersion.getGeneralPackage().getName();
                        }
                        bits = this.loadPackageBits(bitStream, packageVersion.getId(), pkgName, packageVersion.getVersion(), bits, null);
                        this.entityManager.merge((Object)bits);
                        Object var14_14 = null;
                        if (ps == null) break block19;
                    }
                    catch (Throwable throwable) {
                        Exception e22;
                        Object var14_15 = null;
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Exception e22) {
                                this.log.warn((Object)("Failed to close prepared statement for package version [" + packageVersion + "]"));
                            }
                        }
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Exception e22) {
                                this.log.warn((Object)("Failed to close connection for package version [" + packageVersion + "]"));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        ps.close();
                    }
                    catch (Exception e22) {
                        this.log.warn((Object)("Failed to close prepared statement for package version [" + packageVersion + "]"));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e22) {
                        this.log.warn((Object)("Failed to close connection for package version [" + packageVersion + "]"));
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error while reading content from agent stream", (Throwable)e);
            }
        }
        persistedRequest.setErrorMessage(response.getErrorMessage());
        persistedRequest.setStatus(response.getStatus());
        InstalledPackageHistory completedHistory = new InstalledPackageHistory();
        completedHistory.setContentServiceRequest(persistedRequest);
        completedHistory.setResource(resource);
        completedHistory.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        completedHistory.setPackageVersion(packageVersion);
        if (response.getStatus() == ContentRequestStatus.SUCCESS) {
            completedHistory.setStatus(InstalledPackageHistoryStatus.RETRIEVED);
        } else {
            completedHistory.setStatus(InstalledPackageHistoryStatus.FAILED);
            completedHistory.setErrorMessage(response.getErrorMessage());
        }
    }

    @Override
    public Set<ResourcePackageDetails> loadDependencies(int requestId, Set<PackageDetailsKey> keys) {
        HashSet<ResourcePackageDetails> dependencies = new HashSet<ResourcePackageDetails>();
        ContentServiceRequest persistedRequest = (ContentServiceRequest)this.entityManager.find(ContentServiceRequest.class, (Object)requestId);
        if (persistedRequest == null) {
            this.log.error((Object)("Could not find request with ID: " + requestId));
            return dependencies;
        }
        org.rhq.core.domain.resource.Resource resource = persistedRequest.getResource();
        ResourceType resourceType = resource.getResourceType();
        long installationDate = System.currentTimeMillis();
        for (PackageDetailsKey key : keys) {
            Query packageQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            packageQuery.setParameter("packageName", (Object)key.getName());
            packageQuery.setParameter("packageTypeName", (Object)key.getPackageTypeName());
            packageQuery.setParameter("architectureName", (Object)key.getArchitectureName());
            packageQuery.setParameter("version", (Object)key.getVersion());
            packageQuery.setParameter("resourceTypeId", (Object)resourceType.getId());
            List persistedPackageList = packageQuery.getResultList();
            if (persistedPackageList.size() == 0) continue;
            if (persistedPackageList.size() != 1) {
                this.log.error((Object)("Multiple packages found. Found: " + persistedPackageList.size() + " for key: " + key));
            }
            PackageVersion packageVersion = (PackageVersion)persistedPackageList.get(0);
            ResourcePackageDetails details = ContentManagerHelper.packageVersionToDetails(packageVersion);
            dependencies.add(details);
            InstalledPackageHistory dependencyPackage = new InstalledPackageHistory();
            dependencyPackage.setContentServiceRequest(persistedRequest);
            dependencyPackage.setPackageVersion(packageVersion);
            dependencyPackage.setResource(resource);
            dependencyPackage.setStatus(InstalledPackageHistoryStatus.BEING_INSTALLED);
            dependencyPackage.setTimestamp(Long.valueOf(installationDate));
            persistedRequest.addInstalledPackageHistory(dependencyPackage);
            this.entityManager.persist((Object)dependencyPackage);
        }
        return dependencies;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void failRequest(int requestId, Throwable error) {
        Query query = this.entityManager.createNamedQuery("ContentServiceRequest.findById");
        query.setParameter("id", (Object)requestId);
        ContentServiceRequest persistedRequest = (ContentServiceRequest)query.getSingleResult();
        org.rhq.core.domain.resource.Resource resource = persistedRequest.getResource();
        persistedRequest.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)error));
        persistedRequest.setStatus(ContentRequestStatus.FAILURE);
        long timestamp = System.currentTimeMillis();
        for (InstalledPackageHistory history : persistedRequest.getInstalledPackageHistory()) {
            InstalledPackageHistory failedEntry = new InstalledPackageHistory();
            failedEntry.setContentServiceRequest(persistedRequest);
            failedEntry.setDeploymentConfigurationValues(history.getDeploymentConfigurationValues());
            failedEntry.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)error));
            failedEntry.setPackageVersion(history.getPackageVersion());
            failedEntry.setResource(resource);
            failedEntry.setStatus(InstalledPackageHistoryStatus.FAILED);
            failedEntry.setTimestamp(Long.valueOf(timestamp));
            persistedRequest.addInstalledPackageHistory(failedEntry);
        }
    }

    @Override
    public List<Architecture> findArchitectures(Subject subject) {
        Query q = this.entityManager.createNamedQuery("Architecture.findAll");
        List architectures = q.getResultList();
        return architectures;
    }

    @Override
    public Architecture getNoArchitecture() {
        Query q = this.entityManager.createNamedQuery("Architecture.findByName");
        q.setParameter("name", (Object)"noarch");
        Architecture architecture = (Architecture)q.getSingleResult();
        return architecture;
    }

    @Override
    public List<PackageType> findPackageTypes(Subject subject, String resourceTypeName, String pluginName) throws ResourceTypeNotFoundException {
        ResourceType rt = this.resourceTypeManager.getResourceTypeByNameAndPlugin(subject, resourceTypeName, pluginName);
        if (null == rt) {
            throw new ResourceTypeNotFoundException(resourceTypeName);
        }
        Query query = this.entityManager.createNamedQuery("PackageType.findByResourceTypeId");
        query.setParameter("typeId", (Object)rt.getId());
        List result = query.getResultList();
        return result;
    }

    @Override
    public void checkForTimedOutRequests(Subject subject) {
        if (!this.authorizationManager.isOverlord(subject)) {
            this.log.debug((Object)("Unauthorized user " + subject + " tried to execute checkForTimedOutRequests; " + "only the overlord may execute this system operation"));
            return;
        }
        try {
            Query query = this.entityManager.createNamedQuery("ContentServiceRequest.findWithStatus");
            query.setParameter("status", (Object)ContentRequestStatus.IN_PROGRESS);
            List inProgressRequests = query.getResultList();
            if (inProgressRequests == null) {
                return;
            }
            long timestamp = System.currentTimeMillis();
            for (ContentServiceRequest request : inProgressRequests) {
                long duration = request.getDuration();
                if (duration <= 3600000L) continue;
                this.log.debug((Object)("Timing out request after duration: " + duration + " Request: " + request));
                request.setErrorMessage("Request with duration " + duration + " exceeded the timeout threshold of " + 3600000);
                request.setStatus(ContentRequestStatus.TIMED_OUT);
                org.rhq.core.domain.resource.Resource resource = request.getResource();
                Set requestPackages = request.getInstalledPackageHistory();
                block6: for (InstalledPackageHistory history : requestPackages) {
                    InstalledPackageHistoryStatus packageStatus = history.getStatus();
                    switch (packageStatus) {
                        case BEING_DELETED: 
                        case BEING_INSTALLED: 
                        case BEING_RETRIEVED: {
                            InstalledPackageHistory closedHistory = new InstalledPackageHistory();
                            closedHistory.setContentServiceRequest(request);
                            closedHistory.setPackageVersion(history.getPackageVersion());
                            closedHistory.setResource(resource);
                            closedHistory.setStatus(InstalledPackageHistoryStatus.TIMED_OUT);
                            closedHistory.setTimestamp(Long.valueOf(timestamp));
                            this.entityManager.persist((Object)closedHistory);
                            continue block6;
                        }
                    }
                    this.log.warn((Object)("Found a history entry on the request with an unexpected status. Id: " + history.getId() + ", Status: " + packageStatus));
                }
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Error while processing timed out requests", e);
        }
    }

    @Override
    public PackageVersion createPackageVersion(Subject subject, String packageName, int packageTypeId, String version, Integer architectureId, byte[] packageBytes) {
        if (!this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_CONTENT)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to create package versions");
        }
        return this.createPackageVersion(packageName, packageTypeId, version, null == architectureId ? this.getNoArchitecture().getId() : architectureId.intValue(), new ByteArrayInputStream(packageBytes));
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public PackageVersion createPackageVersion(String packageName, int packageTypeId, String version, int architectureId, InputStream packageBitStream) {
        Package existingPackage;
        Query packageVersionQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageVerArch");
        packageVersionQuery.setParameter("name", (Object)packageName);
        packageVersionQuery.setParameter("packageTypeId", (Object)packageTypeId);
        packageVersionQuery.setParameter("architectureId", (Object)architectureId);
        packageVersionQuery.setParameter("version", (Object)version);
        List existingVersionList = packageVersionQuery.getResultList();
        if (existingVersionList.size() > 0) {
            return (PackageVersion)existingVersionList.get(0);
        }
        Query packageQuery = this.entityManager.createNamedQuery("Package.findByNameAndPkgTypeId");
        packageQuery.setParameter("name", (Object)packageName);
        packageQuery.setParameter("packageTypeId", (Object)packageTypeId);
        List existingPackageList = packageQuery.getResultList();
        if (existingPackageList.size() == 0) {
            PackageType packageType = (PackageType)this.entityManager.find(PackageType.class, (Object)packageTypeId);
            existingPackage = new Package(packageName, packageType);
            existingPackage = this.persistOrMergePackageSafely(existingPackage);
        } else {
            existingPackage = (Package)existingPackageList.get(0);
        }
        Architecture architecture = (Architecture)this.entityManager.find(Architecture.class, (Object)architectureId);
        PackageVersion newPackageVersion = new PackageVersion(existingPackage, version, architecture);
        newPackageVersion.setDisplayName(existingPackage.getName());
        this.entityManager.persist((Object)newPackageVersion);
        HashMap<String, String> contentDetails = new HashMap<String, String>();
        PackageBits bits = this.loadPackageBits(packageBitStream, newPackageVersion.getId(), packageName, version, null, contentDetails);
        newPackageVersion.setPackageBits(bits);
        newPackageVersion.setFileSize(Long.valueOf(Long.valueOf((String)contentDetails.get(UPLOAD_FILE_SIZE))));
        newPackageVersion.setSHA256((String)contentDetails.get(UPLOAD_SHA256));
        newPackageVersion = this.persistOrMergePackageVersionSafely(newPackageVersion);
        existingPackage.addVersion(newPackageVersion);
        return newPackageVersion;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public PackageVersion persistPackageVersion(PackageVersion pv) {
        if (pv.getGeneralPackage().getId() > 0) {
            pv.setGeneralPackage((Package)this.entityManager.find(Package.class, (Object)pv.getGeneralPackage().getId()));
        }
        if (pv.getArchitecture().getId() > 0) {
            pv.setArchitecture((Architecture)this.entityManager.find(Architecture.class, (Object)pv.getArchitecture().getId()));
        }
        if (pv.getExtraProperties() != null && pv.getExtraProperties().getId() > 0) {
            pv.setExtraProperties((Configuration)this.entityManager.find(Configuration.class, (Object)pv.getExtraProperties().getId()));
        }
        this.entityManager.persist((Object)pv);
        return pv;
    }

    @Override
    public PackageVersion persistOrMergePackageVersionSafely(PackageVersion pv) {
        PackageVersion persisted = null;
        RuntimeException error = null;
        try {
            if (pv.getId() == 0) {
                persisted = this.contentManager.persistPackageVersion(pv);
            }
        }
        catch (RuntimeException re) {
            error = re;
        }
        if (persisted == null) {
            Query q = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
            q.setParameter("packageName", (Object)pv.getGeneralPackage().getName());
            q.setParameter("packageTypeName", (Object)pv.getGeneralPackage().getPackageType().getName());
            q.setParameter("architectureName", (Object)pv.getArchitecture().getName());
            q.setParameter("version", (Object)pv.getVersion());
            q.setParameter("resourceTypeId", (Object)pv.getGeneralPackage().getPackageType().getResourceType().getId());
            List found = q.getResultList();
            if (error != null && found.size() == 0) {
                throw error;
            }
            if (found.size() != 1) {
                throw new RuntimeException("Expecting 1 package version matching [" + pv + "] but got: " + found);
            }
            pv.setId(((PackageVersion)found.get(0)).getId());
            persisted = (PackageVersion)this.entityManager.merge((Object)pv);
            if (error != null) {
                this.log.warn((Object)"There was probably a very big and ugly EJB/hibernate error just above this log message - you can normally ignore that. We detected that a package version was already created when we tried to do it also - we will ignore this and just use the new package version that was created in the other thread", new Throwable("Stack Trace:"));
            }
        } else {
            persisted = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)persisted.getId());
            persisted.getGeneralPackage().getId();
            persisted.getArchitecture().getId();
            if (persisted.getExtraProperties() != null) {
                persisted.getExtraProperties().getId();
            }
        }
        return persisted;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Package persistPackage(Package pkg) {
        pkg.setPackageType((PackageType)this.entityManager.find(PackageType.class, (Object)pkg.getPackageType().getId()));
        this.entityManager.persist((Object)pkg);
        return pkg;
    }

    @Override
    public Package persistOrMergePackageSafely(Package pkg) {
        Package persisted = null;
        RuntimeException error = null;
        try {
            if (pkg.getId() == 0) {
                persisted = this.contentManager.persistPackage(pkg);
            }
        }
        catch (RuntimeException re) {
            error = re;
        }
        if (persisted == null) {
            Query q = this.entityManager.createNamedQuery("Package.findByNameAndPkgTypeId");
            q.setParameter("name", (Object)pkg.getName());
            q.setParameter("packageTypeId", (Object)pkg.getPackageType().getId());
            List found = q.getResultList();
            if (error != null && found.size() == 0) {
                throw error;
            }
            if (found.size() != 1) {
                throw new RuntimeException("Expecting 1 package matching [" + pkg + "] but got: " + found);
            }
            pkg.setId(((Package)found.get(0)).getId());
            persisted = (Package)this.entityManager.merge((Object)pkg);
            if (error != null) {
                this.log.warn((Object)"There was probably a very big and ugly EJB/hibernate error just above this log message - you can normally ignore that. We detected that a package was already created when we tried to do it also - we will ignore this and just use the new package that was created in the other thread");
            }
        } else {
            persisted = (Package)this.entityManager.find(Package.class, (Object)persisted.getId());
            persisted.getPackageType().getId();
        }
        return persisted;
    }

    @Override
    public PackageType getResourceCreationPackageType(int resourceTypeId) {
        Query query = this.entityManager.createNamedQuery("PackageType.findByResourceTypeIdAndCreationFlag");
        query.setParameter("typeId", (Object)resourceTypeId);
        PackageType packageType = (PackageType)query.getSingleResult();
        return packageType;
    }

    private ContentRequestStatus translateRequestResultStatus(ContentResponseResult result) {
        switch (result) {
            case SUCCESS: {
                return ContentRequestStatus.SUCCESS;
            }
        }
        return ContentRequestStatus.FAILURE;
    }

    private List<PackageInstallationStep> translateInstallationSteps(List<DeployPackageStep> transferSteps, InstalledPackageHistory history) {
        ArrayList<PackageInstallationStep> steps = new ArrayList<PackageInstallationStep>(transferSteps.size());
        int stepOrder = 0;
        for (DeployPackageStep transferStep : transferSteps) {
            PackageInstallationStep step = new PackageInstallationStep();
            step.setDescription(transferStep.getDescription());
            step.setKey(transferStep.getStepKey());
            step.setResult(transferStep.getStepResult());
            step.setErrorMessage(transferStep.getStepErrorMessage());
            step.setOrder(stepOrder++);
            step.setInstalledPackageHistory(history);
            steps.add(step);
        }
        return steps;
    }

    @Override
    public List<String> findInstalledPackageVersions(Subject user, int resourceId) {
        Query query = this.entityManager.createNamedQuery("InstalledPackage.findPackageListVersions");
        query.setParameter("resourceId", (Object)resourceId);
        List packages = query.getResultList();
        return packages;
    }

    @Override
    public PageList<InstalledPackage> findInstalledPackagesByCriteria(Subject subject, InstalledPackageCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<PackageVersion> findPackageVersionsByCriteria(Subject subject, PackageVersionCriteria criteria) {
        Integer resourceId = criteria.getFilterResourceId();
        if (!this.authorizationManager.isInventoryManager(subject)) {
            if (null == resourceId || criteria.isInventoryManagerRequired()) {
                throw new PermissionException("Subject [" + subject.getName() + "] requires InventoryManager permission for requested query criteria.");
            }
            if (!this.authorizationManager.canViewResource(subject, resourceId)) {
                throw new PermissionException("Subject [" + subject.getName() + "] does not have permission to view the specified resource.");
            }
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public InstalledPackage getBackingPackageForResource(Subject subject, int resourceId) {
        InstalledPackage result = null;
        InstalledPackageCriteria criteria = new InstalledPackageCriteria();
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        PageList<InstalledPackage> ips = this.findInstalledPackagesByCriteria(subject, criteria);
        if (null != ips && 1 == ips.size()) {
            result = (InstalledPackage)ips.get(0);
            result.getPackageVersion().getGeneralPackage().getId();
            result.getPackageVersion().getGeneralPackage().getPackageType().getId();
            result.getPackageVersion().getArchitecture().getId();
        }
        return result;
    }

    @Override
    public PackageVersion getUploadedPackageVersion(String packageName, int packageTypeId, String version, int architectureId, InputStream packageBitStream, Map<String, String> packageUploadDetails, int newResourceTypeId) {
        PackageVersion packageVersion = null;
        if (version == null || version.trim().length() == 0) {
            version = "1.0";
        }
        Query packageVersionQuery = this.entityManager.createNamedQuery("PackageVersion.findByPackageDetailsKey");
        packageVersionQuery.setFlushMode(FlushModeType.COMMIT);
        packageVersionQuery.setParameter("packageName", (Object)packageName);
        PackageType packageType = this.contentManager.getResourceCreationPackageType(newResourceTypeId);
        packageVersionQuery.setParameter("packageTypeName", (Object)packageType.getName());
        packageVersionQuery.setParameter("resourceTypeId", (Object)newResourceTypeId);
        Architecture architecture = (Architecture)this.entityManager.find(Architecture.class, (Object)architectureId);
        packageVersionQuery.setParameter("architectureName", (Object)architecture.getName());
        packageVersionQuery.setParameter("version", (Object)version);
        List existingPackageVersionList = packageVersionQuery.getResultList();
        if (existingPackageVersionList.size() > 0) {
            packageVersion = (PackageVersion)existingPackageVersionList.get(0);
        }
        Package existingPackage = null;
        Query packageQuery = this.entityManager.createNamedQuery("Package.findByNameAndPkgTypeId");
        packageQuery.setParameter("name", (Object)packageName);
        packageQuery.setParameter("packageTypeId", (Object)packageTypeId);
        List existingPackageList = packageQuery.getResultList();
        if (existingPackageList.size() == 0) {
            existingPackage = new Package(packageName, packageType);
            existingPackage = this.persistOrMergePackageSafely(existingPackage);
        } else {
            existingPackage = (Package)existingPackageList.get(0);
        }
        if (packageVersion == null) {
            packageVersion = new PackageVersion(existingPackage, version, architecture);
            packageVersion.setDisplayName(existingPackage.getName());
            this.entityManager.persist((Object)packageVersion);
        }
        PackageBits bits = this.loadPackageBits(packageBitStream, packageVersion.getId(), packageName, version, null, null);
        packageVersion.setPackageBits(bits);
        if (packageUploadDetails != null) {
            packageVersion.setFileCreatedDate(Long.valueOf(packageUploadDetails.get(UPLOAD_FILE_INSTALL_DATE)));
            packageVersion.setFileName(packageUploadDetails.get(UPLOAD_FILE_NAME));
            packageVersion.setFileSize(Long.valueOf(packageUploadDetails.get(UPLOAD_FILE_SIZE)));
            packageVersion.setMD5(packageUploadDetails.get(UPLOAD_MD5));
            packageVersion.setSHA256(packageUploadDetails.get(UPLOAD_SHA256));
        }
        this.entityManager.merge((Object)packageVersion);
        this.entityManager.flush();
        return packageVersion;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private PackageBits loadPackageBits(InputStream packageBitStream, int packageVersionId, String packageName, String packageVersion, PackageBits existingPkgBits, Map<String, String> contentDetails) {
        PackageBits bits = null;
        if (existingPkgBits == null) {
            bits = new PackageBits();
            this.entityManager.persist((Object)bits);
        } else {
            bits = existingPkgBits;
        }
        PackageVersion pv = (PackageVersion)this.entityManager.find(PackageVersion.class, (Object)packageVersionId);
        if (pv != null) {
            pv.setPackageBits(bits);
            this.entityManager.flush();
        }
        bits = (PackageBits)this.entityManager.find(PackageBits.class, (Object)bits.getId());
        this.updateBlobStream(packageBitStream, bits, contentDetails);
        return bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void updateBlobStream(InputStream stream, PackageBits bits, Map<String, String> contentDetails) {
        block43: {
            Exception e222222;
            Statement ps2;
            PreparedStatement ps;
            Connection conn;
            block37: {
                if (stream == null) {
                    return;
                }
                if (bits == null) {
                    bits = new PackageBits();
                }
                if (bits.getId() <= 0) {
                    this.entityManager.persist((Object)bits);
                }
                bits = (PackageBits)this.entityManager.find(PackageBits.class, (Object)bits.getId());
                bits.setBits(new String("a").getBytes());
                this.entityManager.merge((Object)bits);
                this.entityManager.flush();
                conn = null;
                ps = null;
                ps2 = null;
                conn = this.dataSource.getConnection();
                ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ? FOR UPDATE");
                ps.setInt(1, bits.getId());
                ResultSet rs = ps.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        Blob blb = rs.getBlob(1);
                        long transferred = this.copyAndDigest(stream, blb.setBinaryStream(1L), false, contentDetails);
                        stream.close();
                        ps2 = conn.prepareStatement("UPDATE RHQ_PACKAGE_BITS SET bits = ? where id = ?");
                        ps2.setBlob(1, blb);
                        ps2.setInt(2, bits.getId());
                        if (ps2.execute()) {
                            throw new Exception("Unable to upload the package bits to the DB:");
                        }
                        ps2.close();
                    }
                }
                ps.close();
                conn.close();
                Object var12_11 = null;
                if (ps == null) break block37;
                try {
                    ps.close();
                }
                catch (Exception e222222) {
                    this.log.warn((Object)("Failed to close prepared statement for package bits [" + bits.getId() + "]"));
                }
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (Exception e222222) {
                    this.log.warn((Object)("Failed to close prepared statement for package bits [" + bits.getId() + "]"));
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e222222) {
                    this.log.warn((Object)("Failed to close connection for package bits [" + bits.getId() + "]"));
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e222222) {
                    this.log.warn((Object)("Failed to close stream to package bits located at [" + bits.getId() + "]"));
                }
            }
            break block43;
            {
                catch (Exception e3) {
                    Exception e222222;
                    this.log.error((Object)("An error occurred while updating Blob with stream for PackageBits[" + bits.getId() + "], " + e3.getMessage()));
                    e3.printStackTrace();
                    Object var12_12 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception e222222) {
                            this.log.warn((Object)("Failed to close prepared statement for package bits [" + bits.getId() + "]"));
                        }
                    }
                    if (ps2 != null) {
                        try {
                            ps2.close();
                        }
                        catch (Exception e222222) {
                            this.log.warn((Object)("Failed to close prepared statement for package bits [" + bits.getId() + "]"));
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception e222222) {
                            this.log.warn((Object)("Failed to close connection for package bits [" + bits.getId() + "]"));
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception e222222) {
                            this.log.warn((Object)("Failed to close stream to package bits located at [" + bits.getId() + "]"));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e222222;
                Object var12_13 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e222222) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + bits.getId() + "]"));
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (Exception e222222) {
                        this.log.warn((Object)("Failed to close prepared statement for package bits [" + bits.getId() + "]"));
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e222222) {
                        this.log.warn((Object)("Failed to close connection for package bits [" + bits.getId() + "]"));
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e222222) {
                        this.log.warn((Object)("Failed to close stream to package bits located at [" + bits.getId() + "]"));
                    }
                }
                throw throwable;
            }
        }
        this.entityManager.merge((Object)bits);
        this.entityManager.flush();
    }

    @Override
    public void writeBlobOutToStream(OutputStream stream, PackageBits bits, boolean closeStreams) {
        if (stream == null) {
            return;
        }
        if (bits == null || bits.getId() <= 0) {
            this.log.warn((Object)"PackageBits insufficiently initialized. No data to write out.");
            return;
        }
        try {
            Connection conn = this.dataSource.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT BITS FROM RHQ_PACKAGE_BITS WHERE ID = ?");
            ps.setInt(1, bits.getId());
            ResultSet results = ps.executeQuery();
            if (results.next()) {
                Blob blob = results.getBlob(1);
                StreamUtil.copy((InputStream)blob.getBinaryStream(), (OutputStream)stream, (boolean)closeStreams);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("An error occurred while writing Blob contents out to stream :" + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    private long copyAndDigest(InputStream input, OutputStream output, boolean closeStreams, Map<String, String> contentDetails) throws RuntimeException {
        long numBytesCopied;
        block15: {
            numBytesCopied = 0L;
            int bufferSize = 32768;
            MessageDigestGenerator digestGenerator = null;
            if (contentDetails != null) {
                digestGenerator = new MessageDigestGenerator("SHA-256");
            }
            input = new BufferedInputStream(input, bufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = input.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                numBytesCopied += (long)bytesRead;
                if (digestGenerator != null) {
                    digestGenerator.add(buffer, 0, bytesRead);
                }
                bytesRead = input.read(buffer);
            }
            if (contentDetails != null) {
                contentDetails.put(UPLOAD_FILE_SIZE, String.valueOf(numBytesCopied));
                contentDetails.put(UPLOAD_SHA256, digestGenerator.getDigestString());
            }
            output.flush();
            Object var12_11 = null;
            if (!closeStreams) break block15;
            try {
                output.close();
            }
            catch (IOException ioe2) {
                this.log.warn((Object)"Streams could not be closed", (Throwable)ioe2);
            }
            try {
                input.close();
            }
            catch (IOException ioe2) {
                this.log.warn((Object)"Streams could not be closed", (Throwable)ioe2);
            }
            break block15;
            {
                catch (IOException ioe) {
                    throw new RuntimeException("Stream data cannot be copied", ioe);
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (closeStreams) {
                    try {
                        output.close();
                    }
                    catch (IOException ioe2) {
                        this.log.warn((Object)"Streams could not be closed", (Throwable)ioe2);
                    }
                    try {
                        input.close();
                    }
                    catch (IOException ioe2) {
                        this.log.warn((Object)"Streams could not be closed", (Throwable)ioe2);
                    }
                }
                throw throwable;
            }
        }
        return numBytesCopied;
    }
}

