/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.server.event.EventServerService;
import org.rhq.core.domain.event.transfer.EventReport;
import org.rhq.enterprise.server.event.EventManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EventServerServiceImpl
implements EventServerService {
    private Log log = LogFactory.getLog(this.getClass());

    public void mergeEventReport(EventReport report) {
        long startTime = System.currentTimeMillis();
        EventManagerLocal eventManager = LookupUtil.getEventManager();
        eventManager.addEventData(report.getEvents());
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (elapsedTime >= 10000L) {
            this.log.info((Object)("Performance: event report merge [" + report.getEvents().size() + "] timing: (" + elapsedTime + ")ms"));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Performance: event report merge [" + report.getEvents().size() + "] timing: (" + elapsedTime + ")ms"));
        }
    }
}

