/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.rhq.core.domain.resource.composite.ResourceNamesDisambiguationResult;
import org.rhq.core.util.IntExtractor;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationPolicy;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationUpdateStrategy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;
import org.rhq.enterprise.server.resource.disambiguation.ReportPartitions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Disambiguator {
    public static final int MAXIMUM_DISAMBIGUATED_TREE_DEPTH = 7;
    private static final String PARENT_INFO_QUERY;

    private Disambiguator() {
    }

    public static <T> ResourceNamesDisambiguationResult<T> disambiguate(List<T> results, DisambiguationUpdateStrategy disambiguationUpdateStrategy, IntExtractor<? super T> extractor, EntityManager entityManager) {
        if (results.isEmpty()) {
            return new ResourceNamesDisambiguationResult(new ArrayList());
        }
        ArrayList reports = new ArrayList(results.size());
        HashMap reportsByResourceId = new HashMap();
        for (T r : results) {
            int n = extractor.extract(r);
            MutableDisambiguationReport value = new MutableDisambiguationReport();
            value.original = r;
            if (n > 0) {
                ArrayList correspondingResults = (ArrayList)reportsByResourceId.get(n);
                if (correspondingResults == null) {
                    correspondingResults = new ArrayList();
                    reportsByResourceId.put(n, correspondingResults);
                }
                correspondingResults.add(value);
            }
            reports.add(value);
        }
        if (reportsByResourceId.size() > 0) {
            Query parentsQuery = entityManager.createQuery(PARENT_INFO_QUERY);
            parentsQuery.setParameter("resourceIds", reportsByResourceId.keySet());
            ReportPartitions partitionedReports = new ReportPartitions(DisambiguationPolicy.getUniqueNamePolicy(disambiguationUpdateStrategy));
            List list = parentsQuery.getResultList();
            for (Object[] parentsResult : list) {
                Integer parentId;
                ArrayList<MutableDisambiguationReport.Resource> parents = new ArrayList<MutableDisambiguationReport.Resource>(7);
                Integer resourceId = (Integer)parentsResult[0];
                String string = (String)parentsResult[1];
                Integer typeId = (Integer)parentsResult[2];
                String typeName = (String)parentsResult[3];
                String pluginName = (String)parentsResult[4];
                Boolean singleton = (Boolean)parentsResult[5];
                MutableDisambiguationReport.ResourceType resourceType = new MutableDisambiguationReport.ResourceType();
                resourceType.id = typeId;
                resourceType.name = typeName;
                resourceType.plugin = pluginName;
                resourceType.singleton = singleton;
                MutableDisambiguationReport.Resource resource = new MutableDisambiguationReport.Resource();
                resource.id = resourceId;
                resource.name = string;
                resource.resourceType = resourceType;
                for (int i = 0; i < 7 && (parentId = (Integer)parentsResult[6 + 6 * i]) != null; ++i) {
                    String parentName = (String)parentsResult[6 + 6 * i + 1];
                    Integer parentTypeId = (Integer)parentsResult[6 + 6 * i + 2];
                    String parentType = (String)parentsResult[6 + 6 * i + 3];
                    String parentPlugin = (String)parentsResult[6 + 6 * i + 4];
                    Boolean parentSingleton = (Boolean)parentsResult[6 + 6 * i + 5];
                    MutableDisambiguationReport.ResourceType type = new MutableDisambiguationReport.ResourceType();
                    type.id = parentTypeId;
                    type.name = parentType;
                    type.plugin = parentPlugin;
                    type.singleton = parentSingleton;
                    MutableDisambiguationReport.Resource parent = new MutableDisambiguationReport.Resource();
                    parent.id = parentId;
                    parent.name = parentName;
                    parent.resourceType = type;
                    parents.add(parent);
                }
                for (MutableDisambiguationReport report : (List)reportsByResourceId.get(resourceId)) {
                    report.resource = resource;
                    report.parents = parents;
                    partitionedReports.put(report);
                }
            }
            ArrayList<ReportPartitions<T>> ambiguousSubPartitions = new ArrayList<ReportPartitions<T>>();
            if (!partitionedReports.isPartitionsUnique()) {
                ambiguousSubPartitions.add(partitionedReports);
            } else {
                Disambiguator.repartitionUnique(partitionedReports, disambiguationUpdateStrategy, ambiguousSubPartitions);
            }
            while (ambiguousSubPartitions.size() > 0) {
                Iterator subPartitionIterator = ambiguousSubPartitions.iterator();
                ArrayList<ReportPartitions<T>> newAmbiguousPartitions = new ArrayList<ReportPartitions<T>>();
                while (subPartitionIterator.hasNext()) {
                    ReportPartitions subPartition = (ReportPartitions)subPartitionIterator.next();
                    Disambiguator.repartitionUnique(subPartition, disambiguationUpdateStrategy, newAmbiguousPartitions);
                    for (List partitionReports : subPartition.getAmbiguousPartitions()) {
                        ReportPartitions replacementSubpartition = new ReportPartitions(subPartition.getDisambiguationPolicy().getNext());
                        replacementSubpartition.putAll(partitionReports);
                        if (!replacementSubpartition.isPartitionsUnique()) {
                            newAmbiguousPartitions.add(replacementSubpartition);
                            continue;
                        }
                        Disambiguator.repartitionUnique(replacementSubpartition, disambiguationUpdateStrategy, newAmbiguousPartitions);
                    }
                    subPartitionIterator.remove();
                }
                for (ReportPartitions reportPartitions : newAmbiguousPartitions) {
                    ambiguousSubPartitions.add(reportPartitions);
                }
            }
        }
        ArrayList resolution = new ArrayList(results.size());
        for (MutableDisambiguationReport mutableDisambiguationReport : reports) {
            resolution.add(mutableDisambiguationReport.getReport());
        }
        return new ResourceNamesDisambiguationResult(resolution);
    }

    private static <T> void repartitionUnique(ReportPartitions<T> partitions, DisambiguationUpdateStrategy updateStrategy, List<ReportPartitions<T>> ambigousPartitions) {
        DisambiguationPolicy repartitionPolicy;
        while ((repartitionPolicy = partitions.getDisambiguationPolicy().getNextRepartitioningPolicy()) != null) {
            if ((partitions = new ReportPartitions<T>(repartitionPolicy, partitions.getUniquePartitions())).isPartitionsUnique()) continue;
            ambigousPartitions.add(partitions);
            return;
        }
        for (List<MutableDisambiguationReport<T>> partition : partitions.getUniquePartitions()) {
            for (MutableDisambiguationReport<T> report : partition) {
                updateStrategy.update(partitions.getDisambiguationPolicy(), report);
            }
        }
    }

    static {
        StringBuilder selectBuilder = new StringBuilder("SELECT r0.id, r0.name, r0.resourceType.id, r0.resourceType.name, r0.resourceType.plugin, r0.resourceType.singleton");
        StringBuilder fromBuilder = new StringBuilder("FROM Resource r0");
        for (int i = 1; i <= 7; ++i) {
            int pi = i - 1;
            selectBuilder.append(", r").append(i).append(".id");
            selectBuilder.append(", r").append(i).append(".name");
            selectBuilder.append(", rt").append(i).append(".id");
            selectBuilder.append(", rt").append(i).append(".name");
            selectBuilder.append(", rt").append(i).append(".plugin");
            selectBuilder.append(", rt").append(i).append(".singleton");
            fromBuilder.append(" left join r").append(pi).append(".parentResource r").append(i);
            fromBuilder.append(" left join r").append(i).append(".resourceType rt").append(i);
        }
        fromBuilder.append(" WHERE r0.id IN (:resourceIds)");
        PARENT_INFO_QUERY = selectBuilder.append(" ").append((CharSequence)fromBuilder).toString();
    }
}

