/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import java.util.Random;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public class SessionManagerTest {
    private static final String TEST_USERNAME = "SessionManagerTestUsername";
    private SessionManager sessionManager = SessionManager.getInstance();
    private int initialSessionCount;

    @BeforeMethod
    public void getInitialSessionCount() {
        this.sessionManager.purgeTimedOutSessions();
        this.initialSessionCount = this.sessionManager.getSessionCount();
    }

    public void testLoginAndInvalidateBySessionId() throws Exception {
        Subject subject = this.sessionManager.put(this.getTestSubject());
        assert (subject != null);
        assert (subject.getSessionId() != null);
        assert (this.initialSessionCount + 1 == this.sessionManager.getSessionCount());
        Integer sessionId = subject.getSessionId();
        assert (this.sessionManager.getLastAccess(sessionId.intValue()) > 0L);
        Subject subject2 = this.sessionManager.getSubject(subject.getSessionId().intValue());
        assert (subject.equals((Object)subject2));
        assert (subject2.getSessionId() == subject.getSessionId());
        this.sessionManager.invalidate(sessionId.intValue());
        try {
            this.sessionManager.getSubject(sessionId.intValue());
            assert (false) : "The session should be been invalidated";
        }
        catch (SessionNotFoundException ok) {
            // empty catch block
        }
        assert (this.sessionManager.getLastAccess(sessionId.intValue()) == -1L);
        assert (this.initialSessionCount == this.sessionManager.getSessionCount());
    }

    public void testLoginAndInvalidateBySubject() throws Exception {
        Subject subject = this.sessionManager.put(this.getTestSubject());
        assert (subject != null);
        assert (subject.getSessionId() != null);
        assert (this.initialSessionCount + 1 == this.sessionManager.getSessionCount());
        Integer sessionId = subject.getSessionId();
        assert (this.sessionManager.getLastAccess(sessionId.intValue()) > 0L);
        Subject subject2 = this.sessionManager.getSubject(subject.getSessionId().intValue());
        assert (subject.equals((Object)subject2));
        assert (subject2.getSessionId() == subject.getSessionId());
        this.sessionManager.invalidate(subject2.getName());
        try {
            this.sessionManager.getSubject(sessionId.intValue());
            assert (false) : "The session should be been invalidated";
        }
        catch (SessionNotFoundException ok) {
            // empty catch block
        }
        assert (this.sessionManager.getLastAccess(sessionId.intValue()) == -1L);
        assert (this.initialSessionCount == this.sessionManager.getSessionCount());
    }

    public void testTimeout() throws Exception {
        Subject subject = this.sessionManager.put(this.getTestSubject(), 1000L);
        assert (null != this.sessionManager.getSubject(subject.getSessionId().intValue()));
        assert (this.initialSessionCount + 1 == this.sessionManager.getSessionCount());
        Thread.sleep(1200L);
        try {
            this.sessionManager.getSubject(subject.getSessionId().intValue());
            assert (false) : "The session should have timed out";
        }
        catch (SessionTimeoutException sessionTimeoutException) {
            // empty catch block
        }
        assert (this.sessionManager.getLastAccess(subject.getSessionId().intValue()) == -1L);
        assert (this.initialSessionCount == this.sessionManager.getSessionCount());
    }

    public void testTimeoutSomeSessions() throws Exception {
        Subject subject = this.sessionManager.put(this.getTestSubject(), 1000L);
        assert (null != this.sessionManager.getSubject(subject.getSessionId().intValue()));
        Subject subject2 = this.sessionManager.put(this.getNewSubject("longLivedUser"), 60000L);
        assert (null != this.sessionManager.getSubject(subject2.getSessionId().intValue()));
        assert (this.initialSessionCount + 2 == this.sessionManager.getSessionCount());
        Thread.sleep(1200L);
        try {
            this.sessionManager.getSubject(subject.getSessionId().intValue());
            assert (false) : "The session should have timed out";
        }
        catch (SessionTimeoutException sessionTimeoutException) {
            // empty catch block
        }
        assert (this.sessionManager.getLastAccess(subject.getSessionId().intValue()) == -1L);
        assert (null != this.sessionManager.getSubject(subject2.getSessionId().intValue()));
        assert (this.sessionManager.getLastAccess(subject2.getSessionId().intValue()) > 0L);
        assert (this.initialSessionCount + 1 == this.sessionManager.getSessionCount());
        this.sessionManager.invalidate(subject2.getSessionId().intValue());
        assert (this.initialSessionCount == this.sessionManager.getSessionCount());
    }

    public void testPurge() throws Exception {
        Subject subject1 = this.sessionManager.put(this.getNewSubject("shortLivedUser1"), 1000L);
        assert (null != this.sessionManager.getSubject(subject1.getSessionId().intValue()));
        Subject subject2 = this.sessionManager.put(this.getNewSubject("shortLivedUser2"), 1200L);
        assert (null != this.sessionManager.getSubject(subject2.getSessionId().intValue()));
        Subject subject3 = this.sessionManager.put(this.getNewSubject("longLivedUser"), 60000L);
        assert (null != this.sessionManager.getSubject(subject3.getSessionId().intValue()));
        assert (this.initialSessionCount + 3 == this.sessionManager.getSessionCount());
        Thread.sleep(1500L);
        this.sessionManager.purgeTimedOutSessions();
        assert (this.initialSessionCount + 1 == this.sessionManager.getSessionCount());
        try {
            this.sessionManager.getSubject(subject1.getSessionId().intValue());
            assert (false) : "The session should not have been found - it should have been purged!";
        }
        catch (SessionNotFoundException e) {
            // empty catch block
        }
        try {
            this.sessionManager.getSubject(subject2.getSessionId().intValue());
            assert (false) : "The session should not have been found - it should have been purged!!";
        }
        catch (SessionNotFoundException e) {
            // empty catch block
        }
        assert (null != this.sessionManager.getSubject(subject3.getSessionId().intValue()));
        assert (this.sessionManager.getLastAccess(subject1.getSessionId().intValue()) == -1L);
        assert (this.sessionManager.getLastAccess(subject2.getSessionId().intValue()) == -1L);
        assert (this.sessionManager.getLastAccess(subject3.getSessionId().intValue()) > 0L);
        this.sessionManager.invalidate(subject3.getSessionId().intValue());
        assert (this.initialSessionCount == this.sessionManager.getSessionCount());
    }

    private Subject getTestSubject() {
        return this.getNewSubject(TEST_USERNAME);
    }

    private Subject getNewSubject(String username) {
        Subject s = new Subject(username, true, false);
        s.setId(new Random(System.currentTimeMillis()).nextInt());
        return s;
    }
}

