/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.util.StringUtils;
import org.rhq.enterprise.server.rest.helper.ConfigurationHelper;
import org.testng.annotations.Test;

public class ConfigurationHelperTest {
    @Test
    public void testConvertSimpleMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        map.put("Answer", 42);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2);
        PropertySimple hello = config.getSimple("Hello");
        assert (hello != null);
        assert (hello.getStringValue().equals("World"));
        PropertySimple qu = config.getSimple("Answer");
        assert (qu != null);
        Integer value = qu.getIntegerValue();
        assert (value != null);
        assert (value == 42);
    }

    @Test
    public void testConvertWithNestedMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("Hello", "World");
        map.put("Answer", 42);
        HashMap<String, String> inner = new HashMap<String, String>(1);
        inner.put("Foo", "Bar");
        map.put("Inner", inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 3) : "Expected 3 props, got " + properties.size();
        Property prop = config.get("Inner");
        assert (prop != null);
        assert (prop instanceof PropertyMap) : "Inner is no map";
        PropertyMap pm = (PropertyMap)prop;
        Map innerMap = pm.getMap();
        assert (innerMap.size() == 1);
        assert (inner.containsKey("Foo"));
    }

    @Test
    public void testConvertListOfMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        ArrayList list = new ArrayList();
        map.put("list", list);
        HashMap<String, String> inner = new HashMap<String, String>(1);
        inner.put("Foo", "Bar");
        list.add(inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2) : "Expected 2 props, got " + properties.size();
        Property prop = config.get("Inner");
        assert (prop == null);
        prop = config.get("list");
        assert (prop instanceof PropertyList) : "list is no list";
        PropertyList pl = (PropertyList)prop;
        List propertyList = pl.getList();
        assert (propertyList.size() == 1);
        PropertyMap innerMapProperty = (PropertyMap)propertyList.get(0);
        Map propertyMap = innerMapProperty.getMap();
        assert (propertyMap.size() == 1);
        Map innerMap = propertyMap;
        assert (innerMap.containsKey("Foo"));
        Property property = innerMapProperty.get("Foo");
        assert (property != null);
        assert (property instanceof PropertySimple);
        PropertySimple ps = (PropertySimple)property;
        assert (ps.getStringValue().equals("Bar"));
    }

    @Test
    public void testConvertWithListOfSimple() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        map.put("Answer", 42);
        ArrayList<String> inner = new ArrayList<String>(2);
        inner.add("Foo");
        inner.add("Bar");
        map.put("Inner", inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 3) : "Expected 3 props, got " + properties.size();
        Property prop = config.get("Inner");
        assert (prop != null);
        assert (prop instanceof PropertyList) : "Inner is no list";
        PropertyList plist = (PropertyList)prop;
        List propertyList = plist.getList();
        assert (propertyList.size() == 2);
        for (Property innerProp : propertyList) {
            assert (innerProp instanceof PropertySimple);
            PropertySimple ps = (PropertySimple)innerProp;
            assert (ps.getName().equals("Inner"));
            assert (ps.getStringValue().equals("Foo") || ps.getStringValue().equals("Bar"));
        }
    }

    @Test
    public void testConvertAndValidateBoolean() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bool1", "true");
        map.put("bool2", "TruE");
        map.put("bool3", "fAlSe");
        map.put("bool4", "false");
        map.put("bool5", 42);
        map.put("bool6", "Hugo");
        map.put("bool7", null);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 7) : "Expected 7 props but got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", "For testing");
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool1", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool2", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool3", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool4", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool5", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool6", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool7", "A boolean", true, PropertySimpleType.BOOLEAN));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 3) : "Expected 3 errors, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n ");
    }

    @Test
    public void testConvertAndValidateMissingRequired() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("bool1", "true");
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 1) : "Expected 1 props but got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", "For testing");
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool1", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool2", "A boolean", true, PropertySimpleType.BOOLEAN));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 1) : "Expected 1 error, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n ");
    }

    @Test
    public void testConvertAndValidateNotRequiredButNull() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("bool1", "true");
        map.put("optional", null);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2) : "Expected 2 props but got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", "For testing");
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool1", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("optional", "null string", false, PropertySimpleType.STRING));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 0) : "Expected 0 error, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n ");
    }

    @Test
    public void testConvertAndValidateMismatchingKind() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("bool1", "true");
        map.put("optional", null);
        HashMap<String, String> inner = new HashMap<String, String>(1);
        inner.put("Foo", "Bar");
        map.put("Inner", inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 3) : "Expected 3 props but got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", "For testing");
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool1", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("optional", "null string", false, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Inner", "null string", false, PropertySimpleType.STRING));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 1) : "Expected 1 error, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n ");
    }

    @Test
    public void testConvertAndValidateMismatchingKind2() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("bool1", "true");
        map.put("optional", null);
        map.put("Inner", "Frobnitz");
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 3) : "Expected 3 props but got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", "For testing");
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool1", "A boolean", true, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("optional", "null string", false, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionList("Inner", "Bla", true, (PropertyDefinition)new PropertyDefinitionSimple("Inner", "fasel", true, PropertySimpleType.STRING)));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 1) : "Expected 1 error, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n ");
    }

    @Test
    public void testConvertAndValidateNumeric() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("float1", Float.valueOf(1.1f));
        map.put("float2", Double.MAX_VALUE);
        map.put("float3", null);
        map.put("float4", "abc");
        map.put("double1", 1.1);
        map.put("double2", null);
        map.put("double3", "hugo");
        map.put("int1", 42);
        map.put("int2", Long.MAX_VALUE);
        map.put("int3", null);
        map.put("int4", "abc");
        map.put("long1", -5);
        map.put("long2", null);
        map.put("long3", "Frobnitz");
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 14) : "Expected 14 props but got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", "For testing");
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("float1", "A float", true, PropertySimpleType.FLOAT));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("float2", "A float", true, PropertySimpleType.FLOAT));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("float3", "A float", true, PropertySimpleType.FLOAT));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("float4", "A float", true, PropertySimpleType.FLOAT));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("double1", "A double", true, PropertySimpleType.DOUBLE));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("double2", "A double", true, PropertySimpleType.DOUBLE));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("double3", "A double", true, PropertySimpleType.DOUBLE));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("int1", "An int", true, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("int2", "An int", true, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("int3", "An int", true, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("int4", "An int", true, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("long1", "A long", true, PropertySimpleType.LONG));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("long2", "A long", true, PropertySimpleType.LONG));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("long3", "A long", true, PropertySimpleType.LONG));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 10) : "Expected 10 errors, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n");
    }

    @Test
    public void testValidateNullConfiguration() throws Exception {
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition(null, (ConfigurationDefinition)new ConfigurationDefinition("bla", null));
        assert (errors != null);
        assert (errors.size() == 1);
    }

    @Test
    public void testValidateNullDefinition() throws Exception {
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)new Configuration(), null);
        assert (errors != null);
        assert (errors.size() == 1);
    }

    @Test
    public void testConvertAndValidateSimpleMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        map.put("Answer", 42);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Hello", null, true, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Answer", null, true, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Optional", null, false, PropertySimpleType.INTEGER));
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2);
        PropertySimple hello = config.getSimple("Hello");
        assert (hello != null);
        assert (hello.getStringValue().equals("World"));
        PropertySimple qu = config.getSimple("Answer");
        assert (qu != null);
        Integer integerValue = qu.getIntegerValue();
        assert (integerValue != null);
        assert (integerValue == 42);
    }

    @Test
    public void testConvertValidateNonRequiredNotPresent() throws Exception {
        HashMap map = new HashMap(2);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 0) : "Expected 0 props, got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Answer", null, false, PropertySimpleType.INTEGER));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 0) : "Expected 0 errors, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n");
    }

    @Test
    public void testConvertAndValidateListOfMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        ArrayList list = new ArrayList();
        map.put("list", list);
        HashMap<String, String> inner = new HashMap<String, String>(1);
        inner.put("Foo", "Bar");
        list.add(inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2) : "Expected 2 props, got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Hello", null, true, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Answer", null, false, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionList("list", null, true, (PropertyDefinition)new PropertyDefinitionMap("list", null, true, new PropertyDefinition[]{new PropertyDefinitionSimple("list", null, true, PropertySimpleType.STRING)})));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("aString", null, false, PropertySimpleType.INTEGER));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 0) : "Expected 0 errors, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n");
    }

    @Test
    public void testConvertAndValidateMapOfMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        HashMap list = new HashMap();
        map.put("list", list);
        HashMap<String, String> inner = new HashMap<String, String>(1);
        inner.put("Foo", "Bar");
        list.put("outer", inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2) : "Expected 2 props, got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Hello", null, true, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionMap("list", null, true, new PropertyDefinition[]{new PropertyDefinitionMap("list", null, true, new PropertyDefinition[]{new PropertyDefinitionSimple("list", null, true, PropertySimpleType.STRING)})}));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 0) : "Expected 0 errors, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n");
    }

    @Test
    public void testConvertAndValidateMapWithListOfSimple() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("Hello", "World");
        HashMap list = new HashMap();
        map.put("list", list);
        ArrayList<String> inner = new ArrayList<String>();
        inner.add("Foo");
        inner.add("Bar");
        list.put("outer", inner);
        Configuration config = ConfigurationHelper.mapToConfiguration(map);
        assert (config != null);
        Collection properties = config.getProperties();
        assert (properties.size() == 2) : "Expected 2 props, got " + properties.size();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("Hello", null, true, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionMap("list", null, true, new PropertyDefinition[]{new PropertyDefinitionList("list", null, true, (PropertyDefinition)new PropertyDefinitionSimple("list", null, true, PropertySimpleType.STRING))}));
        List errors = ConfigurationHelper.checkConfigurationWrtDefinition((Configuration)config, (ConfigurationDefinition)definition);
        assert (errors != null);
        assert (errors.size() == 0) : "Expected 0 errors, but got " + errors.size() + "\n" + StringUtils.getListAsString((List)errors, (String)",\n");
    }

    @Test
    public void testConfigToMapSimple() throws Exception {
        Configuration config = new Configuration();
        config.put((Property)new PropertySimple("number", (Object)42));
        config.put((Property)new PropertySimple("string", (Object)"Hello"));
        config.put((Property)new PropertySimple("bool", (Object)true));
        config.put((Property)new PropertySimple("float", (Object)Float.valueOf(1.1f)));
        config.put((Property)new PropertySimple("double", (Object)2.3));
        config.put((Property)new PropertySimple("long", (Object)Long.MAX_VALUE));
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("number", null, false, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("bool", null, false, PropertySimpleType.BOOLEAN));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("float", null, false, PropertySimpleType.FLOAT));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("double", null, false, PropertySimpleType.DOUBLE));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("long", null, false, PropertySimpleType.LONG));
        Map map = ConfigurationHelper.configurationToMap((Configuration)config, (ConfigurationDefinition)definition, (boolean)true);
        assert (map != null);
        assert (map.entrySet().size() == 6);
        assert (map.containsKey("number"));
        assert (map.containsKey("string"));
        assert (map.get("number") != null);
        assert ((Integer)map.get("number") == 42);
        assert (map.get("string") != null);
        assert (map.get("string").equals("Hello"));
        assert (((Boolean)map.get("bool")).booleanValue());
        assert (map.get("float") != null);
        assert (((Float)map.get("float")).floatValue() == 1.1f);
        assert (map.get("double") != null);
        assert ((Double)map.get("double") == 2.3);
        assert (map.get("long") != null);
        assert ((Long)map.get("long") == Long.MAX_VALUE);
    }

    @Test
    public void testEmptyConfigToMap() throws Exception {
        Configuration config = new Configuration();
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("number", null, false, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING));
        Map map = ConfigurationHelper.configurationToMap((Configuration)config, (ConfigurationDefinition)definition, (boolean)true);
        assert (map != null);
        assert (map.entrySet().size() == 0);
    }

    @Test
    public void testNullConfigToMap() throws Exception {
        Configuration config = null;
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("number", null, false, PropertySimpleType.INTEGER));
        definition.put((PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING));
        Map map = ConfigurationHelper.configurationToMap(config, (ConfigurationDefinition)definition, (boolean)true);
        assert (map != null);
        assert (map.entrySet().size() == 0);
    }

    @Test
    public void testConfigToMapComplexList() throws Exception {
        Configuration config = new Configuration();
        PropertyList propertyList = new PropertyList("aList");
        propertyList.add((Property)new PropertySimple("string", (Object)"Hello"));
        propertyList.add((Property)new PropertySimple("string", (Object)"World"));
        config.put((Property)propertyList);
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionList("aList", null, false, (PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING)));
        Map map = ConfigurationHelper.configurationToMap((Configuration)config, (ConfigurationDefinition)definition, (boolean)true);
        assert (map != null);
        assert (map.entrySet().size() == 1);
        assert (map.containsKey("aList"));
    }

    @Test
    public void testConfigToMapComplexMap() throws Exception {
        Configuration config = new Configuration();
        PropertyMap propertyMap = new PropertyMap("aMap");
        config.put((Property)propertyMap);
        PropertyList propertyList = new PropertyList("aList");
        propertyList.add((Property)new PropertySimple("string", (Object)"Hello"));
        propertyList.add((Property)new PropertySimple("string", (Object)"World"));
        propertyMap.put((Property)propertyList);
        propertyMap.put((Property)new PropertySimple("aString", (Object)"Frobnitz"));
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionMap("aMap", null, false, new PropertyDefinition[]{new PropertyDefinitionList("aList", null, false, (PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING)), new PropertyDefinitionSimple("aString", null, false, PropertySimpleType.STRING)}));
        Map map = ConfigurationHelper.configurationToMap((Configuration)config, (ConfigurationDefinition)definition, (boolean)true);
        assert (map != null);
        assert (map.entrySet().size() == 1);
        assert (map.containsKey("aMap"));
        assert (map.get("aMap") instanceof Map);
        Map innerMap = (Map)map.get("aMap");
        assert (innerMap.containsKey("aString"));
        assert (innerMap.containsKey("aList"));
    }

    @Test
    public void testConfigToMapComplexMapWithBadSetupStrict() throws Exception {
        Configuration config = new Configuration();
        PropertyMap propertyMap = new PropertyMap("aMap");
        config.put((Property)propertyMap);
        PropertyList propertyList = new PropertyList("aList");
        propertyList.add((Property)new PropertySimple("string", (Object)"Hello"));
        propertyList.add((Property)new PropertySimple("string", (Object)"World"));
        propertyMap.put((Property)propertyList);
        propertyMap.put((Property)new PropertySimple("aString", (Object)"Frobnitz"));
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionMap("aMap", null, false, new PropertyDefinition[]{new PropertyDefinitionList("aBla", null, false, (PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING)), new PropertyDefinitionSimple("aFoo", null, false, PropertySimpleType.STRING)}));
        try {
            ConfigurationHelper.configurationToMap((Configuration)config, (ConfigurationDefinition)definition, (boolean)true);
            assert (false);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Yep, caught the error");
        }
    }

    @Test(enabled=false)
    public void testConfigToMapComplexMapWithBadSetupLenient() throws Exception {
        Configuration config = new Configuration();
        PropertyMap propertyMap = new PropertyMap("aMap");
        config.put((Property)propertyMap);
        PropertyList propertyList = new PropertyList("aList");
        propertyList.add((Property)new PropertySimple("string", (Object)"Hello"));
        propertyList.add((Property)new PropertySimple("string", (Object)"World"));
        propertyMap.put((Property)propertyList);
        propertyMap.put((Property)new PropertySimple("aString", (Object)"Frobnitz"));
        ConfigurationDefinition definition = new ConfigurationDefinition("bla", null);
        definition.put((PropertyDefinition)new PropertyDefinitionMap("aMap", null, false, new PropertyDefinition[]{new PropertyDefinitionList("aBla", null, false, (PropertyDefinition)new PropertyDefinitionSimple("string", null, false, PropertySimpleType.STRING)), new PropertyDefinitionSimple("aFoo", null, false, PropertySimpleType.STRING)}));
        Map map = ConfigurationHelper.configurationToMap((Configuration)config, (ConfigurationDefinition)definition, (boolean)false);
        assert (map != null);
        assert (map.entrySet().size() == 1);
        assert (map.containsKey("aMap"));
    }

    @Test
    public void testConvertSingleValueNoProperty() throws Exception {
        Object o = ConfigurationHelper.convertSimplePropertyValue(null, (PropertyDefinitionSimple)new PropertyDefinitionSimple("dummy", null, false, PropertySimpleType.STRING));
        assert (o == null);
    }

    @Test
    public void testConvertSingleValueNoDefinition() throws Exception {
        try {
            ConfigurationHelper.convertSimplePropertyValue((PropertySimple)new PropertySimple("foo", (Object)"bar"), null);
            assert (false);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Yep, good");
        }
    }
}

