/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.Package;
import org.rhq.core.domain.content.PackageBits;
import org.rhq.core.domain.content.PackageBitsBlob;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.enterprise.server.content.ContentManagerBean;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.plugin.pc.content.PackageTypeBehavior;
import org.testng.Assert;
import org.testng.IObjectFactory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

@PrepareForTest(value={ContentManagerHelper.class})
public class ContentManagerBeanMockTest {
    @ObjectFactory
    public IObjectFactory getObjectFactory() {
        return new PowerMockObjectFactory();
    }

    @Test
    public void testCreatePackageVersion() throws Exception {
        Field[] fields;
        Subject mockSubject = (Subject)Mockito.mock(Subject.class);
        String packageName = "PackageName";
        int packageTypeID = 1;
        String version = "PackageVersion";
        String displayVersion = "PackageDisplayVersion";
        int architectureId = 2;
        String sampleContent = "SampleContent";
        ByteArrayInputStream packageBitStream = new ByteArrayInputStream(sampleContent.getBytes());
        EntityManager mockEntityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"PackageVersion.findByPackageVerArch"))).thenReturn((Object)mockQuery);
        List mockList = (List)Mockito.mock(List.class);
        Mockito.when((Object)mockQuery.getResultList()).thenReturn((Object)mockList);
        Architecture mockArchitecture = (Architecture)Mockito.mock(Architecture.class);
        Mockito.when((Object)mockArchitecture.getName()).thenReturn((Object)"ArchitectureName");
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(Architecture.class), (Object)Matchers.anyInt())).thenReturn((Object)mockArchitecture);
        PackageType mockPackageType = (PackageType)Mockito.mock(PackageType.class);
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(PackageType.class), (Object)Matchers.eq((int)1))).thenReturn((Object)mockPackageType);
        PackageTypeBehavior mockPackageTypeBehavior = (PackageTypeBehavior)Mockito.mock(PackageTypeBehavior.class);
        PowerMockito.mockStatic(ContentManagerHelper.class);
        Mockito.when((Object)ContentManagerHelper.getPackageTypeBehavior((int)1)).thenReturn((Object)mockPackageTypeBehavior);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"Architecture.findByName"))).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"Package.findByNameAndPkgTypeId"))).thenReturn((Object)mockQuery);
        ContentManagerLocal mockContentManager = (ContentManagerLocal)Mockito.mock(ContentManagerLocal.class);
        Package mockPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)mockContentManager.persistPackage((Package)Matchers.isNotNull(Package.class))).thenReturn((Object)mockPackage);
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(Package.class), Matchers.any())).thenReturn((Object)mockPackage);
        Mockito.when((Object)mockPackage.getPackageType()).thenReturn((Object)mockPackageType);
        PackageVersion mockPackageVersion = (PackageVersion)Mockito.mock(PackageVersion.class);
        Mockito.when((Object)mockContentManager.persistPackageVersion((PackageVersion)Matchers.isNotNull(PackageVersion.class))).thenReturn((Object)mockPackageVersion);
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(PackageVersion.class), (Object)Matchers.anyInt())).thenReturn((Object)mockPackageVersion);
        Mockito.when((Object)mockPackageVersion.getGeneralPackage()).thenReturn((Object)mockPackage);
        Mockito.when((Object)mockPackageVersion.getArchitecture()).thenReturn((Object)mockArchitecture);
        PackageBitsBlob mockPackageBitsBlob = (PackageBitsBlob)Mockito.mock(PackageBitsBlob.class);
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(PackageBitsBlob.class), (Object)Matchers.anyInt())).thenReturn((Object)mockPackageBitsBlob);
        PackageBits mockBits = (PackageBits)Mockito.mock(PackageBits.class);
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(PackageBits.class), (Object)Matchers.anyInt())).thenReturn((Object)mockBits);
        DataSource mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)mockDataSource.getConnection()).thenReturn((Object)mockConnection);
        PreparedStatement mockPreparedStatement1 = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)mockConnection.prepareStatement(Matchers.anyString())).thenReturn((Object)mockPreparedStatement1);
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockPreparedStatement1.executeQuery()).thenReturn((Object)mockResultSet);
        Mockito.when((Object)mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Blob mockBlob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)mockResultSet.getBlob(Matchers.anyInt())).thenReturn((Object)mockBlob);
        OutputStream mockOutputStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)mockBlob.setBinaryStream(Matchers.anyLong())).thenReturn((Object)mockOutputStream);
        ContentManagerBean objectUnderTest = new ContentManagerBean();
        for (Field field : fields = ContentManagerBean.class.getDeclaredFields()) {
            if (field.getName().equals("entityManager")) {
                field.setAccessible(true);
                field.set(objectUnderTest, mockEntityManager);
                field.setAccessible(false);
                continue;
            }
            if (field.getName().equals("contentManager")) {
                field.setAccessible(true);
                field.set(objectUnderTest, mockContentManager);
                field.setAccessible(false);
                continue;
            }
            if (!field.getName().equals("dataSource")) continue;
            field.setAccessible(true);
            field.set(objectUnderTest, mockDataSource);
            field.setAccessible(false);
        }
        PackageVersion result = objectUnderTest.createPackageVersionWithDisplayVersion(mockSubject, packageName, packageTypeID, version, displayVersion, architectureId, (InputStream)packageBitStream);
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)2))).size();
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.never())).get(Matchers.anyInt());
        ((PackageVersion)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)2))).setPackageBits((PackageBits)Matchers.any(PackageBits.class));
        MessageDigestGenerator digest = new MessageDigestGenerator("SHA-256");
        ((PackageVersion)Mockito.verify((Object)result)).setSHA256(digest.calcDigestString(sampleContent));
        ((PackageVersion)Mockito.verify((Object)result)).setFileSize(Long.valueOf(sampleContent.getBytes().length));
        ((PackageVersion)Mockito.verify((Object)result)).setDisplayVersion(displayVersion);
    }

    @Test
    public void testCreatePackageVersionExistingPackage() throws Exception {
        Field[] fields;
        Subject mockSubject = (Subject)Mockito.mock(Subject.class);
        String packageName = "PackageName";
        int packageTypeID = 1;
        String version = "PackageVersion";
        String displayVersion = null;
        int architectureId = 2;
        String sampleContent = "SampleContent";
        ByteArrayInputStream packageBitStream = new ByteArrayInputStream(sampleContent.getBytes());
        EntityManager mockEntityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"PackageVersion.findByPackageVerArch"))).thenReturn((Object)mockQuery);
        List mockList = (List)Mockito.mock(List.class);
        Mockito.when((Object)mockQuery.getResultList()).thenReturn((Object)mockList);
        Mockito.when((Object)mockList.size()).thenReturn((Object)1);
        PackageVersion mockPackageVersion = (PackageVersion)Mockito.mock(PackageVersion.class);
        Mockito.when(mockList.get(Matchers.eq((int)0))).thenReturn((Object)mockPackageVersion);
        ContentManagerBean objectUnderTest = new ContentManagerBean();
        for (Field field : fields = ContentManagerBean.class.getDeclaredFields()) {
            if (!field.getName().equals("entityManager")) continue;
            field.setAccessible(true);
            field.set(objectUnderTest, mockEntityManager);
            field.setAccessible(false);
        }
        PackageVersion result = objectUnderTest.createPackageVersionWithDisplayVersion(mockSubject, packageName, packageTypeID, version, displayVersion, architectureId, (InputStream)packageBitStream);
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).size();
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).get(Matchers.eq((int)0));
        ((EntityManager)Mockito.verify((Object)mockEntityManager, (VerificationMode)Mockito.times((int)1))).createNamedQuery(Matchers.anyString());
        Assert.assertEquals((Object)mockPackageVersion, (Object)result);
    }

    @Test
    public void testCreatePackageVersionExistingPackageEmptyDisplayVersion() throws Exception {
        Field[] fields;
        Subject mockSubject = (Subject)Mockito.mock(Subject.class);
        String packageName = "PackageName";
        int packageTypeID = 1;
        String version = "PackageVersion";
        String displayVersion = "       ";
        int architectureId = 2;
        String sampleContent = "SampleContent";
        ByteArrayInputStream packageBitStream = new ByteArrayInputStream(sampleContent.getBytes());
        EntityManager mockEntityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"PackageVersion.findByPackageVerArch"))).thenReturn((Object)mockQuery);
        List mockList = (List)Mockito.mock(List.class);
        Mockito.when((Object)mockQuery.getResultList()).thenReturn((Object)mockList);
        Mockito.when((Object)mockList.size()).thenReturn((Object)1);
        PackageVersion mockPackageVersion = (PackageVersion)Mockito.mock(PackageVersion.class);
        Mockito.when(mockList.get(Matchers.eq((int)0))).thenReturn((Object)mockPackageVersion);
        ContentManagerBean objectUnderTest = new ContentManagerBean();
        for (Field field : fields = ContentManagerBean.class.getDeclaredFields()) {
            if (!field.getName().equals("entityManager")) continue;
            field.setAccessible(true);
            field.set(objectUnderTest, mockEntityManager);
            field.setAccessible(false);
        }
        PackageVersion result = objectUnderTest.createPackageVersionWithDisplayVersion(mockSubject, packageName, packageTypeID, version, displayVersion, architectureId, (InputStream)packageBitStream);
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).size();
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).get(Matchers.eq((int)0));
        ((EntityManager)Mockito.verify((Object)mockEntityManager, (VerificationMode)Mockito.times((int)1))).createNamedQuery(Matchers.anyString());
        Assert.assertEquals((Object)mockPackageVersion, (Object)result);
    }

    @Test
    public void testCreatePackageVersionExistingPackagePickOnlyFirst() throws Exception {
        Field[] fields;
        Subject mockSubject = (Subject)Mockito.mock(Subject.class);
        String packageName = "PackageName";
        int packageTypeID = 1;
        String version = "PackageVersion";
        String displayVersion = "       ";
        int architectureId = 2;
        String sampleContent = "SampleContent";
        ByteArrayInputStream packageBitStream = new ByteArrayInputStream(sampleContent.getBytes());
        EntityManager mockEntityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"PackageVersion.findByPackageVerArch"))).thenReturn((Object)mockQuery);
        List mockList = (List)Mockito.mock(List.class);
        Mockito.when((Object)mockQuery.getResultList()).thenReturn((Object)mockList);
        Mockito.when((Object)mockList.size()).thenReturn((Object)2);
        PackageVersion mockPackageVersion = (PackageVersion)Mockito.mock(PackageVersion.class);
        Mockito.when(mockList.get(Matchers.eq((int)0))).thenReturn((Object)mockPackageVersion);
        ContentManagerBean objectUnderTest = new ContentManagerBean();
        for (Field field : fields = ContentManagerBean.class.getDeclaredFields()) {
            if (!field.getName().equals("entityManager")) continue;
            field.setAccessible(true);
            field.set(objectUnderTest, mockEntityManager);
            field.setAccessible(false);
        }
        PackageVersion result = objectUnderTest.createPackageVersionWithDisplayVersion(mockSubject, packageName, packageTypeID, version, displayVersion, architectureId, (InputStream)packageBitStream);
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).size();
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).get(Matchers.eq((int)0));
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.never())).get(Matchers.eq((int)1));
        ((EntityManager)Mockito.verify((Object)mockEntityManager, (VerificationMode)Mockito.times((int)1))).createNamedQuery(Matchers.anyString());
        Assert.assertEquals((Object)mockPackageVersion, (Object)result);
    }

    @Test
    public void testCreatePackageVersionExistingPackageUpdateDisplayVersion() throws Exception {
        Field[] fields;
        Subject mockSubject = (Subject)Mockito.mock(Subject.class);
        String packageName = "PackageName";
        int packageTypeID = 1;
        String version = "PackageVersion";
        String displayVersion = "PackageDisplayVersion";
        int architectureId = 2;
        String sampleContent = "SampleContent";
        ByteArrayInputStream packageBitStream = new ByteArrayInputStream(sampleContent.getBytes());
        EntityManager mockEntityManager = (EntityManager)Mockito.mock(EntityManager.class);
        Query mockQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)mockEntityManager.createNamedQuery((String)Matchers.eq((Object)"PackageVersion.findByPackageVerArch"))).thenReturn((Object)mockQuery);
        List mockList = (List)Mockito.mock(List.class);
        Mockito.when((Object)mockQuery.getResultList()).thenReturn((Object)mockList);
        Mockito.when((Object)mockList.size()).thenReturn((Object)1);
        final PackageVersion mockPackageVersion = (PackageVersion)Mockito.mock(PackageVersion.class);
        Mockito.when(mockList.get(Matchers.eq((int)0))).thenReturn((Object)mockPackageVersion);
        Mockito.when((Object)mockPackageVersion.getId()).thenReturn((Object)0);
        ContentManagerLocal mockContentManager = (ContentManagerLocal)Mockito.mock(ContentManagerLocal.class);
        Mockito.when((Object)mockContentManager.persistPackageVersion((PackageVersion)Matchers.any(PackageVersion.class))).thenAnswer((Answer)new Answer<PackageVersion>(){

            public PackageVersion answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                return (PackageVersion)args[0];
            }
        });
        Mockito.when((Object)mockEntityManager.find((Class)Matchers.eq(PackageVersion.class), (Object)Matchers.eq((int)0))).thenAnswer((Answer)new Answer<PackageVersion>(){

            public PackageVersion answer(InvocationOnMock invocation) throws Throwable {
                return mockPackageVersion;
            }
        });
        Package mockPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)mockPackageVersion.getGeneralPackage()).thenReturn((Object)mockPackage);
        Architecture mockArchitecture = (Architecture)Mockito.mock(Architecture.class);
        Mockito.when((Object)mockPackageVersion.getArchitecture()).thenReturn((Object)mockArchitecture);
        Mockito.when((Object)mockPackageVersion.getExtraProperties()).thenReturn(null);
        ContentManagerBean objectUnderTest = new ContentManagerBean();
        for (Field field : fields = ContentManagerBean.class.getDeclaredFields()) {
            if (field.getName().equals("entityManager")) {
                field.setAccessible(true);
                field.set(objectUnderTest, mockEntityManager);
                field.setAccessible(false);
                continue;
            }
            if (!field.getName().equals("contentManager")) continue;
            field.setAccessible(true);
            field.set(objectUnderTest, mockContentManager);
            field.setAccessible(false);
        }
        PackageVersion result = objectUnderTest.createPackageVersionWithDisplayVersion(mockSubject, packageName, packageTypeID, version, displayVersion, architectureId, (InputStream)packageBitStream);
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).size();
        ((List)Mockito.verify((Object)mockList, (VerificationMode)Mockito.times((int)1))).get(Matchers.eq((int)0));
        ((EntityManager)Mockito.verify((Object)mockEntityManager, (VerificationMode)Mockito.times((int)1))).createNamedQuery(Matchers.anyString());
        ((PackageVersion)Mockito.verify((Object)mockPackageVersion, (VerificationMode)Mockito.times((int)1))).setDisplayVersion(displayVersion);
        Assert.assertEquals((Object)mockPackageVersion, (Object)result);
    }
}

