/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.naming;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import javax.naming.event.EventContext;
import javax.naming.ldap.LdapContext;
import org.rhq.enterprise.server.naming.util.DecoratorPicker;
import org.rhq.enterprise.server.naming.util.DecoratorSetContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class DecoratorPickerTest {
    private static final InvocationHandler DUMMY_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("hashCode".equals(method.getName())) {
                return 0;
            }
            if ("equals".equals(method.getName())) {
                return false;
            }
            return null;
        }
    };
    private static final Class<?> TEST_OBJECT_CLASS1 = DecoratorPickerTest.createProxyClass(Context.class);
    private static final Class<?> TEST_OBJECT_CLASS2 = DecoratorPickerTest.createProxyClass(DirContext.class);
    private static final Class<?> TEST_OBJECT_CLASS3 = DecoratorPickerTest.createProxyClass(LdapContext.class);
    private static final Class<?> TEST_OBJECT_CLASS4 = DecoratorPickerTest.createProxyClass(LdapContext.class, EventContext.class);
    private static final Class<?> DECORATOR_CLASS1 = DecoratorPickerTest.createProxyClass(Context.class);
    private static final Class<?> DECORATOR_CLASS2 = DecoratorPickerTest.createProxyClass(EventContext.class);
    private static final Class<?> DECORATOR_CLASS3 = DecoratorPickerTest.createProxyClass(LdapContext.class);
    private static final Class<?> DECORATOR_CLASS4 = DecoratorPickerTest.createProxyClass(DirContext.class);

    public void testSimpleDecoratorIdentifiedByClass() throws Exception {
        DecoratorPicker<Object, Object> picker = DecoratorPickerTest.createTestPicker();
        Set contextDecorators = picker.getDecoratorsForClass(TEST_OBJECT_CLASS1);
        Assert.assertEquals((int)contextDecorators.size(), (int)1, (String)"Expected exactly one decorator for Context class");
        Assert.assertEquals(contextDecorators.iterator().next().getClass().getInterfaces()[0], Context.class);
    }

    public void testSuperClassDecoratorHasPrecedenceOverSubClassDecorator() throws Exception {
        DecoratorPicker<Object, Object> picker = DecoratorPickerTest.createTestPicker();
        Set contextDecorators = picker.getDecoratorsForClass(TEST_OBJECT_CLASS2);
        Assert.assertEquals((int)contextDecorators.size(), (int)1, (String)"Expected exactly one decorator for DirContext class");
        Assert.assertEquals(contextDecorators.iterator().next().getClass().getInterfaces()[0], DirContext.class);
    }

    public void testSubClassDecoratorCorrectlyIdentified() throws Exception {
        DecoratorPicker<Object, Object> picker = DecoratorPickerTest.createTestPicker();
        Set contextDecorators = picker.getDecoratorsForClass(TEST_OBJECT_CLASS3);
        Assert.assertEquals((int)contextDecorators.size(), (int)1, (String)"Expected exactly one decorator for LdapContext class");
        Assert.assertEquals(contextDecorators.iterator().next().getClass().getInterfaces()[0], LdapContext.class);
    }

    public void testMultipleDecoratorsDetectable() throws Exception {
        DecoratorPicker<Object, Object> picker = DecoratorPickerTest.createTestPicker();
        Set decorators = picker.getDecoratorsForClass(TEST_OBJECT_CLASS4);
        Assert.assertEquals((int)decorators.size(), (int)2, (String)"Exactly 2 decorators should have been found for a class implementing 2 interfaces.");
        boolean ldapContextDecoratorFound = false;
        boolean eventContextDecoratorFound = false;
        for (Object d : decorators) {
            if (LdapContext.class.isAssignableFrom(d.getClass())) {
                ldapContextDecoratorFound = true;
                continue;
            }
            if (!EventContext.class.isAssignableFrom(d.getClass())) continue;
            eventContextDecoratorFound = true;
        }
        Assert.assertTrue((ldapContextDecoratorFound && eventContextDecoratorFound ? 1 : 0) != 0, (String)"The found decorators don't implement the desired interfaces.");
    }

    public void testDecoratorsIdentifiedByMethod() throws Exception {
        DecoratorPicker<Object, Object> picker = DecoratorPickerTest.createTestPicker();
        Set decorators = picker.getDecoratorsForMethod(LdapContext.class.getMethod("getConnectControls", null));
        Assert.assertEquals((int)decorators.size(), (int)1, (String)"Expected exactly one decorator for method 'getConnectControls()' from LdapContext class");
        Assert.assertEquals(decorators.iterator().next().getClass().getInterfaces()[0], LdapContext.class);
    }

    public void testMethodFromSubclassMatchesSubclassDecorator() throws Exception {
        DecoratorPicker<Object, Object> picker = DecoratorPickerTest.createTestPicker();
        Set decorators = picker.getDecoratorsForMethod(TEST_OBJECT_CLASS3.getMethod("getSchemaClassDefinition", String.class));
        Assert.assertEquals((int)decorators.size(), (int)1, (String)"Expected exactly one decorator for method 'getSchemaClassDefinition(String)' from LdapContext class");
        Assert.assertEquals(decorators.iterator().next().getClass().getInterfaces()[0], LdapContext.class);
    }

    private static Class<?> createProxyClass(Class<?> ... ifaces) {
        return Proxy.getProxyClass(DecoratorPickerTest.class.getClassLoader(), ifaces);
    }

    private static DecoratorPicker<Object, Object> createTestPicker() {
        DecoratorPicker picker = new DecoratorPicker();
        DecoratorSetContext<Object, Object> decSet = new DecoratorSetContext<Object, Object>(){

            public Object instantiate(Class<? extends Object> decoratorClass) throws Exception {
                Constructor<? extends Object> ctor = decoratorClass.getConstructor(InvocationHandler.class);
                return ctor.newInstance(DUMMY_HANDLER);
            }

            public void init(Object decorator, Object object) throws Exception {
            }

            public Set<Class<? extends Object>> getSupportedInterfaces() {
                return new HashSet<Class<? extends Object>>(Arrays.asList(Context.class, EventContext.class, LdapContext.class, DirContext.class));
            }

            public Set<Class<? extends Object>> getDecoratorClasses() {
                return new HashSet<Class<? extends Object>>(Arrays.asList(DECORATOR_CLASS1, DECORATOR_CLASS2, DECORATOR_CLASS3, DECORATOR_CLASS4));
            }
        };
        picker.setContext((DecoratorSetContext)decSet);
        return picker;
    }
}

