/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDampeningEvent;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.enterprise.server.alert.AlertConditionLogManagerLocal;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDampeningManagerLocal;

@Stateless
public class AlertConditionLogManagerBean
implements AlertConditionLogManagerLocal {
    private final Log log = LogFactory.getLog(AlertConditionLogManagerBean.class);
    @EJB
    private AlertConditionLogManagerLocal alertConditionLogManager;
    @EJB
    private AlertConditionManagerLocal alertConditionManager;
    @EJB
    private AlertDampeningManagerLocal alertDampeningManager;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public AlertConditionLog getUnmatchedLogByAlertConditionId(int alertConditionId) {
        Query query = this.entityManager.createNamedQuery("AlertConditinLog.findUnmatchedLogByAlertConditionId");
        query.setParameter("alertConditionId", (Object)alertConditionId);
        return (AlertConditionLog)query.getSingleResult();
    }

    @Override
    public List<AlertConditionLog> getUnmatchedLogsByAlertDefinitionId(int alertDefinitionId) {
        Query unmatchedLogsQuery = this.entityManager.createNamedQuery("AlertConditinLog.findUnmatchedLogsByAlertDefinitionId");
        unmatchedLogsQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        List unmatchedConditionLogs = unmatchedLogsQuery.getResultList();
        return unmatchedConditionLogs;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateUnmatchedLogByAlertConditionId(int alertConditionId, long ctime, String value) {
        block6: {
            try {
                try {
                    AlertConditionLog alertConditionLog = this.getUnmatchedLogByAlertConditionId(alertConditionId);
                    alertConditionLog.setCtime(ctime);
                    alertConditionLog.setValue(value);
                    this.log.debug((Object)("Updating unmatched alert condition log: " + alertConditionLog));
                    this.entityManager.merge((Object)alertConditionLog);
                    this.entityManager.flush();
                }
                catch (NoResultException nre) {
                    AlertCondition condition = (AlertCondition)this.entityManager.find(AlertCondition.class, (Object)alertConditionId);
                    AlertConditionLog conditionLog = new AlertConditionLog(condition, ctime);
                    conditionLog.setValue(value);
                    this.log.debug((Object)("Inserting unmatched alert condition log: " + conditionLog));
                    this.entityManager.persist((Object)conditionLog);
                    this.entityManager.flush();
                }
                catch (NonUniqueResultException nure) {
                    this.log.debug((Object)("Found multiple unmatched results for alertConditionId of " + alertConditionId + " while performing activation.  There should only be one."));
                }
            }
            catch (Throwable t) {
                boolean found = false;
                for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
                    if (!(throwable instanceof ConstraintViolationException)) continue;
                    this.log.debug((Object)"ConstraintViolationException thrown during AlertConditionLog persistence");
                    found = true;
                    break;
                }
                if (found) break block6;
                throw new RuntimeException("Could not insert log entry for AlertCondition[id=" + alertConditionId + "]", t);
            }
        }
    }

    @Override
    public void removeUnmatchedLogByAlertConditionId(int alertConditionId) {
        try {
            AlertConditionLog alertConditionLog = this.getUnmatchedLogByAlertConditionId(alertConditionId);
            this.log.debug((Object)("Removing unmatched alert condition log: " + alertConditionLog));
            this.entityManager.remove((Object)alertConditionLog);
        }
        catch (NoResultException nre) {
        }
        catch (NonUniqueResultException nure) {
            this.log.debug((Object)("Found multiple unmatched results for alertConditionId of " + alertConditionId + " while performing deactivation.  There should only be one."));
        }
    }

    @Override
    public void checkForCompletedAlertConditionSet(int alertConditionId) {
        Integer alertDefinitionId = this.alertConditionManager.getAlertDefinitionByConditionIdInNewTransaction(alertConditionId);
        boolean conditionSetResult = this.evaluateConditionSet(alertDefinitionId);
        this.log.debug((Object)("Alert definition with conditionId=" + alertConditionId + " evaluated to " + conditionSetResult));
        AlertDampeningEvent latestEvent = this.alertDampeningManager.getLatestEventByAlertDefinitionId(alertDefinitionId);
        AlertDampeningEvent.Type type = this.getNextEventType(latestEvent, conditionSetResult);
        this.log.debug((Object)("Latest event was " + latestEvent + ", " + "next AlertDampeningEvent.Type is " + type));
        if (type != AlertDampeningEvent.Type.UNCHANGED) {
            AlertDefinition flyWeightDefinition = new AlertDefinition();
            flyWeightDefinition.setId(alertDefinitionId.intValue());
            AlertDampeningEvent alertDampeningEvent = new AlertDampeningEvent(flyWeightDefinition, type);
            this.entityManager.persist((Object)alertDampeningEvent);
            this.log.debug((Object)("Need to process AlertDampeningEvent.Type of " + type + " " + "for AlertDefinition[ id=" + alertDefinitionId + " ]"));
            this.alertDampeningManager.processEventType(alertDefinitionId, type);
        }
    }

    private AlertDampeningEvent.Type getNextEventType(AlertDampeningEvent lastEvent, boolean conditionSetResult) {
        if (conditionSetResult) {
            if (lastEvent == null || lastEvent.getEventType() == AlertDampeningEvent.Type.NEGATIVE) {
                return AlertDampeningEvent.Type.POSITIVE;
            }
            if (lastEvent.getEventType() == AlertDampeningEvent.Type.POSITIVE || lastEvent.getEventType() == AlertDampeningEvent.Type.POSITIVE_AGAIN) {
                return AlertDampeningEvent.Type.POSITIVE_AGAIN;
            }
            throw new RuntimeException("Threshold reached, but AlertDampenintEvent.Type '" + lastEvent.getEventType() + " not supported.");
        }
        if (lastEvent == null || lastEvent.getEventType() == AlertDampeningEvent.Type.NEGATIVE) {
            return AlertDampeningEvent.Type.UNCHANGED;
        }
        if (lastEvent.getEventType() == AlertDampeningEvent.Type.POSITIVE || lastEvent.getEventType() == AlertDampeningEvent.Type.POSITIVE_AGAIN) {
            return AlertDampeningEvent.Type.NEGATIVE;
        }
        throw new RuntimeException("Threshold missed, but AlertDampenintEvent.Type '" + lastEvent.getEventType() + " not supported.");
    }

    private boolean evaluateConditionSet(Integer alertDefinitionId) {
        List<AlertConditionLog> unmatchedLogs = this.getUnmatchedLogsByAlertDefinitionId(alertDefinitionId);
        BooleanExpression expression = this.alertConditionLogManager.getConditionExpression(alertDefinitionId);
        if (expression == BooleanExpression.ANY) {
            if (this.log.isDebugEnabled()) {
                int conditionSetSize = this.alertConditionLogManager.getConditionCount(alertDefinitionId);
                this.log.debug((Object)("Need only 1 of " + conditionSetSize + " conditions to be true, " + "found " + unmatchedLogs.size() + " for AlertDefinition[id=" + alertDefinitionId + "]"));
            }
            return unmatchedLogs.size() > 0;
        }
        if (expression == BooleanExpression.ALL) {
            int conditionSetSize = this.alertConditionLogManager.getConditionCount(alertDefinitionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Need all " + conditionSetSize + " conditions to be true, " + "found " + unmatchedLogs.size() + " for AlertDefinition[id=" + alertDefinitionId + "]"));
            }
            return unmatchedLogs.size() == conditionSetSize;
        }
        if (this.log.isDebugEnabled()) {
            this.log.error((Object)("AlertConditionLogManager does not support " + expression + " boolean expression yet"));
        }
        return false;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public BooleanExpression getConditionExpression(int alertDefinitionId) {
        Query query = this.entityManager.createQuery("SELECT ad.conditionExpression   FROM AlertDefinition ad  WHERE ad.id = :alertDefinitionId");
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        BooleanExpression expression = (BooleanExpression)query.getSingleResult();
        return expression;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int getConditionCount(int alertDefinitionId) {
        Query query = this.entityManager.createQuery("SELECT COUNT(ac)   FROM AlertDefinition ad   JOIN ad.conditions ac  WHERE ad.id = :alertDefinitionId");
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        long conditionCount = (Long)query.getSingleResult();
        return (int)conditionCount;
    }
}

