/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.content;

import java.util.Collection;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.content.Advisory;
import org.rhq.core.domain.content.AdvisoryBuglist;
import org.rhq.core.domain.content.AdvisoryCVE;
import org.rhq.core.domain.content.AdvisoryPackage;
import org.rhq.core.domain.content.CVE;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.AdvisoryException;
import org.rhq.enterprise.server.content.AdvisoryManagerLocal;

@Stateless
public class AdvisoryManagerBean
implements AdvisoryManagerLocal {
    private final Log log = LogFactory.getLog(this.getClass());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Advisory createAdvisory(Subject user, String advisory, String advisoryType, String synopsis) throws AdvisoryException {
        Advisory adv = new Advisory(advisory, advisoryType, synopsis);
        this.validateAdvisory(adv);
        this.entityManager.persist((Object)adv);
        return adv;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public CVE createCVE(Subject user, String cvename) throws AdvisoryException {
        this.log.debug((Object)("User [" + user + "] is creating CVE [" + cvename + "]"));
        CVE cve = new CVE(cvename);
        this.entityManager.persist((Object)cve);
        return cve;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AdvisoryCVE createAdvisoryCVE(Subject user, Advisory advisory, CVE cve) throws AdvisoryException {
        this.log.debug((Object)("User [" + user + "] is creating AdvisoryCVE [" + advisory + "]"));
        AdvisoryCVE advcve = new AdvisoryCVE(advisory, cve);
        this.entityManager.persist((Object)advcve);
        return advcve;
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AdvisoryBuglist createAdvisoryBuglist(Subject user, Advisory advisory, String buginfo) throws AdvisoryException {
        this.log.debug((Object)("User [" + user + "] is creating AdvisoryCVE [" + advisory + "]"));
        AdvisoryBuglist advbug = new AdvisoryBuglist(advisory, buginfo);
        this.entityManager.persist((Object)advbug);
        return advbug;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public AdvisoryPackage createAdvisoryPackage(Subject user, Advisory advisory, PackageVersion pkg) throws AdvisoryException {
        this.log.debug((Object)("User [" + user + "] is creating AdvisoryPackage [" + advisory + "]"));
        AdvisoryPackage advpkg = new AdvisoryPackage(advisory, pkg);
        this.entityManager.persist((Object)advpkg);
        return advpkg;
    }

    @Override
    public void deleteCVE(Subject user, int cveId) {
        this.log.debug((Object)("User [" + user + "] is deleting CVE [" + cveId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        int success = this.entityManager.createNamedQuery("CVE.deleteByCVEId").setParameter("cveId", (Object)cveId).executeUpdate();
        if (success == 1) {
            this.log.debug((Object)("User [" + user + "] deleted CVE [" + cveId + "]"));
        } else {
            this.log.debug((Object)("CVE ID [" + cveId + "] doesn't exist - nothing to delete"));
        }
    }

    @Override
    public void deleteAdvisoryCVE(Subject user, int advId) {
        this.log.debug((Object)("User [" + user + "] is deleting CVE [" + advId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        int success = this.entityManager.createNamedQuery("AdvisoryCVE.deleteByAveId").setParameter("advId", (Object)advId).executeUpdate();
        if (success == 1) {
            this.log.debug((Object)("User [" + user + "] deleted CVEs for " + advId));
        } else {
            this.log.debug((Object)("Advisory ID [" + advId + "] CVE deletion unsuccessful"));
        }
    }

    @Override
    public void deleteAdvisoryByAdvId(Subject user, int advId) {
        this.log.debug((Object)("User [" + user + "] is deleting Advisory [" + advId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        int success = this.entityManager.createNamedQuery("Advisory.deleteByAdvId").setParameter("advid", (Object)advId).executeUpdate();
        if (success == 1) {
            this.log.debug((Object)("User [" + user + "] deleted Advisory for " + advId));
        } else {
            this.log.debug((Object)("Advisory ID [" + advId + "] deletion unsuccessful"));
        }
    }

    @Override
    public void deleteAdvisoryPackage(Subject user, int advId) {
        this.log.debug((Object)("User [" + user + "] is deleting packages for advisory [" + advId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        int success = this.entityManager.createNamedQuery("AdvisoryPackage.deletePackagesByAdvId").setParameter("advId", (Object)advId).executeUpdate();
        if (success == 1) {
            this.log.debug((Object)("User [" + user + "] deleted AdvisoryPackage for [" + advId + "]"));
        } else {
            this.log.debug((Object)("Advisory ID [" + advId + "] doesn't exist - nothing to delete"));
        }
    }

    @Override
    public void deleteAdvisoryBugList(Subject user, int advId) {
        this.log.debug((Object)("User [" + user + "] is deleting Buglist for Advisory [" + advId + "]"));
        this.entityManager.flush();
        this.entityManager.clear();
        int success = this.entityManager.createNamedQuery("AdvisoryBuglist.deleteByAdvId").setParameter("advId", (Object)advId).executeUpdate();
        if (success == 1) {
            this.log.debug((Object)("User [" + user + "] deleted buglist for Advisory [" + advId + "]"));
        } else {
            this.log.debug((Object)("Advisory ID [" + advId + "] doesn't exist - nothing to delete"));
        }
    }

    @Override
    public Advisory getAdvisoryByName(String advlabel) {
        Query query = this.entityManager.createNamedQuery("Advisory.findByAdv");
        query.setParameter("advisory", (Object)advlabel);
        List results = query.getResultList();
        if (results.size() > 0) {
            return (Advisory)results.get(0);
        }
        return null;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<AdvisoryPackage> findPackageByAdvisory(Subject subject, int advId, PageControl pc) {
        Query query = this.entityManager.createNamedQuery("AdvisoryPackage.findPackagesByAdvId");
        query.setParameter("advId", (Object)advId);
        List results = query.getResultList();
        long count = this.getPackageCountFromAdv(subject, advId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @Override
    public AdvisoryPackage findAdvisoryPackage(Subject subject, int advId, int pkgVerId) {
        Query query = this.entityManager.createNamedQuery("AdvisoryPackage.findAdvisoryPackage");
        this.log.error((Object)("Advisory ID: " + advId + " PackageVerId: " + pkgVerId));
        query.setParameter("advId", (Object)advId);
        query.setParameter("pkgVerId", (Object)pkgVerId);
        try {
            AdvisoryPackage result = (AdvisoryPackage)query.getSingleResult();
            return result;
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PackageVersion findPackageVersionByPkgId(Subject subject, String rpmName, PageControl pc) {
        Query query = this.entityManager.createNamedQuery("PackageVersion.findPackageVersionByFilename");
        query.setParameter("rpmName", (Object)rpmName);
        PackageVersion results = (PackageVersion)query.getSingleResult();
        if (results != null) {
            return results;
        }
        return null;
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getPackageCountFromAdv(Subject subject, int advId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AdvisoryPackage.findPackagesByAdvId");
        countQuery.setParameter("advId", (Object)advId);
        return (Long)countQuery.getSingleResult();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<AdvisoryCVE> getAdvisoryCVEByAdvId(Subject subject, int advId, PageControl pc) {
        this.entityManager.flush();
        Query query = this.entityManager.createNamedQuery("AdvisoryCVE.findCveByAveId");
        query.setParameter("advId", (Object)advId);
        List results = query.getResultList();
        long count = this.getCVECountFromAdv(subject, advId);
        return new PageList((Collection)results, (int)count, pc);
    }

    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public long getCVECountFromAdv(Subject subject, int advId) {
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AdvisoryCVE.findCveByAveId");
        countQuery.setParameter("advId", (Object)advId);
        return (Long)countQuery.getSingleResult();
    }

    @Override
    public List<AdvisoryBuglist> getAdvisoryBuglistByAdvId(Subject subject, int advId) {
        Query query = this.entityManager.createNamedQuery("AdvisoryBuglist.findBugsByAveId");
        query.setParameter("advId", (Object)advId);
        List results = query.getResultList();
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    @Override
    public AdvisoryBuglist getAdvisoryBuglist(Subject subject, int advId, String buginfo) {
        Query query = this.entityManager.createNamedQuery("AdvisoryBuglist.findAdvBuginfo");
        query.setParameter("advId", (Object)advId);
        query.setParameter("buginfo", (Object)buginfo);
        try {
            AdvisoryBuglist result = (AdvisoryBuglist)query.getSingleResult();
            return result;
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    private void validateAdvisory(Advisory adv) throws AdvisoryException {
        if (adv.getAdvisory() == null || adv.getAdvisory().trim().equals("")) {
            throw new AdvisoryException("A valid Advisory tree is required");
        }
        this.log.debug((Object)("Advisory validating done " + adv));
    }
}

