/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.plugin;

import java.io.File;
import java.net.URL;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.util.StringPropertyReplacer;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.enterprise.server.core.plugin.AgentPluginScanner;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.core.plugin.ServerPluginScanner;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;

public class PluginDeploymentScanner
implements PluginDeploymentScannerMBean {
    private Log log = LogFactory.getLog(PluginDeploymentScanner.class);
    private long scanPeriod = 300000L;
    private File userPluginDir = null;
    private AgentPluginScanner agentPluginScanner = new AgentPluginScanner();
    private ServerPluginScanner serverPluginScanner = new ServerPluginScanner();

    @Override
    public String getScanPeriod() {
        return Long.toString(this.scanPeriod);
    }

    @Override
    public void setScanPeriod(String ms) {
        this.scanPeriod = ms != null ? Long.parseLong(StringPropertyReplacer.replaceProperties((String)ms)) : 300000L;
    }

    @Override
    public String getUserPluginDir() {
        if (this.userPluginDir == null) {
            return null;
        }
        return this.userPluginDir.getAbsolutePath();
    }

    @Override
    public void setUserPluginDir(String dir) {
        if (dir == null) {
            return;
        }
        this.userPluginDir = new File(StringPropertyReplacer.replaceProperties((String)dir));
    }

    @Override
    public String getServerPluginDir() {
        File dir = this.serverPluginScanner.getServerPluginDir();
        if (dir == null) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    @Override
    public void setServerPluginDir(String dir) {
        if (dir == null) {
            return;
        }
        this.serverPluginScanner.setServerPluginDir(new File(StringPropertyReplacer.replaceProperties((String)dir)));
    }

    @Override
    public String getAgentPluginDir() {
        File dir = this.agentPluginScanner.getAgentPluginDeployer().getPluginDir();
        if (dir == null) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    @Override
    public void setAgentPluginDir(String dir) {
        if (dir == null) {
            return;
        }
        this.agentPluginScanner.getAgentPluginDeployer().setPluginDir(new File(StringPropertyReplacer.replaceProperties((String)dir)));
    }

    @Override
    public PluginMetadataManager getPluginMetadataManager() {
        return this.agentPluginScanner.getAgentPluginDeployer().getPluginMetadataManager();
    }

    private File getUserPluginDirAsFile() {
        return this.userPluginDir;
    }

    private File getAgentPluginDirAsFile() {
        return this.agentPluginScanner.getAgentPluginDeployer().getPluginDir();
    }

    private File getServerPluginDirAsFile() {
        return this.serverPluginScanner.getServerPluginDir();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
        this.agentPluginScanner.getAgentPluginDeployer().stop();
    }

    @Override
    public void startDeployment() {
        block8: {
            String upd = this.getUserPluginDir();
            String apd = this.getAgentPluginDir();
            String spd = this.getServerPluginDir();
            if (upd == null || apd == null || spd == null) {
                File homeDir = LookupUtil.getCoreServer().getInstallDir();
                File earDir = LookupUtil.getCoreServer().getEarDeploymentDir();
                if (upd == null) {
                    upd = new File(homeDir, "plugins").getAbsolutePath();
                    this.setUserPluginDir(upd);
                }
                if (apd == null) {
                    apd = new File(earDir, "rhq-downloads/rhq-plugins").getAbsolutePath();
                    this.setAgentPluginDir(apd);
                }
                if (spd == null) {
                    spd = new File(earDir, "rhq-serverplugins").getAbsolutePath();
                    this.setServerPluginDir(spd);
                }
            }
            this.log.info((Object)("user plugin dir=" + upd));
            this.log.info((Object)("agent plugin dir=" + apd));
            this.log.info((Object)("server plugin dir=" + spd));
            try {
                this.agentPluginScanner.fixMissingAgentPluginContent();
                this.agentPluginScanner.getAgentPluginDeployer().start();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot start plugin deployment scanner properly", e);
            }
            this.agentPluginScanner.getAgentPluginDeployer().startDeployment();
            try {
                this.scanAndRegister();
            }
            catch (Throwable t) {
                this.log.error((Object)("Scan failed. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug((Object)"Scan failure stack trace follows:", t);
            }
        }
    }

    @Override
    public synchronized void scan() throws Exception {
        this.scanUserDirectory();
        this.agentPluginScanner.agentPluginScan();
        this.serverPluginScanner.serverPluginScan();
    }

    @Override
    public synchronized void scanAndRegister() throws Exception {
        this.scan();
        this.agentPluginScanner.registerAgentPlugins();
        this.serverPluginScanner.registerServerPlugins();
    }

    private void scanUserDirectory() {
        File userDir = this.getUserPluginDirAsFile();
        if (userDir == null || !userDir.isDirectory()) {
            return;
        }
        File[] listFiles = userDir.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return;
        }
        for (File file : listFiles) {
            File destinationDirectory;
            boolean isJarLess = file.getName().endsWith("-rhq-plugin.xml");
            if (!file.getName().endsWith(".jar") && !isJarLess) continue;
            try {
                if (!isJarLess && null == AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL())) {
                    throw new NullPointerException("no xml descriptor found in jar");
                }
                destinationDirectory = this.getAgentPluginDirAsFile();
            }
            catch (Exception e) {
                try {
                    this.log.debug((Object)("[" + file.getAbsolutePath() + "] is not an agent plugin jar (Cause: " + ThrowableUtil.getAllMessages((Throwable)e) + "). Will see if its a server plugin jar"));
                    if (null == ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)file.toURI().toURL())) {
                        throw new NullPointerException("no xml descriptor found in jar");
                    }
                    destinationDirectory = this.getServerPluginDirAsFile();
                }
                catch (Exception e1) {
                    File fixmeFile = new File(file.getAbsolutePath() + ".fixme");
                    boolean renamed = file.renameTo(fixmeFile);
                    this.log.warn((Object)("Does not look like [" + (renamed ? fixmeFile : file).getAbsolutePath() + "] is a plugin jar -(Cause: " + ThrowableUtil.getAllMessages((Throwable)e1) + "). It will be ignored. Please fix that file or remove it."));
                    continue;
                }
            }
            try {
                boolean deleted;
                String fileMd5 = MessageDigestGenerator.getDigestString((File)file);
                File realPluginFile = new File(destinationDirectory, file.getName());
                String realPluginFileMd5 = null;
                if (realPluginFile.exists()) {
                    realPluginFileMd5 = MessageDigestGenerator.getDigestString((File)realPluginFile);
                }
                if (!fileMd5.equals(realPluginFileMd5)) {
                    if (file.lastModified() > realPluginFile.lastModified()) {
                        FileUtil.copyFile((File)file, (File)realPluginFile);
                        boolean succeeded = realPluginFile.setLastModified(file.lastModified());
                        if (!succeeded) {
                            this.log.error((Object)("Failed to set mtime to [" + new Date(file.lastModified()) + "] on file [" + realPluginFile + "]."));
                        }
                        String tmp = !isJarLess ? "jar" : "descriptor";
                        this.log.info((Object)("Found plugin " + tmp + " at [" + file.getAbsolutePath() + "] and placed it at [" + realPluginFile.getAbsolutePath() + "]"));
                    }
                } else {
                    this.log.info((Object)("Found a plugin at [" + file.getAbsolutePath() + "], which is the same as the existing one. It will be ignored"));
                }
                if (deleted = file.delete()) continue;
                this.log.info((Object)("The plugin jar found at[" + file.getAbsolutePath() + "] has been processed and can be deleted. It failed to get deleted, " + "so it may get processed again. You should delete it manually now."));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to process plugin [" + file.getAbsolutePath() + "], ignoring it"), (Throwable)e);
            }
        }
    }
}

