/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.rhq.common.drift.ChangeSetReaderImpl;
import org.rhq.common.drift.FileEntry;
import org.rhq.common.drift.Headers;
import org.rhq.core.clientapi.agent.drift.DriftAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.DriftChangeSetCriteria;
import org.rhq.core.domain.criteria.DriftCriteria;
import org.rhq.core.domain.criteria.JPADriftChangeSetCriteria;
import org.rhq.core.domain.criteria.JPADriftCriteria;
import org.rhq.core.domain.drift.Drift;
import org.rhq.core.domain.drift.DriftChangeSet;
import org.rhq.core.domain.drift.DriftChangeSetCategory;
import org.rhq.core.domain.drift.DriftComposite;
import org.rhq.core.domain.drift.DriftConfigurationDefinition;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftFile;
import org.rhq.core.domain.drift.DriftFileStatus;
import org.rhq.core.domain.drift.JPADrift;
import org.rhq.core.domain.drift.JPADriftChangeSet;
import org.rhq.core.domain.drift.JPADriftFile;
import org.rhq.core.domain.drift.JPADriftFileBits;
import org.rhq.core.domain.drift.JPADriftSet;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.StopWatch;
import org.rhq.core.util.ZipUtil;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.drift.DriftUtil;
import org.rhq.enterprise.server.drift.JPADriftServerLocal;
import org.rhq.enterprise.server.plugin.pc.drift.DriftChangeSetSummary;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class JPADriftServerBean
implements JPADriftServerLocal {
    private final Log log = LogFactory.getLog(this.getClass());
    @EJB
    AgentManagerLocal agentManager;
    @EJB
    JPADriftServerLocal JPADriftServer;
    @EJB
    SubjectManagerLocal subjectManager;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int purgeOrphanedDriftFiles(Subject subject, long purgeMillis) {
        Query q = this.entityManager.createNativeQuery("DELETE FROM RHQ_DRIFT_FILE  WHERE (HASH_ID NOT IN (SELECT OLD_DRIFT_FILE FROM RHQ_DRIFT))    AND (HASH_ID NOT IN (SELECT NEW_DRIFT_FILE FROM RHQ_DRIFT))    AND CTIME < ?");
        q.setParameter(1, (Object)purgeMillis);
        int count = q.executeUpdate();
        this.log.debug((Object)("purged [" + count + "] drift files that were orphaned (that is, no longer referenced by drift)"));
        return count;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeByDriftDefinitionName(Subject subject, int resourceId, String driftDefName) throws Exception {
        StopWatch timer = new StopWatch();
        Query q = this.entityManager.createNamedQuery("JPADrift.deleteByDriftDefResource");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("driftDefinitionName", (Object)driftDefName);
        int driftsDeleted = q.executeUpdate();
        q = this.entityManager.createNamedQuery("JPADriftChangeSet.deleteByDriftDefResource");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("driftDefinitionName", (Object)driftDefName);
        int changeSetsDeleted = q.executeUpdate();
        this.log.info((Object)("Purged [" + driftsDeleted + "] drift items and [" + changeSetsDeleted + "] changesets associated with drift def [" + driftDefName + "] from resource [" + resourceId + "]. Elapsed time=[" + timer.getElapsed() + "]ms"));
    }

    @Override
    public PageList<JPADriftChangeSet> findDriftChangeSetsByCriteria(Subject subject, DriftChangeSetCriteria criteria) {
        JPADriftChangeSetCriteria jpaCriteria;
        JPADriftChangeSetCriteria jPADriftChangeSetCriteria = jpaCriteria = criteria instanceof JPADriftChangeSetCriteria ? (JPADriftChangeSetCriteria)criteria : new JPADriftChangeSetCriteria(criteria);
        if (criteria.getFilterCategory() != null && criteria.getFilterCategory() == DriftChangeSetCategory.COVERAGE) {
            if (jpaCriteria.isFetchDrifts()) {
                jpaCriteria.fetchInitialDriftSet(true);
                jpaCriteria.fetchDrifts(false);
            }
            jpaCriteria.addFilterVersion("0");
        } else {
            jpaCriteria.fetchInitialDriftSet(false);
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)jpaCriteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)jpaCriteria, generator, this.entityManager);
        PageList result = queryRunner.execute();
        return result;
    }

    @Override
    public PageList<DriftComposite> findDriftCompositesByCriteria(Subject subject, DriftCriteria criteria) {
        JPADriftCriteria jpaCriteria = criteria instanceof JPADriftCriteria ? (JPADriftCriteria)criteria : new JPADriftCriteria(criteria);
        jpaCriteria.fetchChangeSet(true);
        PageList<JPADrift> drifts = this.findDriftsByCriteria(subject, (DriftCriteria)jpaCriteria);
        PageList result = new PageList();
        for (JPADrift drift : drifts) {
            JPADriftChangeSet changeSet = drift.getChangeSet();
            DriftDefinition driftDef = changeSet.getDriftDefinition();
            result.add((Object)new DriftComposite((Drift)drift, changeSet.getResource(), driftDef.getName()));
        }
        return result;
    }

    @Override
    public PageList<JPADrift> findDriftsByCriteria(Subject subject, DriftCriteria criteria) {
        JPADriftCriteria jpaCriteria = criteria instanceof JPADriftCriteria ? (JPADriftCriteria)criteria : new JPADriftCriteria(criteria);
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)jpaCriteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)jpaCriteria, generator, this.entityManager);
        PageList result = queryRunner.execute();
        return result;
    }

    @Override
    public String persistChangeSet(Subject subject, DriftChangeSet<?> changeSet) {
        JPADriftChangeSet jpaChangeSet;
        if (this.isTemplateChangeSet(changeSet)) {
            jpaChangeSet = new JPADriftChangeSet(null, changeSet.getVersion(), changeSet.getCategory(), null);
            jpaChangeSet.setDriftHandlingMode(changeSet.getDriftHandlingMode());
        } else {
            Resource resource = this.getResource(changeSet.getResourceId());
            DriftDefinition driftDef = null;
            for (DriftDefinition def : resource.getDriftDefinitions()) {
                if (def.getId() != changeSet.getDriftDefinitionId()) continue;
                driftDef = def;
                break;
            }
            jpaChangeSet = new JPADriftChangeSet(resource, changeSet.getVersion(), changeSet.getCategory(), driftDef);
        }
        JPADriftSet driftSet = new JPADriftSet();
        for (Drift drift : changeSet.getDrifts()) {
            JPADrift jpaDrift = new JPADrift(jpaChangeSet, drift.getPath(), drift.getCategory(), this.toJPADriftFile(drift.getOldDriftFile()), this.toJPADriftFile(drift.getNewDriftFile()));
            driftSet.addDrift(jpaDrift);
        }
        this.entityManager.persist((Object)jpaChangeSet);
        this.entityManager.persist((Object)driftSet);
        jpaChangeSet.setInitialDriftSet(driftSet);
        return jpaChangeSet.getId();
    }

    private boolean isTemplateChangeSet(DriftChangeSet<?> changeSet) {
        return changeSet.getResourceId() == 0 && changeSet.getDriftDefinitionId() == 0;
    }

    @Override
    public String copyChangeSet(Subject subject, String changeSetId, int driftDefId, int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        DriftDefinition driftDef = (DriftDefinition)this.entityManager.find(DriftDefinition.class, (Object)driftDefId);
        JPADriftChangeSet srcChangeSet = (JPADriftChangeSet)this.entityManager.find(JPADriftChangeSet.class, (Object)Integer.parseInt(changeSetId));
        JPADriftChangeSet destChangeSet = new JPADriftChangeSet(resource, 0, DriftChangeSetCategory.COVERAGE, driftDef);
        destChangeSet.setDriftHandlingMode(DriftConfigurationDefinition.DriftHandlingMode.normal);
        destChangeSet.setInitialDriftSet(srcChangeSet.getInitialDriftSet());
        this.entityManager.persist((Object)destChangeSet);
        return destChangeSet.getId();
    }

    private JPADriftFile toJPADriftFile(DriftFile driftFile) {
        if (driftFile == null) {
            return null;
        }
        JPADriftFile jpaFile = new JPADriftFile(driftFile.getHashId());
        jpaFile.setDataSize(driftFile.getDataSize());
        jpaFile.setStatus(driftFile.getStatus());
        return jpaFile;
    }

    @Override
    public JPADriftFile getDriftFile(Subject subject, String sha256) {
        JPADriftFile result = (JPADriftFile)this.entityManager.find(JPADriftFile.class, (Object)sha256);
        return result;
    }

    @Override
    public JPADriftFile persistDriftFile(JPADriftFile driftFile) {
        this.entityManager.persist((Object)driftFile);
        return driftFile;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persistDriftFileData(JPADriftFile driftFile, InputStream data, long numBytes) throws Exception {
        JPADriftFileBits df = (JPADriftFileBits)this.entityManager.find(JPADriftFileBits.class, (Object)driftFile.getHashId());
        if (null == df) {
            throw new IllegalArgumentException("JPADriftFile not found [" + driftFile.getHashId() + "]");
        }
        Session session = (Session)this.entityManager.getDelegate();
        df.setDataSize(Long.valueOf(numBytes));
        df.setData(session.getLobHelper().createBlob((InputStream)new BufferedInputStream(data), numBytes));
        df.setStatus(DriftFileStatus.LOADED);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DriftChangeSetSummary storeChangeSet(Subject subject, int resourceId, File changeSetZip) throws Exception {
        ArrayList<JPADriftFile> driftFilesToRequest = new ArrayList<JPADriftFile>();
        Headers[] headers = new Headers[1];
        DriftChangeSetSummary result = this.JPADriftServer.storeChangeSetInNewTransaction(subject, resourceId, changeSetZip, driftFilesToRequest, headers);
        if (null == result) {
            return result;
        }
        this.JPADriftServer.ackChangeSetInNewTransaction(subject, resourceId, headers[0], driftFilesToRequest);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public DriftChangeSetSummary storeChangeSetInNewTransaction(Subject subject, final int resourceId, File changeSetZip, final List<JPADriftFile> driftFilesToRequest, final Headers[] headers) throws Exception {
        final Resource resource = this.getResource(resourceId);
        final DriftChangeSetSummary summary = new DriftChangeSetSummary();
        final boolean storeBinaryContent = this.isBinaryContentStorageEnabled();
        try {
            ZipUtil.walkZipFile((File)changeSetZip, (ZipUtil.ZipEntryVisitor)new ChangeSetFileVisitor(){

                public boolean visit(ZipEntry zipEntry, ZipInputStream stream) throws Exception {
                    JPADriftChangeSet driftChangeSet = null;
                    ChangeSetReaderImpl reader = new ChangeSetReaderImpl((Reader)new BufferedReader(new InputStreamReader(stream)), false);
                    DriftDefinition driftDef = JPADriftServerBean.this.findDriftDefinition(resource, reader.getHeaders());
                    if (driftDef == null) {
                        JPADriftServerBean.this.log.error((Object)("Unable to locate DriftDefinition for Resource [" + resource + "]. Change set cannot be saved."));
                        return false;
                    }
                    int version = reader.getHeaders().getVersion();
                    DriftChangeSetCategory category = reader.getHeaders().getType();
                    driftChangeSet = new JPADriftChangeSet(resource, version, category, driftDef);
                    JPADriftServerBean.this.entityManager.persist((Object)driftChangeSet);
                    summary.setCategory(category);
                    summary.setResourceId(resourceId);
                    summary.setDriftDefinitionName(reader.getHeaders().getDriftDefinitionName());
                    summary.setDriftHandlingMode(driftDef.getDriftHandlingMode());
                    summary.setCreatedTime(driftChangeSet.getCtime());
                    if (version > 0) {
                        for (FileEntry entry : reader) {
                            boolean addToList = storeBinaryContent || !DriftUtil.isBinaryFile(entry.getFile());
                            JPADriftFile oldDriftFile = JPADriftServerBean.this.getDriftFile(entry.getOldSHA(), driftFilesToRequest, addToList);
                            JPADriftFile newDriftFile = JPADriftServerBean.this.getDriftFile(entry.getNewSHA(), driftFilesToRequest, addToList);
                            String path = FileUtil.useForwardSlash((String)entry.getFile());
                            JPADrift drift = new JPADrift(driftChangeSet, path, entry.getType(), oldDriftFile, newDriftFile);
                            JPADriftServerBean.this.entityManager.persist((Object)drift);
                            if (category != DriftChangeSetCategory.DRIFT) continue;
                            summary.addDriftPathname(path);
                        }
                    } else {
                        summary.setInitialChangeSet(true);
                        JPADriftSet driftSet = new JPADriftSet();
                        for (FileEntry entry : reader) {
                            boolean addToList = storeBinaryContent || !DriftUtil.isBinaryFile(entry.getFile());
                            JPADriftFile newDriftFile = JPADriftServerBean.this.getDriftFile(entry.getNewSHA(), driftFilesToRequest, addToList);
                            String path = FileUtil.useForwardSlash((String)entry.getFile());
                            driftSet.addDrift(new JPADrift(driftChangeSet, path, entry.getType(), null, newDriftFile));
                        }
                        JPADriftServerBean.this.entityManager.persist((Object)driftSet);
                        driftChangeSet.setInitialDriftSet(driftSet);
                        JPADriftServerBean.this.entityManager.merge((Object)driftChangeSet);
                    }
                    headers[0] = reader.getHeaders();
                    return true;
                }
            });
            DriftChangeSetSummary driftChangeSetSummary = summary;
            return driftChangeSetSummary;
        }
        catch (Exception e) {
            String msg = "Failed to store drift changeset for ";
            msg = null != resource ? msg + resource : msg + "resourceId [" + resourceId + "]";
            this.log.error((Object)msg, (Throwable)e);
            DriftChangeSetSummary driftChangeSetSummary = null;
            return driftChangeSetSummary;
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void ackChangeSetInNewTransaction(Subject subject, int resourceId, Headers headers, List<JPADriftFile> driftFilesToRequest) throws Exception {
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
            DriftAgentService service = agentClient.getDriftAgentService();
            service.ackChangeSet(resourceId, headers.getDriftDefinitionName());
            if (!driftFilesToRequest.isEmpty()) {
                try {
                    service.requestDriftFiles(resourceId, headers, driftFilesToRequest);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Unable to inform agent of drift file request  [" + driftFilesToRequest + "]"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to acknowledge changeSet storage with agent for " + headers), (Throwable)e);
        }
    }

    private boolean isBinaryContentStorageEnabled() {
        String binaryContent = System.getProperty("rhq.server.drift.store-binary-content", "false");
        return binaryContent.equals("true");
    }

    private JPADriftFile getDriftFile(String sha256, List<JPADriftFile> emptyDriftFiles, boolean addToList) {
        JPADriftFile result = null;
        if (null == sha256 || "0".equals(sha256)) {
            return result;
        }
        result = (JPADriftFile)this.entityManager.find(JPADriftFile.class, (Object)sha256);
        if (null == result) {
            JPADriftFile driftFile = new JPADriftFile(sha256);
            if (addToList) {
                driftFile.setStatus(DriftFileStatus.REQUESTED);
            }
            result = this.persistDriftFile(driftFile);
            if (addToList) {
                emptyDriftFiles.add(result);
            }
        }
        return result;
    }

    private DriftDefinition findDriftDefinition(Resource resource, Headers headers) {
        for (DriftDefinition driftDef : resource.getDriftDefinitions()) {
            if (!driftDef.getName().equals(headers.getDriftDefinitionName())) continue;
            return driftDef;
        }
        return null;
    }

    @Override
    public void storeFiles(Subject subject, File filesZip) throws Exception {
        String zipFileName = filesZip.getName();
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, zipFileName.substring(0, zipFileName.indexOf(".")));
        dir.mkdir();
        ZipUtil.unzipFile((File)filesZip, (File)dir);
        for (File file : dir.listFiles()) {
            JPADriftFile driftFile = new JPADriftFile(file.getName());
            try {
                this.JPADriftServer.persistDriftFileData(driftFile, new FileInputStream(file), file.length());
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).info((Object)"Skipping bad drift file", (Throwable)e);
            }
        }
        for (File file : dir.listFiles()) {
            file.delete();
        }
        boolean deleted = dir.delete();
        if (!deleted) {
            LogFactory.getLog(this.getClass()).info((Object)("Unable to delete " + dir.getAbsolutePath() + ". This directory and " + "its contents are no longer needed. It can be deleted."));
        }
    }

    @Override
    public String getDriftFileBits(String hash) {
        return new String(this.getDriftFileAsByteArray(hash), Charset.defaultCharset());
    }

    @Override
    public byte[] getDriftFileAsByteArray(String hash) {
        try {
            JPADriftFileBits content = (JPADriftFileBits)this.entityManager.createNamedQuery("JPADriftFileBits.findById").setParameter("hashId", (Object)hash).getSingleResult();
            if (content.getDataSize() == null || content.getDataSize() < 1L) {
                return new byte[0];
            }
            return StreamUtil.slurp((InputStream)content.getBlob().getBinaryStream());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Resource getResource(int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (null == resource) {
            throw new IllegalArgumentException("Resource not found [" + resourceId + "]");
        }
        return resource;
    }

    private abstract class ChangeSetFileVisitor
    implements ZipUtil.ZipEntryVisitor {
        private ChangeSetFileVisitor() {
        }
    }
}

