/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.rhq.core.clientapi.util.TimeUtil;
import org.rhq.core.util.StopWatch;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementCompressionManagerLocal;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.measurement.util.MeasurementDataManagerUtility;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.TimingVoodoo;

@Stateless
@Deprecated
public class MeasurementCompressionManagerBean
implements MeasurementCompressionManagerLocal {
    private final Log log = LogFactory.getLog(MeasurementCompressionManagerBean.class);
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long SIX_HOUR = 21600000L;
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private MeasurementCompressionManagerLocal compressionManager;
    private long purge1h;
    private long purge6h;
    private long purge1d;

    private void loadPurgeDefaults() {
        this.log.debug((Object)"Loading default purge intervals");
        Properties conf = this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord());
        try {
            this.purge1h = Long.parseLong(conf.getProperty(RHQConstants.DataPurge1Hour));
            this.purge6h = Long.parseLong(conf.getProperty(RHQConstants.DataPurge6Hour));
            this.purge1d = Long.parseLong(conf.getProperty(RHQConstants.DataPurge1Day));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid purge interval: " + e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void compressPurgeAndTruncate() throws SQLException {
        String[] rawTables;
        this.loadPurgeDefaults();
        long now = TimingVoodoo.roundDownTime(System.currentTimeMillis(), 3600000L);
        long hourAgo = TimingVoodoo.roundDownTime(now - 3600000L, 3600000L);
        String deadTable = MeasurementDataManagerUtility.getDeadTable(hourAgo);
        int deadTableIndex = MeasurementDataManagerUtility.getTableNameIndex(deadTable);
        for (String rawTable : rawTables = MeasurementDataManagerUtility.getAllRawTables(deadTableIndex + 1)) {
            if (rawTable.equals(deadTable)) continue;
            this.compressData(rawTable, "RHQ_MEASUREMENT_DATA_NUM_1H", 3600000L, now);
        }
        this.compressionManager.truncateMeasurements(deadTable);
        long last = this.compressData("RHQ_MEASUREMENT_DATA_NUM_1H", "RHQ_MEASUREMENT_DATA_NUM_6H", 21600000L, now);
        this.purgeMeasurements("RHQ_MEASUREMENT_DATA_NUM_1H", Math.min(now - this.purge1h, last), 3600000L);
        last = this.compressData("RHQ_MEASUREMENT_DATA_NUM_6H", "RHQ_MEASUREMENT_DATA_NUM_1D", 86400000L, now);
        this.purgeMeasurements("RHQ_MEASUREMENT_DATA_NUM_6H", Math.min(now - this.purge6h, last), 21600000L);
        this.purgeMeasurements("RHQ_MEASUREMENT_DATA_NUM_1D", now - this.purge1d, 86400000L);
    }

    private long compressData(String fromTable, String toTable, long interval, long now) throws SQLException {
        long fromTableMax;
        long start = this.getMaxTimestamp(toTable);
        if (start == 0L) {
            start = this.getMinTimestamp(fromTable);
            if (start == 0L) {
                return 0L;
            }
        } else {
            start += interval;
        }
        long rawTimeStart = TimingVoodoo.roundDownTime(MeasurementDataManagerUtility.getRawTimePeriodStart(now), 3600000L);
        long begin = TimingVoodoo.roundDownTime(start, interval);
        if (begin < rawTimeStart) {
            begin = rawTimeStart;
        }
        if ((fromTableMax = this.getMaxTimestamp(fromTable)) < begin) {
            return begin;
        }
        return this.compressData(fromTable, toTable, begin, now, interval);
    }

    private long compressData(String fromTable, String toTable, long begin, long now, long interval) {
        this.log.info((Object)("Begin compression from [" + fromTable + "] to [" + toTable + "]"));
        int totalRows = 0;
        while (begin < now) {
            long end = begin + interval;
            try {
                totalRows += this.compressionManager.compressDataInterval(fromTable, toTable, begin, end);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)("Unable to compress data from [" + fromTable + "] to [" + toTable + "] at " + TimeUtil.toString((long)begin)), t);
                }
                this.log.error((Object)("Unable to compress data from [" + fromTable + "] to [" + toTable + "] at " + TimeUtil.toString((long)begin) + ": " + ThrowableUtil.getAllMessages((Throwable)t)));
            }
            begin = end;
        }
        this.log.info((Object)("Finished compression from [" + fromTable + "] to [" + toTable + "], [" + totalRows + "] compressed rows"));
        return begin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionTimeout(value=3600L)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int compressDataInterval(String fromTable, String toTable, long begin, long end) throws SQLException {
        Connection conn = null;
        PreparedStatement insStmt = null;
        this.log.info((Object)("Begin compressing data from table [" + fromTable + "] to table [" + toTable + "] between [" + TimeUtil.toString((long)begin) + "] and [" + TimeUtil.toString((long)end) + "]"));
        int rows = 0;
        StopWatch watch = new StopWatch();
        try {
            conn = this.dataSource.getConnection();
            String minMax = MeasurementDataManagerUtility.isRawTable(fromTable) ? "AVG(value), MIN(value), MAX(value) " : "AVG(value), MIN(minvalue), MAX(maxvalue) ";
            insStmt = conn.prepareStatement("INSERT INTO " + toTable + " (SELECT ?, ft.schedule_id, " + minMax + "  FROM " + fromTable + " ft " + "  WHERE ft.time_stamp >= ? AND ft.time_stamp < ? " + "  GROUP BY ft.schedule_id)");
            insStmt.setLong(1, begin);
            insStmt.setLong(2, begin);
            insStmt.setLong(3, end);
            watch.reset();
            rows = insStmt.executeUpdate();
            MeasurementMonitor.getMBean().incrementMeasurementCompressionTime(watch.getElapsed());
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)conn, insStmt, null);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)insStmt, null);
        this.log.info((Object)("Finished compressing data from table [" + fromTable + "] to table [" + toTable + "] between [" + TimeUtil.toString((long)begin) + "] and [" + TimeUtil.toString((long)end) + "], [" + rows + "] compressed rows in [" + watch.getElapsed() / 1000L + "] seconds"));
        return rows;
    }

    private long getMinTimestamp(String dataTable) throws SQLException {
        block3: {
            long l;
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                conn = this.dataSource.getConnection();
                String sql = "SELECT MIN(time_stamp) FROM " + dataTable;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, stmt, rs);
                throw throwable;
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return l;
        }
        throw new SQLException("Unable to determine oldest measurement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMaxTimestamp(String dataTable) throws SQLException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block3: {
            long l;
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.dataSource.getConnection();
                String sql = "SELECT MAX(time_stamp) FROM " + dataTable;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                if (!rs.next()) break block3;
                l = rs.getLong(1);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, stmt, rs);
                throw throwable;
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)stmt, (ResultSet)rs);
            return l;
        }
        long l = 0L;
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return l;
    }

    private void purgeMeasurements(String tableName, long purgeBefore, long interval) throws SQLException {
        this.log.info((Object)("Begin purging data from table [" + tableName + "] before [" + new Date(purgeBefore) + "]"));
        int totalRows = 0;
        int rows = 1;
        long min = this.getMinTimestamp(tableName);
        long start = purgeBefore - interval;
        if (min == 0L) {
            this.log.info((Object)("No data to purge from table [" + tableName + "]"));
        } else {
            while (start + interval >= min) {
                try {
                    rows = this.compressionManager.purgeMeasurementInterval(tableName, start, start + interval);
                    totalRows += rows;
                }
                catch (Throwable t) {
                    this.log.error((Object)("Unable to purge data from table [" + tableName + "] between [" + new Date(start) + "] and [" + new Date(start + interval) + "], cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                }
                start -= interval;
            }
        }
        this.log.info((Object)("Finished purging data from table [" + tableName + "] before [" + new Date(purgeBefore) + "], [" + totalRows + "] rows removed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionTimeout(value=3600L)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int purgeMeasurementInterval(String tableName, long purgeAfter, long purgeBefore) throws SQLException {
        int rows;
        Connection conn = null;
        PreparedStatement stmt = null;
        this.log.info((Object)("Begin purging data from table [" + tableName + "] between [" + TimeUtil.toString((long)purgeAfter) + "] and [" + TimeUtil.toString((long)purgeBefore) + "]"));
        StopWatch watch = new StopWatch();
        try {
            conn = this.dataSource.getConnection();
            String sql = "DELETE FROM " + tableName + " WHERE time_stamp >= ? AND time_stamp < ?";
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, purgeAfter);
            stmt.setLong(2, purgeBefore);
            rows = stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)conn, stmt, null);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
        MeasurementMonitor.getMBean().incrementPurgeTime(watch.getElapsed());
        this.log.info((Object)("Finished purging data from table [" + tableName + "] between [" + TimeUtil.toString((long)purgeAfter) + "] and [" + TimeUtil.toString((long)purgeBefore) + "], [" + rows + "] rows removed in [" + watch.getElapsed() / 1000L + "] seconds"));
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void truncateMeasurements(String tableName) throws SQLException {
        if (tableName.equals(MeasurementDataManagerUtility.getDeadTable(System.currentTimeMillis()))) {
            Connection conn = null;
            Statement stmt = null;
            StopWatch watch = new StopWatch();
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.createStatement();
                long startTime = System.currentTimeMillis();
                stmt.executeUpdate("TRUNCATE TABLE " + tableName);
                MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose((Connection)conn, stmt, null);
                this.log.info((Object)("Truncated table [" + tableName + "] in [" + watch.getElapsed() / 1000L + "] seconds"));
                throw throwable;
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
            this.log.info((Object)("Truncated table [" + tableName + "] in [" + watch.getElapsed() / 1000L + "] seconds"));
        }
    }
}

