/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.enterprise.server.measurement.MetricsManagerLocal;
import org.rhq.enterprise.server.storage.StorageClientManagerBean;
import org.rhq.server.metrics.MetricsServer;
import org.rhq.server.metrics.domain.AggregateNumericMetric;
import org.rhq.server.metrics.domain.RawNumericMetric;

@Stateless
public class MetricsManagerBean
implements MetricsManagerLocal {
    @EJB
    private StorageClientManagerBean sessionManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void addNumericData(Set<MeasurementDataNumeric> data, Runnable callback) {
        MetricsServer metricsServer = this.getMetricsServer();
        metricsServer.addNumericData(data, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public Iterable<AggregateNumericMetric> calculateAggregates() {
        MetricsServer metricsServer = this.getMetricsServer();
        return metricsServer.calculateAggregates();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MeasurementDataNumeric findLatestValueForResource(int scheduleId) {
        MetricsServer metricsServer = this.getMetricsServer();
        RawNumericMetric metric = metricsServer.findLatestValueForResource(scheduleId);
        if (metric == null) {
            return null;
        }
        return new MeasurementDataNumeric(metric.getTimestamp(), scheduleId, metric.getValue());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public Iterable<MeasurementDataNumericHighLowComposite> findDataForResource(int scheduleId, long beginTime, long endTime) {
        MetricsServer metricsServer = this.getMetricsServer();
        return metricsServer.findDataForResource(scheduleId, beginTime, endTime, 60);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public Iterable<MeasurementDataNumericHighLowComposite> findDataForResource(int scheduleId, long beginTime, long endTime, int numberOfBuckets) {
        MetricsServer metricsServer = this.getMetricsServer();
        return metricsServer.findDataForResource(scheduleId, beginTime, endTime, numberOfBuckets);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MeasurementAggregate getSummaryAggregate(int scheduleId, long beginTime, long endTime) {
        MetricsServer metricsServer = this.getMetricsServer();
        AggregateNumericMetric summary = metricsServer.getSummaryAggregate(scheduleId, beginTime, endTime);
        return new MeasurementAggregate(summary.getMin(), summary.getAvg(), summary.getMax());
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public MeasurementAggregate getSummaryAggregate(List<Integer> scheduleIds, long beginTime, long endTime) {
        MetricsServer metricsServer = this.getMetricsServer();
        AggregateNumericMetric summary = metricsServer.getSummaryAggregate(scheduleIds, beginTime, endTime);
        return new MeasurementAggregate(summary.getMin(), summary.getAvg(), summary.getMax());
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<MeasurementDataNumericHighLowComposite> findDataForResourceGroup(List<Integer> scheduleIds, long beginTime, long endTime) {
        MetricsServer metricsServer = this.getMetricsServer();
        return metricsServer.findDataForGroup(scheduleIds, beginTime, endTime, 60);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public List<MeasurementDataNumericHighLowComposite> findDataForResourceGroup(List<Integer> scheduleIds, long beginTime, long endTime, int numberOfBuckets) {
        MetricsServer metricsServer = this.getMetricsServer();
        return metricsServer.findDataForGroup(scheduleIds, beginTime, endTime, numberOfBuckets);
    }

    private MetricsServer getMetricsServer() {
        return this.sessionManager.getMetricsServer();
    }
}

