/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.remote;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.rhq.enterprise.server.remote.RemoteSafeInvocationHandlerMetricsMBean;

public class RemoteSafeInvocationHandlerMetrics
implements RemoteSafeInvocationHandlerMetricsMBean {
    private long numberSuccessfulInvocations = 0L;
    private long numberFailedInvocations = 0L;
    private long averageExecutionTime = 0L;
    private Map<String, Calltime> calltimes = new HashMap<String, Calltime>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock();
        try {
            this.numberSuccessfulInvocations = 0L;
            this.numberFailedInvocations = 0L;
            this.averageExecutionTime = 0L;
            this.calltimes.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Calltime> getCallTimeData() {
        this.readLock();
        try {
            HashMap<String, Calltime> hashMap = new HashMap<String, Calltime>(this.calltimes);
            return hashMap;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Map<String, long[]> getCallTimeDataAsPrimitives() {
        Map<String, Calltime> calltimeData = this.getCallTimeData();
        HashMap<String, long[]> calltimeDataPrimitives = new HashMap<String, long[]>(calltimeData.size());
        for (Map.Entry<String, Calltime> entry : calltimeData.entrySet()) {
            Calltime calltime = entry.getValue();
            calltimeDataPrimitives.put(entry.getKey(), new long[]{calltime.getCount(), calltime.getSuccesses(), calltime.getFailures(), calltime.getMinimum(), calltime.getMaximum(), calltime.getAverage()});
        }
        return calltimeDataPrimitives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberFailedInvocations() {
        this.readLock();
        try {
            long l = this.numberFailedInvocations;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberSuccessfulInvocations() {
        this.readLock();
        try {
            long l = this.numberSuccessfulInvocations;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberTotalInvocations() {
        this.readLock();
        try {
            long l = this.numberSuccessfulInvocations + this.numberFailedInvocations;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAverageExecutionTime() {
        this.readLock();
        try {
            long l = this.averageExecutionTime;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addData(String type, long executionTime, boolean successful) {
        this.writeLock();
        try {
            Calltime calltime;
            if (type == null) {
                type = "(unknown)";
            }
            if ((calltime = this.calltimes.get(type)) == null) {
                calltime = new Calltime();
                this.calltimes.put(type, calltime);
            }
            calltime.count++;
            if (successful) {
                ++this.numberSuccessfulInvocations;
                this.averageExecutionTime = ((this.numberSuccessfulInvocations - 1L) * this.averageExecutionTime + executionTime) / this.numberSuccessfulInvocations;
                if (executionTime > calltime.max) {
                    calltime.max = executionTime;
                }
                if (executionTime < calltime.min) {
                    calltime.min = executionTime;
                }
                long successes = calltime.getSuccesses();
                calltime.avg = ((successes - 1L) * calltime.avg + executionTime) / successes;
            } else {
                ++this.numberFailedInvocations;
                calltime.failures++;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean writeLock() {
        try {
            return this.lock.writeLock().tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            this.lock = new ReentrantReadWriteLock();
        }
        return false;
    }

    private void writeUnlock() {
        try {
            this.lock.writeLock().unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean readLock() {
        try {
            return this.lock.readLock().tryLock(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void readUnlock() {
        try {
            this.lock.readLock().unlock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class Calltime
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long count = 0L;
        private long failures = 0L;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;
        private long avg = 0L;

        public long getCount() {
            return this.count;
        }

        public long getFailures() {
            return this.failures;
        }

        public long getSuccesses() {
            return this.count - this.failures;
        }

        public long getMinimum() {
            return this.min;
        }

        public long getMaximum() {
            return this.max;
        }

        public long getAverage() {
            return this.avg;
        }

        public String toString() {
            return "" + this.count + ':' + this.failures + ':' + this.min + ':' + this.max + ':' + this.avg;
        }
    }
}

