/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group.definition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionExpressionBuilderManagerLocal;

@Stateless
public class GroupDefinitionExpressionBuilderManagerBean
implements GroupDefinitionExpressionBuilderManagerLocal {
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;

    @Override
    public List<String> getTraitPropertyNames(int resourceTypeId) {
        List<MeasurementDefinition> definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByResourceType(this.subjectManager.getOverlord(), resourceTypeId, DataType.TRAIT, null);
        ArrayList<String> results = new ArrayList<String>();
        for (MeasurementDefinition definition : definitions) {
            results.add(definition.getName());
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public List<String> getPluginConfigurationPropertyNames(int resourceTypeId) {
        ResourceType type = null;
        try {
            type = this.resourceTypeManager.getResourceTypeById(this.subjectManager.getOverlord(), resourceTypeId);
        }
        catch (ResourceTypeNotFoundException rtnfe) {
            return Collections.emptyList();
        }
        ConfigurationDefinition pluginConfiguriatonDefinition = type.getPluginConfigurationDefinition();
        return this.getPropertyNames(pluginConfiguriatonDefinition);
    }

    @Override
    public List<String> getResourceConfigurationPropertyNames(int resourceTypeId) {
        ResourceType type = null;
        try {
            type = this.resourceTypeManager.getResourceTypeById(this.subjectManager.getOverlord(), resourceTypeId);
        }
        catch (ResourceTypeNotFoundException rtnfe) {
            return Collections.emptyList();
        }
        ConfigurationDefinition resourceConfiguriatonDefinition = type.getResourceConfigurationDefinition();
        return this.getPropertyNames(resourceConfiguriatonDefinition);
    }

    private List<String> getPropertyNames(ConfigurationDefinition definition) {
        if (definition == null) {
            return Collections.emptyList();
        }
        Map definitions = definition.getPropertyDefinitions();
        if (definitions == null) {
            return Collections.emptyList();
        }
        Set uniqueNames = definitions.keySet();
        ArrayList<String> propertyNames = new ArrayList<String>(uniqueNames);
        Collections.sort(propertyNames);
        return propertyNames;
    }
}

