/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.resource.metadata.CollectionsUtil;
import org.rhq.enterprise.server.resource.metadata.OperationMetadataManagerLocal;

@Stateless
public class OperationMetadataManagerBean
implements OperationMetadataManagerLocal {
    private static final Log log = LogFactory.getLog(OperationMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMetadata(ResourceType existingType, ResourceType newType) {
        log.debug((Object)("Updating operation definitions for " + existingType));
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        Set existingDefinitions = existingType.getOperationDefinitions();
        Set newDefinitions = newType.getOperationDefinitions();
        Set<OperationDefinition> newOps = CollectionsUtil.missingInFirstSet(existingDefinitions, newDefinitions);
        Set<OperationDefinition> opsToRemove = CollectionsUtil.missingInFirstSet(newDefinitions, existingDefinitions);
        existingDefinitions.retainAll(newDefinitions);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Operation definitions to be added: " + newOps));
            log.debug((Object)("Operation definitions to be removed: " + opsToRemove));
            log.debug((Object)("Operation definitions to be updated: " + existingDefinitions));
        }
        for (OperationDefinition def : existingDefinitions) {
            for (OperationDefinition nDef : newDefinitions) {
                if (!def.equals((Object)nDef)) continue;
                def.setDescription(nDef.getDescription());
                def.setDisplayName(nDef.getDisplayName());
                def.setParametersConfigurationDefinition(nDef.getParametersConfigurationDefinition());
                def.setResourceVersionRange(nDef.getResourceVersionRange());
                def.setResultsConfigurationDefinition(nDef.getResultsConfigurationDefinition());
                def.setTimeout(nDef.getTimeout());
            }
        }
        for (OperationDefinition newOp : newOps) {
            existingType.addOperationDefinition(newOp);
        }
        existingDefinitions.removeAll(opsToRemove);
        for (OperationDefinition opToDelete : opsToRemove) {
            Query q = this.entityMgr.createNamedQuery("OperationHistory.deleteyByDefinition");
            q.setParameter("definition", (Object)opToDelete);
            q.executeUpdate();
            this.entityMgr.remove((Object)opToDelete);
        }
    }
}

