/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.server.configuration.metadata.ConfigurationMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.ResourceConfigurationMetadataManagerLocal;

@Stateless
public class ResourceConfigurationMetadataManagerBean
implements ResourceConfigurationMetadataManagerLocal {
    private static final Log log = LogFactory.getLog(ResourceConfigurationMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private ConfigurationMetadataManagerLocal configurationMetadataMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateResourceConfigurationDefinition(ResourceType existingType, ResourceType newType) {
        log.debug((Object)("Updating resource configuration definition for " + existingType));
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        ConfigurationDefinition newResourceConfigurationDefinition = newType.getResourceConfigurationDefinition();
        if (newResourceConfigurationDefinition != null) {
            if (existingType.getResourceConfigurationDefinition() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(existingType + " currently does not have a resource configuration definition. Adding " + "new resource configuration definition."));
                }
                this.entityMgr.persist((Object)newResourceConfigurationDefinition);
                existingType.setResourceConfigurationDefinition(newResourceConfigurationDefinition);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating existing resource configuration definition for " + existingType));
                }
                ConfigurationDefinition existingDefinition = existingType.getResourceConfigurationDefinition();
                this.configurationMetadataMgr.updateConfigurationDefinition(newResourceConfigurationDefinition, existingDefinition);
            }
        } else if (existingType.getResourceConfigurationDefinition() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing resource configuration definition for " + existingType));
            }
            existingType.setResourceConfigurationDefinition(null);
        }
    }
}

