/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.storage;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.Session;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.cassandra.util.ClusterBuilder;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.cloud.StorageNode;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.server.metrics.DateTimeService;
import org.rhq.server.metrics.MetricsConfiguration;
import org.rhq.server.metrics.MetricsDAO;
import org.rhq.server.metrics.MetricsServer;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class StorageClientManagerBean {
    private final Log log = LogFactory.getLog(StorageClientManagerBean.class);
    private static final String USERNAME_PROP = "rhq.cassandra.username";
    private static final String PASSWORD_PROP = "rhq.cassandra.password";
    private static final String RHQ_KEYSPACE = "rhq";
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    private Session session;
    private MetricsConfiguration metricsConfiguration;
    private MetricsDAO metricsDAO;
    private MetricsServer metricsServer;
    private boolean initialized;

    public synchronized void init() {
        if (this.initialized) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Storage client subsystem is already initialized. Skipping initialization.");
            }
            return;
        }
        this.log.info((Object)"Initializing storage client subsystem");
        boolean isNewServerInstall = this.storageNodeManager.getStorageNodes().isEmpty();
        this.storageNodeManager.scanForStorageNodes();
        String username = this.getRequiredStorageProperty(USERNAME_PROP);
        String password = this.getRequiredStorageProperty(PASSWORD_PROP);
        this.metricsConfiguration = new MetricsConfiguration();
        this.session = this.createSession(username, password, this.storageNodeManager.getStorageNodes());
        this.metricsDAO = new MetricsDAO(this.session, this.metricsConfiguration);
        Server server = this.serverManager.getServer();
        this.initMetricsServer(isNewServerInstall, server.getCtime());
        this.initialized = true;
        this.log.info((Object)"Storage client subsystem is now initialized");
    }

    public synchronized void shutdown() {
        if (!this.initialized) {
            this.log.info((Object)"Storage client subsystem is already shut down. Skipping shutdown steps.");
            return;
        }
        this.log.info((Object)"Shutting down storage client subsystem");
        this.metricsServer.shutdown();
        this.metricsDAO = null;
        this.metricsServer = null;
        this.session.getCluster().shutdown();
        this.session = null;
        this.initialized = false;
    }

    public MetricsDAO getMetricsDAO() {
        return this.metricsDAO;
    }

    public MetricsServer getMetricsServer() {
        return this.metricsServer;
    }

    public Session getSession() {
        return this.session;
    }

    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    private Session createSession(String username, String password, List<StorageNode> storageNodes) {
        ProtocolOptions.Compression compression;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initializing session to connect to storage node cluster");
        }
        ArrayList<String> hostNames = new ArrayList<String>();
        for (StorageNode storageNode : storageNodes) {
            hostNames.add(storageNode.getAddress());
        }
        int port = storageNodes.get(0).getCqlPort();
        boolean compressionEnabled = Boolean.valueOf(System.getProperty("rhq.cassandra.client.compression-enabled", "false"));
        if (compressionEnabled) {
            compression = ProtocolOptions.Compression.SNAPPY;
            this.log.info((Object)"Compression has been enabled for the storage client. Be aware that if your storage nodes do not support compression then the client will not be able to connect to the storage cluster.");
        } else {
            compression = ProtocolOptions.Compression.NONE;
            this.log.debug((Object)"Storage client compression is disabled");
        }
        Cluster cluster = new ClusterBuilder().addContactPoints(hostNames.toArray(new String[hostNames.size()])).withCredentials(username, password).withPort(port).withCompression(compression).build();
        return cluster.connect(RHQ_KEYSPACE);
    }

    private void initMetricsServer(boolean isNewInstall, long serverInstallTime) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing " + MetricsServer.class.getName()));
        }
        this.metricsServer = new MetricsServer();
        this.metricsServer.setDAO(this.metricsDAO);
        this.metricsServer.setConfiguration(this.metricsConfiguration);
        DateTimeService dateTimeService = new DateTimeService();
        dateTimeService.setConfiguration(this.metricsConfiguration);
        this.metricsServer.setDateTimeService(dateTimeService);
        this.metricsServer.init(isNewInstall, serverInstallTime);
    }

    private String getRequiredStorageProperty(String property) {
        String value = System.getProperty(property);
        if (StringUtil.isEmpty((String)property)) {
            throw new IllegalStateException("The system property [" + property + "] is not set. The RHQ " + "server will not be able connect to the RHQ storage node(s). This property should be defined " + "in rhq-server.properties.");
        }
        return value;
    }
}

