/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.filetemplate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleDeploymentAction;
import org.rhq.core.domain.bundle.BundleDeploymentStatus;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.filetemplate.ProcessingRecipeContext;

public class FileTemplateBundlePluginServerComponent
implements ResourceComponent,
BundleFacet {
    private final Log log = LogFactory.getLog(FileTemplateBundlePluginServerComponent.class);
    private ResourceContext resourceContext;

    public void start(ResourceContext context) {
        this.resourceContext = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public BundleDeployResult deployBundle(BundleDeployRequest request) {
        BundleDeployResult result = new BundleDeployResult();
        try {
            BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
            BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            BundleVersion bundleVersion = bundleDeployment.getBundleVersion();
            String recipe = bundleVersion.getRecipe();
            RecipeParser parser = new RecipeParser();
            ProcessingRecipeContext recipeContext = new ProcessingRecipeContext(recipe, request.getPackageVersionFiles(), this.resourceContext.getSystemInformation(), request.getBundleFilesLocation().getAbsolutePath());
            request.getBundleManagerProvider().auditDeployment(resourceDeployment, BundleDeploymentAction.DEPLOYMENT_STEP, BundleDeploymentStatus.NOCHANGE, "setting replacement variable values using [" + bundleDeployment.getConfiguration().toString(true) + "]");
            recipeContext.setReplacementVariableValues(bundleDeployment.getConfiguration());
            parser.setReplaceReplacementVariables(true);
            request.getBundleManagerProvider().auditDeployment(resourceDeployment, BundleDeploymentAction.DEPLOYMENT_STEP, BundleDeploymentStatus.NOCHANGE, "Parsing Recipe using context [" + (Object)((Object)recipeContext) + "]");
            parser.parseRecipe((RecipeContext)recipeContext);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to deploy bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }
}

