/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.filetemplate;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.bundle.BundleDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.bundle.BundleVersion;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.bundle.BundleDeployRequest;
import org.rhq.core.pluginapi.bundle.BundleDeployResult;
import org.rhq.core.pluginapi.bundle.BundleFacet;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.pluginapi.bundle.BundlePurgeRequest;
import org.rhq.core.pluginapi.bundle.BundlePurgeResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.util.file.FileUtil;
import org.rhq.plugins.filetemplate.ProcessingRecipeContext;

public class FileTemplateBundlePluginServerComponent
implements ResourceComponent,
BundleFacet {
    private static final String DEPLOY_DIR = "rhq.deploy.dir";
    private static final String DEPLOY_ID = "rhq.deploy.id";
    public static final String DEPLOY_NAME = "rhq.deploy.name";
    private final Log log = LogFactory.getLog(FileTemplateBundlePluginServerComponent.class);
    private ResourceContext resourceContext;

    public void start(ResourceContext context) {
        this.resourceContext = context;
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    public BundleDeployResult deployBundle(BundleDeployRequest request) {
        BundleDeployResult result = new BundleDeployResult();
        if (request.isRevert()) {
            result.setErrorMessage("File template bundles cannot be reverted");
            return result;
        }
        try {
            File deployDir;
            BundleResourceDeployment resourceDeployment = request.getResourceDeployment();
            BundleDeployment bundleDeployment = resourceDeployment.getBundleDeployment();
            BundleVersion bundleVersion = bundleDeployment.getBundleVersion();
            BundleManagerProvider bundleManagerProvider = request.getBundleManagerProvider();
            if (request.isCleanDeployment() && (deployDir = request.getAbsoluteDestinationDirectory()).exists()) {
                bundleManagerProvider.auditDeployment(resourceDeployment, "Cleaning Deployment", deployDir.getAbsolutePath(), null, null, "The existing deployment found at [" + deployDir.getAbsolutePath() + "] will be removed.", null);
                FileUtils.purge((File)deployDir, (boolean)true);
            }
            String recipe = bundleVersion.getRecipe();
            RecipeParser parser = new RecipeParser();
            ProcessingRecipeContext recipeContext = new ProcessingRecipeContext(recipe, request.getPackageVersionFiles(), this.resourceContext.getSystemInformation(), request.getBundleFilesLocation().getAbsolutePath(), resourceDeployment, bundleManagerProvider);
            bundleManagerProvider.auditDeployment(resourceDeployment, "Configurtion Variable Replacement", bundleDeployment.getName(), null, null, "setting replacement variable values using [" + bundleDeployment.getConfiguration().toString(true) + "]", null);
            recipeContext.setReplacementVariableValues(bundleDeployment.getConfiguration());
            recipeContext.addReplacementVariableValue(DEPLOY_DIR, request.getAbsoluteDestinationDirectory().getAbsolutePath());
            recipeContext.addReplacementVariableValue(DEPLOY_ID, Integer.toString(bundleDeployment.getId()));
            recipeContext.addReplacementVariableValue(DEPLOY_NAME, bundleDeployment.getName());
            parser.setReplaceReplacementVariables(true);
            bundleManagerProvider.auditDeployment(resourceDeployment, "Parse Recipe", bundleDeployment.getName(), null, null, "Parsing Recipe using context [" + (Object)((Object)recipeContext) + "]", null);
            parser.parseRecipe((RecipeContext)recipeContext);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to deploy bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }

    public BundlePurgeResult purgeBundle(BundlePurgeRequest request) {
        BundlePurgeResult result = new BundlePurgeResult();
        try {
            BundleResourceDeployment deploymentToPurge = request.getLiveResourceDeployment();
            File deployDir = request.getAbsoluteDestinationDirectory();
            String deployDirAbsolutePath = deployDir.getAbsolutePath();
            BundleManagerProvider bundleManagerProvider = request.getBundleManagerProvider();
            FileUtil.purge((File)deployDir, (boolean)true);
            if (!deployDir.exists()) {
                bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "The destination directory has been purged", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.SUCCESS, "Directory purged: " + deployDirAbsolutePath, null);
            } else {
                bundleManagerProvider.auditDeployment(deploymentToPurge, "Purge", "The destination directory failed to be purged", BundleResourceDeploymentHistory.Category.AUDIT_MESSAGE, BundleResourceDeploymentHistory.Status.FAILURE, "The directory that failed to be purged: " + deployDirAbsolutePath, null);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to purge bundle [" + request + "]"), t);
            result.setErrorMessage(t);
        }
        return result;
    }
}

