/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.grub;

import java.io.File;
import java.util.Date;
import java.util.List;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;

public class GrubComponent
implements ResourceComponent,
ConfigurationFacet {
    private ResourceContext resourceContext;
    private File grubFile;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        Configuration pluginConfiguration = resourceContext.getPluginConfiguration();
        PropertySimple grubPathProperty = pluginConfiguration.getSimple("grub-conf-path");
        if (grubPathProperty == null) {
            throw new InvalidPluginConfigurationException("GRUB configuration file path not found in the plugin configuration, cannot start resource component");
        }
        String grubPath = grubPathProperty.getStringValue();
        this.grubFile = new File(grubPath);
        if (!this.grubFile.exists()) {
            throw new InvalidPluginConfigurationException("GRUB configuration file not found at specified location: " + grubPath);
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        if (this.grubFile == null) {
            return AvailabilityType.DOWN;
        }
        return this.grubFile.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        return this.loadResourceConfiguration(pluginConfiguration);
    }

    public Configuration loadResourceConfiguration(Configuration pluginConfiguration) throws Exception {
        PropertySimple lensesPathProperty = pluginConfiguration.getSimple("lenses-path");
        if (lensesPathProperty == null) {
            throw new Exception("Lenses path not found in plugin configuration, cannot retrieve configuration");
        }
        PropertySimple rootPathProperty = pluginConfiguration.getSimple("root-path");
        if (rootPathProperty == null) {
            throw new Exception("Root path not found in plugin configuration, cannot retrieve configuration");
        }
        String lensesPath = lensesPathProperty.getStringValue();
        String rootPath = rootPathProperty.getStringValue();
        Augeas augeas = new Augeas(rootPath, lensesPath);
        PropertySimple augeasTreeNodeProperty = pluginConfiguration.getSimple("augeas-grub-path");
        if (augeasTreeNodeProperty == null) {
            throw new Exception("Augeas tree node not specified for grub, cannot retrive configuration");
        }
        Configuration configuration = new Configuration();
        configuration.setNotes("Loaded from Augeas at " + new Date());
        String grubTreeNode = augeasTreeNodeProperty.getStringValue();
        List generalMatches = augeas.match(grubTreeNode);
        if (generalMatches.size() > 0) {
            PropertyMap generalProperties = new PropertyMap("generalProperties");
            configuration.put((Property)generalProperties);
            for (String generalNode : generalMatches) {
                String name = generalNode.substring(generalNode.lastIndexOf("/") + 1);
                if (name.startsWith("title")) continue;
                String value = augeas.get(generalNode);
                generalProperties.put((Property)new PropertySimple(name, (Object)value));
            }
        }
        String grubTitleNode = grubTreeNode.substring(0, grubTreeNode.length() - 1) + "title";
        List kernelMatches = augeas.match(grubTitleNode);
        PropertyList entriesList = new PropertyList("kernelEntries");
        configuration.put((Property)entriesList);
        for (String entryNode : kernelMatches) {
            String title = augeas.get(entryNode);
            String root = augeas.get(entryNode + "/root");
            String kernel = augeas.get(entryNode + "/kernel");
            String initrd = augeas.get(entryNode + "/initrd");
            PropertyMap entry = new PropertyMap("kernelEntry");
            entry.put((Property)new PropertySimple("title", (Object)title));
            entry.put((Property)new PropertySimple("root", (Object)root));
            entry.put((Property)new PropertySimple("kernel", (Object)kernel));
            entry.put((Property)new PropertySimple("initrd", (Object)initrd));
            entriesList.add((Property)entry);
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }
}

