/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hudson;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONObject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.hudson.HudsonJSONUtility;

public class HudsonDiscoveryComponent
implements ResourceDiscoveryComponent {
    public Set discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> found = new HashSet<DiscoveredResourceDetails>();
        for (Configuration config : resourceDiscoveryContext.getPluginConfigurations()) {
            String path = config.getSimple("urlBase").getStringValue();
            URL url = new URL(path);
            JSONObject server = HudsonJSONUtility.getData(path, 0);
            server.getString("description");
            DiscoveredResourceDetails hudson = new DiscoveredResourceDetails(resourceDiscoveryContext.getResourceType(), url.toString(), url.getHost() + url.getPath(), HudsonJSONUtility.getVersion(path), "hudson server", config, null);
            found.add(hudson);
        }
        return found;
    }
}

