/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hudson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class HudsonJSONUtility {
    private static final Log LOG = LogFactory.getLog(HudsonJSONUtility.class);

    public static JSONObject getData(String path, int depth) {
        URL url = null;
        try {
            String line;
            path = path.replaceAll(" ", "%20");
            url = new URL(path + "/api/json?depth=" + depth);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream is = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder(2048);
            while ((line = br.readLine()) != null) {
                builder.append(line);
            }
            JSONObject jsonObject = new JSONObject(builder.toString());
            return jsonObject;
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        catch (JSONException e) {
            LOG.warn((Object)e);
        }
        return null;
    }

    public static String getVersion(String path) {
        try {
            String line;
            URL url = new URL(path);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream is = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder(2048);
            while ((line = br.readLine()) != null) {
                int verIndex = line.indexOf("Hudson ver. ");
                if (verIndex >= 0) {
                    int endIndex = line.indexOf(60, verIndex);
                    String version = line.substring(verIndex + "Hudson ver. ".length(), endIndex);
                    return version;
                }
                builder.append(line);
            }
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)e);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
        return null;
    }

    public static void main(String[] args) throws JSONException {
        System.out.println("VERSION: " + HudsonJSONUtility.getVersion("http://hudson.jboss.org/hudson"));
        JSONObject object = HudsonJSONUtility.getData("http://hudson.jboss.org/hudson/job/DNA continuous on JDK1.5", 0);
        System.out.println("Got it\n" + object.toString(2));
        System.out.println(object.get("description"));
        System.out.println(object.getJSONArray("jobs").length());
    }
}

