/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class TokenReplacingReader
extends Reader {
    private PushbackReader pushbackReader = null;
    private Map<String, String> tokens = null;
    private StringBuilder tokenNameBuffer = new StringBuilder();
    private String tokenValue = null;
    private int tokenValueIndex = 0;
    private boolean escaping = false;
    private Deque<String> activeTokens;
    private Map<String, String> resolvedTokens;

    public TokenReplacingReader(Reader source, Map<String, String> tokens) {
        this.pushbackReader = new PushbackReader(source, 2);
        this.tokens = tokens;
        this.activeTokens = new ArrayDeque<String>();
        this.resolvedTokens = new HashMap<String, String>();
    }

    protected TokenReplacingReader(String source, Map<String, String> tokens, Deque<String> activeTokens, Map<String, String> resolvedTokens) {
        this.pushbackReader = new PushbackReader(new StringReader(source));
        this.tokens = tokens;
        this.activeTokens = activeTokens;
        this.resolvedTokens = resolvedTokens;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        throw new RuntimeException("Operation Not Supported");
    }

    @Override
    public int read() throws IOException {
        if (this.tokenValue != null) {
            if (this.tokenValueIndex < this.tokenValue.length()) {
                return this.tokenValue.charAt(this.tokenValueIndex++);
            }
            if (this.tokenValueIndex == this.tokenValue.length()) {
                this.tokenValue = null;
                this.tokenValueIndex = 0;
            }
        }
        int data = this.pushbackReader.read();
        if (this.escaping) {
            this.escaping = false;
            return data;
        }
        if (data == 92) {
            this.escaping = true;
            return data;
        }
        if (data != 36) {
            return data;
        }
        data = this.pushbackReader.read();
        if (data != 123) {
            this.pushbackReader.unread(data);
            return 36;
        }
        this.tokenNameBuffer.delete(0, this.tokenNameBuffer.length());
        data = this.pushbackReader.read();
        while (data != 125) {
            this.tokenNameBuffer.append((char)data);
            data = this.pushbackReader.read();
        }
        String tokenName = this.tokenNameBuffer.toString();
        this.tokenValue = this.resolvedTokens.containsKey(tokenName) ? this.resolvedTokens.get(tokenName) : this.resolveToken(tokenName);
        this.tokenValueIndex = 0;
        if (!this.tokenValue.isEmpty()) {
            return this.tokenValue.charAt(this.tokenValueIndex++);
        }
        return this.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            int nextChar = this.read();
            if (nextChar == -1) {
                if (i != 0) break;
                i = -1;
                break;
            }
            cbuf[off + i] = (char)nextChar;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.pushbackReader.close();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("skip() not supported on TokenReplacingReader.");
    }

    @Override
    public boolean ready() throws IOException {
        return this.pushbackReader.ready();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported on TokenReplacingReader.");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported on TokenReplacingReader.");
    }

    private String readAll(Reader r) throws IOException {
        int c;
        StringBuilder bld = new StringBuilder();
        while ((c = r.read()) >= 0) {
            bld.append((char)c);
        }
        return bld.toString();
    }

    private String resolveToken(String tokenName) throws IOException {
        if (this.activeTokens.contains(tokenName)) {
            throw new IllegalArgumentException("Token '" + tokenName + "' (indirectly) contains reference to itself in its value.");
        }
        this.activeTokens.push(tokenName);
        String tokenValue = this.tokens.get(tokenName);
        if (tokenValue != null) {
            if (tokenValue.contains("${")) {
                TokenReplacingReader childReader = new TokenReplacingReader(tokenValue, this.tokens, this.activeTokens, this.resolvedTokens);
                tokenValue = this.readAll(childReader);
            }
        } else {
            tokenValue = "${" + tokenName + "}";
        }
        this.resolvedTokens.put(tokenName, tokenValue);
        this.activeTokens.pop();
        return tokenValue;
    }
}

