/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.irc;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.irc.IRCServerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRCChannelComponent
implements ResourceComponent<IRCServerComponent>,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<IRCServerComponent> context;
    private EventContext eventContext;
    private String channel;
    private AtomicLong messageCount = new AtomicLong();

    public AvailabilityType getAvailability() {
        if (!((IRCServerComponent)this.context.getParentResourceComponent()).isInChannel(this.channel)) {
            ((IRCServerComponent)this.context.getParentResourceComponent()).registerChannel(this);
        }
        return AvailabilityType.UP;
    }

    public void start(ResourceContext<IRCServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        Configuration conf = context.getPluginConfiguration();
        this.channel = conf.getSimple("channelName").getStringValue();
        this.eventContext = context.getEventContext();
        ((IRCServerComponent)context.getParentResourceComponent()).registerChannel(this);
    }

    public void stop() {
        ((IRCServerComponent)this.context.getParentResourceComponent()).unregisterChannel(this);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            if (req.getName().equals("users")) {
                double count = ((IRCServerComponent)this.context.getParentResourceComponent()).getUserCount(this.getChannel());
                MeasurementDataNumeric res = new MeasurementDataNumeric(req, Double.valueOf(count));
                report.addData(res);
                continue;
            }
            if (!req.getName().equals("messages")) continue;
            report.addData(new MeasurementDataNumeric(req, Double.valueOf(this.messageCount.get())));
        }
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        OperationResult res = new OperationResult();
        if ("sendMessage".equals(name)) {
            String message = params.getSimple("message").getStringValue();
            ((IRCServerComponent)this.context.getParentResourceComponent()).sendMessage(this.channel, message);
        }
        return res;
    }

    public String getChannel() {
        return this.channel;
    }

    public void acceptMessage(String sender, String login, String hostname, String message) {
        Event event = new Event("message", sender, System.currentTimeMillis(), EventSeverity.INFO, message);
        this.eventContext.publishEvent(event);
        this.messageCount.incrementAndGet();
    }
}

