package org.rhq.plugins.irc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

import java.util.HashSet;
import java.util.Set;
import java.util.List;


/**
 * Discovery class
 * @author Greg Hinkle
 */
public class IRCServerDiscoveryComponent implements ResourceDiscoveryComponent {


    private final Log log = LogFactory.getLog(this.getClass());

    public static final String CONFIG_HOST = "host";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_NICK = "botNick";

    /**
     * Run the discovery
     */
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {

        Set<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();

        List<Configuration> contextPluginConfigurations = discoveryContext.getPluginConfigurations();
        for (Configuration config : contextPluginConfigurations) {

            String host = config.getSimple(CONFIG_HOST).getStringValue();
            int port = config.getSimple(CONFIG_PORT).getIntegerValue();

            DiscoveredResourceDetails details =
                    new DiscoveredResourceDetails(
                            discoveryContext.getResourceType(),
                            host,
                            "IRC " + host,
                            null, null,
                            config,
                            null
                    );

            discoveredResources.add(details);
        }

        return discoveredResources;

    }
}