/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.modules.plugins.jbossas7.AS7Authenticator;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ASConnection {
    public static final String MANAGEMENT = "/management";
    private final Log log = LogFactory.getLog(ASConnection.class);
    URL url;
    String urlString;
    private ObjectMapper mapper;
    public static boolean verbose = false;
    Authenticator passwordAuthenticator;
    private String host;
    private int port;

    public ASConnection(String host, int port, String user, String password) {
        this.host = host;
        this.port = port;
        try {
            this.url = new URL("http", host, port, MANAGEMENT);
            this.urlString = this.url.toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.passwordAuthenticator = new AS7Authenticator(user, password);
        Authenticator.setDefault(this.passwordAuthenticator);
        verbose = Boolean.getBoolean("as7plugin.verbose");
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode executeRaw(Operation operation) {
        Result failure;
        InputStream inputStream = null;
        BufferedReader br = null;
        InputStream es = null;
        HttpURLConnection conn = null;
        long t1 = System.currentTimeMillis();
        try {
            conn = (HttpURLConnection)this.url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Content-Type", "application/json");
            conn.addRequestProperty("Accept", "application/json");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            if (conn.getReadTimeout() != 10000) {
                this.log.warn((Object)"JRE uses a broken timeout mechanism - nothing we can do");
            }
            OutputStream out = conn.getOutputStream();
            String json_to_send = this.mapper.writeValueAsString((Object)operation);
            if (verbose) {
                this.log.info((Object)("Json to send: " + json_to_send));
            }
            this.mapper.writeValue(out, (Object)operation);
            out.flush();
            out.close();
            int responseCode = conn.getResponseCode();
            inputStream = responseCode == 200 ? conn.getInputStream() : conn.getErrorStream();
            if (inputStream != null) {
                String line;
                br = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                JsonNode operationResult = null;
                if (builder.length() > 0) {
                    String outcome = builder.toString();
                    operationResult = this.mapper.readTree(outcome);
                    if (verbose) {
                        ObjectMapper om2 = new ObjectMapper();
                        om2.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                        String tmp = om2.writeValueAsString((Object)operationResult);
                        this.log.info((Object)tmp);
                    }
                } else {
                    String outcome = "- no response from server -";
                    Result noResult = new Result();
                    noResult.setFailureDescription(outcome);
                    noResult.setOutcome("failure");
                    operationResult = this.mapper.valueToTree((Object)noResult);
                }
                JsonNode jsonNode = operationResult;
                return jsonNode;
            }
            this.log.error((Object)("IS was null and code was " + responseCode));
            if (responseCode == 401) {
                throw new InvalidPluginConfigurationException("Credentials for plugin to communicate with are invalid. Update Connection Settings with valid credentials.");
            }
        }
        catch (IllegalArgumentException iae) {
            this.log.error((Object)("Illegal argument " + iae));
            this.log.error((Object)("  for input " + operation));
        }
        catch (SocketTimeoutException ste) {
            JsonNode ret;
            this.log.error((Object)("Request to AS timed out " + ste.getMessage()));
            conn.disconnect();
            failure = new Result();
            failure.setFailureDescription(ste.getMessage());
            failure.setOutcome("failure");
            failure.setRhqThrowable(ste);
            JsonNode line = ret = this.mapper.valueToTree((Object)failure);
            return line;
        }
        catch (IOException e) {
            JsonNode ret;
            this.log.error((Object)("Failed to get data: " + e.getMessage()));
            if (conn != null && (es = conn.getErrorStream()) != null) {
                BufferedReader dr = new BufferedReader(new InputStreamReader(es));
                String ignore = null;
                try {
                    while ((ignore = dr.readLine()) != null) {
                    }
                    es.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            failure = new Result();
            failure.setFailureDescription(e.getMessage());
            failure.setOutcome("failure");
            failure.setRhqThrowable(e);
            JsonNode jsonNode = ret = this.mapper.valueToTree((Object)failure);
            return jsonNode;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
            if (es != null) {
                try {
                    es.close();
                }
                catch (IOException e) {
                    this.log.error((Object)e.getMessage());
                }
            }
            long t2 = System.currentTimeMillis();
            PluginStats stats = PluginStats.getInstance();
            stats.incrementRequestCount();
            stats.addRequestTime(t2 - t1);
        }
        return null;
    }

    public Result execute(Operation op) {
        return this.execute(op, false);
    }

    public ComplexResult executeComplex(Operation op) {
        return (ComplexResult)this.execute(op, true);
    }

    public Result execute(Operation op, boolean isComplex) {
        JsonNode node = this.executeRaw(op);
        if (node == null) {
            this.log.warn((Object)("Operation [" + op + "] returned null"));
            Result failure = new Result();
            failure.setFailureDescription("Operation [" + op + "] returned null");
            return failure;
        }
        try {
            Result res = isComplex ? (Result)this.mapper.readValue(node, ComplexResult.class) : (Result)this.mapper.readValue(node, Result.class);
            return res;
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            return null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

