/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.AbstractBaseDiscovery;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.w3c.dom.Document;

public class BaseProcessDiscovery
extends AbstractBaseDiscovery
implements ResourceDiscoveryComponent,
ManualAddFacet {
    static final String DORG_JBOSS_BOOT_LOG_FILE = "-Dorg.jboss.boot.log.file=";
    private static final String JBOSS_EAP_6 = "JBoss Enterprise Application Platform 6";
    private static final String JBOSS_EDG_6 = "JBoss Enterprise Data Grid 6";
    private static final String JBOSS_EPP_6 = "JBoss Enterprise Portal Platform 6";
    private static final String JBOSS_SOA_6 = "JBoss Service Oriented Architecture Platform 6";
    private static final String AS7 = "AS7";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List scans = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult psr : scans) {
            try {
                String description;
                String serverNameFull;
                String serverName;
                String bootLogFile;
                Configuration config = discoveryContext.getDefaultPluginConfiguration();
                String[] commandLine = psr.getProcessInfo().getCommandLine();
                String psName = psr.getProcessScan().getName();
                String homeDir = this.getHomeDirFromCommandLine(commandLine);
                String version = this.determineServerVersionFromHomeDir(homeDir);
                boolean isEAP = false;
                boolean isEDG = false;
                String logFile = bootLogFile = this.getLogFileFromCommandLine(commandLine);
                if (homeDir.contains("eap")) {
                    isEAP = true;
                }
                if (homeDir.contains("edg")) {
                    isEDG = true;
                }
                if (psName.equals("HostController")) {
                    this.readStandaloneOrHostXml(psr.getProcessInfo(), true);
                    AbstractBaseDiscovery.HostPort hp = this.getDomainControllerFromHostXml();
                    if (hp.isLocal) {
                        serverName = "DomainController";
                        serverNameFull = "DomainController";
                        description = isEAP ? "Domain controller for a JBoss Enterprise Application Platform 6 domain" : "Domain controller for an AS7 domain";
                    } else {
                        serverName = "HostController";
                        serverNameFull = "HostController";
                        description = isEAP ? "Host controller for a JBoss Enterprise Application Platform 6 host" : "Host controller for an AS7 host";
                    }
                    config.put((Property)new PropertySimple("baseDir", (Object)homeDir));
                    config.put((Property)new PropertySimple("startScript", (Object)AS7Mode.DOMAIN.getStartScript()));
                    String host = this.findHost(psr.getProcessInfo(), true);
                    config.put((Property)new PropertySimple("domainHost", (Object)host));
                    this.fillUserPassFromFile(config, AS7Mode.DOMAIN, homeDir);
                    String domainConfig = this.getServerConfigFromCommandLine(commandLine, AS7Mode.DOMAIN);
                    String hostConfig = this.getServerConfigFromCommandLine(commandLine, AS7Mode.HOST);
                    config.put((Property)new PropertySimple("domainConfig", (Object)domainConfig));
                    config.put((Property)new PropertySimple("hostConfig", (Object)hostConfig));
                } else {
                    serverNameFull = homeDir;
                    description = isEAP ? "Standalone JBoss Enterprise Application Platform 6 server" : (isEDG ? "Standalone JBoss Enterprise Data Grid 6 server" : "Standalone AS7 server");
                    this.readStandaloneOrHostXml(psr.getProcessInfo(), false);
                    if (serverNameFull.isEmpty()) {
                        String tmp = this.getLogFileFromCommandLine(commandLine);
                        int i = tmp.indexOf("servers" + File.separator);
                        tmp = tmp.substring(i + 8);
                        serverNameFull = tmp = tmp.substring(0, tmp.indexOf(File.separator));
                    }
                    String host = this.findHost(psr.getProcessInfo(), false);
                    config.put((Property)new PropertySimple("domainHost", (Object)host));
                    config.put((Property)new PropertySimple("baseDir", (Object)serverNameFull));
                    serverName = this.findHostName();
                    if (serverName.isEmpty()) {
                        serverName = serverNameFull;
                    }
                    String serverConfig = this.getServerConfigFromCommandLine(commandLine, AS7Mode.STANDALONE);
                    config.put((Property)new PropertySimple("config", (Object)serverConfig));
                    config.put((Property)new PropertySimple("startScript", (Object)AS7Mode.STANDALONE.getStartScript()));
                    this.fillUserPassFromFile(config, AS7Mode.STANDALONE, serverNameFull);
                    logFile = bootLogFile.substring(0, bootLogFile.lastIndexOf(File.separator)) + File.separator + "server.log";
                }
                if (isEAP) {
                    serverName = "EAP " + serverName;
                    version = "EAP " + version;
                } else if (isEDG) {
                    serverName = "EDG " + serverName;
                    version = "EDG " + version;
                }
                this.initLogEventSourcesConfigProp(logFile, config);
                AbstractBaseDiscovery.HostPort managmentPort = this.getManagementPortFromHostXml(commandLine);
                config.put((Property)new PropertySimple("hostname", (Object)managmentPort.host));
                config.put((Property)new PropertySimple("port", (Object)managmentPort.port));
                config.put((Property)new PropertySimple("realm", (Object)this.getManagementSecurtiyRealmFromHostXml()));
                ProductInfo productInfo = new ProductInfo(managmentPort.host, config.getSimpleValue("user", null), config.getSimpleValue("password", null), managmentPort.port);
                productInfo = productInfo.getFromRemote();
                if (productInfo.fromRemote) {
                    version = productInfo.productName + " " + productInfo.productVersion;
                    serverName = productInfo.productName + " " + productInfo.serverName;
                    String tmp = this.getServerDescr(productInfo.getProductName());
                    description = "Standalone " + tmp + " server";
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), serverNameFull, serverName, version, description, config, psr.getProcessInfo());
                discoveredResources.add(detail);
                this.log.info((Object)("Discovered new ...  " + discoveryContext.getResourceType() + ", " + serverNameFull));
            }
            catch (Exception e) {
                this.log.warn((Object)("Discovery for a " + discoveryContext.getResourceType() + " failed for process " + psr + " :" + e.getMessage()));
            }
        }
        return discoveredResources;
    }

    private String getServerDescr(String productName) {
        if (productName.equals("EAP")) {
            return JBOSS_EAP_6;
        }
        if (productName.equals("EDG")) {
            return JBOSS_EDG_6;
        }
        if (productName.equals("SOA")) {
            return JBOSS_SOA_6;
        }
        if (productName.equals("EPP")) {
            return JBOSS_EPP_6;
        }
        return AS7;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext context) throws InvalidPluginConfigurationException {
        String hostname = pluginConfiguration.getSimpleValue("hostname", null);
        String portS = pluginConfiguration.getSimpleValue("port", null);
        String user = pluginConfiguration.getSimpleValue("user", null);
        String pass = pluginConfiguration.getSimpleValue("password", null);
        if (hostname == null || portS == null) {
            throw new InvalidPluginConfigurationException("Host and port must not be null");
        }
        int port = Integer.valueOf(portS);
        ProductInfo productInfo = new ProductInfo(hostname, user, pass, port).getFromRemote();
        String productName = productInfo.getProductName();
        String productVersion = productInfo.getProductVersion();
        String resourceKey = hostname + ":" + portS + ":" + productName;
        String description = productName.contains("EAP") ? "Standalone JBoss Enterprise Application Platform server" : (productName.contains("EDG") ? "Standalone JBoss Enterprise DataGrid server" : context.getResourceType().getDescription());
        pluginConfiguration.put((Property)new PropertySimple("manuallyAdded", (Object)true));
        DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, productName + " @ " + hostname + ":" + port, productVersion, description, pluginConfiguration, null);
        return detail;
    }

    private String getServerAttribute(ASConnection connection, String attributeName) {
        ReadAttribute op = new ReadAttribute(null, attributeName);
        Result res = connection.execute(op);
        if (!res.isSuccess()) {
            throw new InvalidPluginConfigurationException("Could not connect to remote server [" + res.getFailureDescription() + "]. Did you enable management?");
        }
        return (String)res.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillUserPassFromFile(Configuration config, AS7Mode mode, String baseDir) {
        String realm = this.getManagementSecurtiyRealmFromHostXml();
        String fileName = this.getSecurityPropertyFileFromHostXml(baseDir, mode, realm);
        File file = new File(fileName);
        if (!file.exists() || !file.canRead()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No console user properties file found at [" + file.getAbsolutePath() + "] or file is not readable"));
            }
            return;
        }
        BufferedReader br = null;
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            br = new BufferedReader(fileReader);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty() || !line.contains("=")) continue;
                String user = line.substring(0, line.indexOf("="));
                String pass = line.substring(line.indexOf("=") + 1);
                config.put((Property)new PropertySimple("user", (Object)user));
            }
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findHost(ProcessInfo processInfo, boolean isDomain) {
        String hostXmlFile = this.getHostXmlFileLocation(processInfo, isDomain);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String hostName = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream is = new FileInputStream(hostXmlFile);
            try {
                Document document = builder.parse(is);
                hostName = document.getDocumentElement().getAttribute("name");
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        if (hostName == null) {
            hostName = "local";
        }
        return hostName;
    }

    String getServerConfigFromCommandLine(String[] commandLine, AS7Mode mode) {
        String configArg = mode.getConfigArg();
        for (String line : commandLine) {
            if (!line.startsWith(configArg)) continue;
            return line.substring(configArg.length() + 1);
        }
        return mode.getDefaultXmlFile();
    }

    @Override
    String getLogFileFromCommandLine(String[] commandLine) {
        for (String line : commandLine) {
            if (!line.startsWith(DORG_JBOSS_BOOT_LOG_FILE)) continue;
            return line.substring(DORG_JBOSS_BOOT_LOG_FILE.length());
        }
        return "";
    }

    private void initLogEventSourcesConfigProp(String fileName, Configuration pluginConfiguration) {
        PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
        if (logEventSources == null) {
            return;
        }
        File serverLogFile = new File(fileName);
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    private class ProductInfo {
        private String hostname;
        private String user;
        private String pass;
        private int port;
        private String productVersion;
        private String productName;
        private String releaseVersion;
        private String releaseCodeName;
        private boolean fromRemote = false;
        private String serverName;

        public ProductInfo(String hostname, String user, String pass, int port) {
            this.hostname = hostname;
            this.user = user;
            this.pass = pass;
            this.port = port;
        }

        public String getProductVersion() {
            return this.productVersion;
        }

        public String getProductName() {
            return this.productName;
        }

        public ProductInfo getFromRemote() {
            ASConnection connection = new ASConnection(this.hostname, this.port, this.user, this.pass);
            try {
                this.productVersion = BaseProcessDiscovery.this.getServerAttribute(connection, "product-version");
                this.productName = BaseProcessDiscovery.this.getServerAttribute(connection, "product-name");
                this.releaseVersion = BaseProcessDiscovery.this.getServerAttribute(connection, "release-version");
                this.releaseCodeName = BaseProcessDiscovery.this.getServerAttribute(connection, "release-codename");
                this.serverName = BaseProcessDiscovery.this.getServerAttribute(connection, "name");
                if (this.productVersion == null) {
                    this.productVersion = this.releaseVersion;
                }
                if (this.productName == null) {
                    this.productName = BaseProcessDiscovery.AS7;
                }
                this.fromRemote = true;
            }
            catch (InvalidPluginConfigurationException e) {
                BaseProcessDiscovery.this.log.debug((Object)("Could not get the product info from [" + this.hostname + ":" + this.port + "] - probably a connection failure"));
            }
            return this;
        }

        public String toString() {
            return "ProductInfo{hostname='" + this.hostname + '\'' + ", port=" + this.port + ", productVersion='" + this.productVersion + '\'' + ", productName='" + this.productName + '\'' + ", releaseVersion='" + this.releaseVersion + '\'' + ", releaseCodeName='" + this.releaseCodeName + '\'' + ", fromRemote=" + this.fromRemote + '}';
        }
    }
}

