/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.Remove;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class ConfigurationWriteDelegate
implements ConfigurationFacet {
    final Log log = LogFactory.getLog(this.getClass());
    private Address _address;
    private ASConnection connection;
    private ConfigurationDefinition configurationDefinition;
    private String namePropLocator;
    private String type;
    private boolean addNewChildren;
    private boolean addDeleteModifiedChildren;

    public ConfigurationWriteDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        this.configurationDefinition = configDef;
        this.connection = connection;
        this._address = address;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        throw new IllegalAccessException("Please use ConfigurationLoadDelegate");
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration conf = report.getConfiguration();
        CompositeOperation cop = this.updateGenerateOperationFromProperties(conf, this._address);
        Result result = this.connection.execute(cop);
        if (!result.isSuccess()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(result.getFailureDescription());
        } else {
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
    }

    protected CompositeOperation updateGenerateOperationFromProperties(Configuration conf, Address address) {
        CompositeOperation cop = new CompositeOperation();
        for (PropertyDefinition propDef : this.configurationDefinition.getNonGroupedProperties()) {
            this.updateProperty(conf, cop, propDef, address);
        }
        for (PropertyGroupDefinition pgd : this.configurationDefinition.getGroupDefinitions()) {
            String groupName = pgd.getName();
            this.namePropLocator = null;
            if (groupName.startsWith("children:")) {
                this.type = groupName.substring("children:".length());
                if (this.type.contains(":")) {
                    this.namePropLocator = this.type.substring(this.type.indexOf(":") + 1);
                    if (this.namePropLocator.endsWith("+")) {
                        this.namePropLocator = this.namePropLocator.substring(0, this.namePropLocator.length() - 1);
                        this.addNewChildren = true;
                    } else if (this.namePropLocator.endsWith("+-")) {
                        this.namePropLocator = this.namePropLocator.substring(0, this.namePropLocator.length() - 2);
                        this.addNewChildren = true;
                        this.addDeleteModifiedChildren = true;
                    } else {
                        this.addNewChildren = false;
                    }
                } else {
                    this.log.error((Object)("Group name " + groupName + " contains no property name locator "));
                    return cop;
                }
                this.type = this.type.substring(0, this.type.indexOf(":"));
                List definitions = this.configurationDefinition.getPropertiesInGroup(groupName);
                for (PropertyDefinition def : definitions) {
                    this.updateProperty(conf, cop, def, address);
                }
            }
            if (!groupName.startsWith("child:")) continue;
            String subPath = groupName.substring("child:".length());
            if (!subPath.contains("=")) {
                throw new IllegalArgumentException("subPath of 'child:' expression has no =");
            }
            Address address1 = new Address(address);
            address1.addSegment(subPath);
            List definitions = this.configurationDefinition.getPropertiesInGroup(groupName);
            for (PropertyDefinition def : definitions) {
                this.updateProperty(conf, cop, def, address1);
            }
        }
        return cop;
    }

    private void updateProperty(Configuration conf, CompositeOperation cop, PropertyDefinition propDef, Address baseAddress) {
        if (propDef.isReadOnly()) {
            return;
        }
        String propDefName = propDef.getName();
        if (propDef instanceof PropertyDefinitionList && propDefName.startsWith("*")) {
            ReadChildrenResources op;
            Result tmp;
            propDef = ((PropertyDefinitionList)propDef).getMemberDefinition();
            PropertyList pl = (PropertyList)conf.get(propDefName);
            ArrayList<String> existingPropnames = new ArrayList<String>();
            if (this.addNewChildren && (tmp = this.connection.execute(op = new ReadChildrenResources(baseAddress, this.type))).isSuccess()) {
                Map tmpResMap = (Map)tmp.getResult();
                existingPropnames.addAll(tmpResMap.keySet());
            }
            for (Property prop2 : pl.getList()) {
                this.updateHandlePropertyMapSpecial(cop, (PropertyMap)prop2, (PropertyDefinitionMap)propDef, baseAddress, existingPropnames);
            }
            for (String existingName : existingPropnames) {
                boolean found = false;
                for (Property prop2 : pl.getList()) {
                    PropertyMap propMap2 = (PropertyMap)prop2;
                    String itemName = propMap2.getSimple(this.namePropLocator).getStringValue();
                    if (itemName == null) {
                        throw new IllegalArgumentException("Map contains no entry with name '" + this.namePropLocator + "'");
                    }
                    if (!itemName.equals(existingName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Address tmpAddr = new Address(baseAddress);
                tmpAddr.add(this.type, existingName);
                Operation operation = new Operation("remove", tmpAddr);
                cop.addStep(operation);
            }
        } else {
            Property prop = conf.get(propDefName);
            if (prop instanceof PropertySimple) {
                this.updateHandlePropertySimple(cop, (PropertySimple)prop, (PropertyDefinitionSimple)propDef, baseAddress);
            } else if (prop instanceof PropertyList) {
                this.updateHandlePropertyList(cop, (PropertyList)prop, (PropertyDefinitionList)propDef, baseAddress);
            } else {
                this.updateHandlePropertyMap(cop, (PropertyMap)prop, (PropertyDefinitionMap)propDef, baseAddress);
            }
        }
    }

    private void updateHandlePropertyMap(CompositeOperation cop, PropertyMap prop, PropertyDefinitionMap propDef, Address address) {
        Map<String, Object> results = this.updateHandleMap(prop, propDef, address);
        WriteAttribute writeAttribute = new WriteAttribute(address, prop.getName(), results);
        cop.addStep(writeAttribute);
    }

    private void updateHandlePropertyMapSpecial(CompositeOperation cop, PropertyMap prop, PropertyDefinitionMap propDef, Address address, List<String> existingPropNames) {
        Map<String, Object> results = this.updateHandleMap(prop, propDef, address);
        if (prop.get(this.namePropLocator) == null) {
            throw new IllegalArgumentException("There is no element in the map with the name " + this.namePropLocator);
        }
        String key = ((PropertySimple)prop.get(this.namePropLocator)).getStringValue();
        Address addr = new Address(address);
        addr.add(this.type, key);
        for (Map.Entry<String, Object> entry : results.entrySet()) {
            Operation operation;
            if (entry.getValue().equals(key)) continue;
            if (!this.addNewChildren || existingPropNames.contains(key)) {
                if (this.addDeleteModifiedChildren) {
                    operation = new Remove(addr);
                    cop.addStep(operation);
                    operation = new Operation("add", addr);
                    operation.addAdditionalProperty("name", key);
                    operation.addAdditionalProperty("value", entry.getValue());
                } else {
                    operation = new WriteAttribute(addr, entry.getKey(), entry.getValue());
                }
            } else {
                operation = new Operation("add", addr);
                operation.addAdditionalProperty("name", key);
                operation.addAdditionalProperty("value", entry.getValue());
            }
            cop.addStep(operation);
        }
    }

    private void updateHandlePropertyList(CompositeOperation cop, PropertyList prop, PropertyDefinitionList propDef, Address address) {
        PropertyDefinition memberDef = propDef.getMemberDefinition();
        List embeddedProps = prop.getList();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Property inner : embeddedProps) {
            PropertySimple ps;
            if (memberDef instanceof PropertyDefinitionSimple && (ps = (PropertySimple)inner).getStringValue() != null) {
                values.add(ps.getStringValue());
            }
            if (!(memberDef instanceof PropertyDefinitionMap)) continue;
            Map<String, Object> mapResult = this.updateHandleMap((PropertyMap)inner, (PropertyDefinitionMap)memberDef, address);
            values.add(mapResult);
        }
        WriteAttribute writeAttribute = new WriteAttribute(address, prop.getName(), values);
        cop.addStep(writeAttribute);
    }

    private void updateHandlePropertySimple(CompositeOperation cop, PropertySimple propertySimple, PropertyDefinitionSimple propDef, Address address) {
        if (propertySimple.getStringValue() == null && !propDef.isRequired()) {
            return;
        }
        WriteAttribute writeAttribute = new WriteAttribute(address, propertySimple.getName(), (Object)propertySimple.getStringValue());
        cop.addStep(writeAttribute);
    }

    private Map<String, Object> updateHandleMap(PropertyMap map, PropertyDefinitionMap mapDef, Address address) {
        Map memberDefinitions = mapDef.getPropertyDefinitions();
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String name : memberDefinitions.keySet()) {
            PropertyDefinition memberDefinition = (PropertyDefinition)memberDefinitions.get(name);
            if (memberDefinition.isReadOnly()) continue;
            if (memberDefinition instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)memberDefinition;
                PropertySimple ps = (PropertySimple)map.get(name);
                if ((ps == null || ps.getStringValue() == null) && !pds.isRequired() || ps == null) continue;
                results.put(name, ps.getStringValue());
                continue;
            }
            this.log.error((Object)(" *** not yet supported *** : " + memberDefinition.getName()));
        }
        return results;
    }
}

