/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;

public class Domain2Descriptor {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Domain2Descriptor.usage();
            System.exit(1);
        }
        Domain2Descriptor d2d = new Domain2Descriptor();
        d2d.run(args);
    }

    private void run(String[] args) {
        Map attributesMap;
        ComplexResult res;
        String arg;
        D2DMode mode = null;
        String user = null;
        String pass = null;
        int pos = 0;
        boolean optionFound = false;
        do {
            if ((arg = args[pos]).startsWith("-")) {
                if (arg.equals("-m")) {
                    mode = D2DMode.METRICS;
                } else if (arg.equals("-p")) {
                    mode = D2DMode.PROPERTIES;
                } else if (arg.equals("-o")) {
                    mode = D2DMode.OPERATION;
                } else if (arg.startsWith("-U")) {
                    String tmp = arg.substring(2);
                    if (!tmp.contains(":")) {
                        Domain2Descriptor.usage();
                    }
                    user = tmp.substring(0, tmp.indexOf(":"));
                    pass = tmp.substring(tmp.indexOf(":") + 1);
                } else {
                    Domain2Descriptor.usage();
                    return;
                }
                ++pos;
                optionFound = true;
                continue;
            }
            optionFound = false;
        } while (optionFound);
        String path = arg;
        path = path.replaceAll("/", ",");
        String childType = null;
        if (args.length > pos + 1) {
            childType = args[pos + 1];
        }
        ASConnection conn = new ASConnection("localhost", 9990, user, pass);
        Address address = new Address(path);
        Operation op = new Operation("read-resource-description", address);
        op.addAdditionalProperty("recursive", "true");
        if (mode == D2DMode.OPERATION) {
            op.addAdditionalProperty("operations", true);
        }
        if (mode == D2DMode.METRICS) {
            op.addAdditionalProperty("include-runtime", true);
        }
        if ((res = conn.executeComplex(op)) == null) {
            System.err.println("Got no result");
            return;
        }
        if (!res.isSuccess()) {
            System.err.println("Failure: " + res.getFailureDescription());
            return;
        }
        Object resMap = res.getResult();
        String what = mode == D2DMode.OPERATION ? "operations" : "attributes";
        if (childType != null) {
            Map childMap = (Map)resMap.get("children");
            Map typeMap = (Map)childMap.get(childType);
            Map descriptionMap = (Map)typeMap.get("model-description");
            if (descriptionMap == null) {
                System.err.println("No model description found");
                return;
            }
            Map starMap = (Map)descriptionMap.get("*");
            attributesMap = (Map)starMap.get(what);
        } else {
            attributesMap = (Map)resMap.get(what);
        }
        if (mode == D2DMode.OPERATION) {
            for (Map.Entry entry : attributesMap.entrySet()) {
                if (((String)entry.getKey()).startsWith("read-") || ((String)entry.getKey()).equals("write-attribute")) continue;
                this.createOperation((String)entry.getKey(), (Map)entry.getValue());
            }
        } else {
            this.createProperties(mode, attributesMap, 0);
        }
    }

    private void createProperties(D2DMode mode, Map<String, Object> attributesMap, int indent) {
        if (attributesMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
            StringBuilder sb;
            Map props = (Map)entry.getValue();
            String entryName = entry.getKey();
            Type ptype = this.getTypeFromProps(props);
            String typeString = this.getTypeStringForTypeAndName(ptype, entryName);
            if (ptype == Type.OBJECT) {
                System.out.println("<c:map-property name=\"" + entryName + "\" description=\"" + props.get("description") + "\" >");
                Map attributesMap1 = (Map)props.get("attributes");
                if (attributesMap1 != null) {
                    this.createProperties(mode, attributesMap1, indent + 4);
                } else {
                    for (Map.Entry emapEntry : props.entrySet()) {
                        String key = (String)emapEntry.getKey();
                        if (key.equals("type") || key.equals("description") || key.equals("required")) continue;
                        if (emapEntry.getValue() instanceof Map) {
                            Map emapEntryValue = (Map)emapEntry.getValue();
                            String ts = this.getTypeStringForTypeAndName(this.getTypeFromProps(emapEntryValue), key);
                            StringBuilder sb2 = this.generateProperty(indent, emapEntryValue, ts, (String)emapEntry.getKey(), this.getAccessType(emapEntryValue));
                            System.out.println(sb2.toString());
                            continue;
                        }
                        System.out.println(emapEntry.getValue());
                    }
                }
                System.out.println("</c:map-property>");
                continue;
            }
            if (ptype == Type.LIST && mode != D2DMode.METRICS) {
                StringBuilder sb3 = new StringBuilder("<c:list-property name=\"");
                sb3.append(entryName);
                sb3.append("\"");
                String description = (String)props.get("description");
                this.appendDescription(sb3, description);
                sb3.append(" >\n");
                if (!props.containsKey("attributes")) {
                    sb3.append("    <c:simple-property name=\"").append(entryName).append("\" />\n");
                } else {
                    this.doIndent(indent, sb3);
                    sb3.append("<c:map-property name=\"").append(entryName).append("\">\n");
                    System.out.println(sb3.toString());
                    this.createProperties(mode, (Map)props.get("attributes"), indent + 4);
                    sb3 = new StringBuilder();
                    this.doIndent(indent, sb3);
                    sb3.append("</c:map-property>\n");
                }
                sb3.append("</c:list-property>");
                System.out.println(sb3.toString());
                continue;
            }
            String accessType = this.getAccessType(props);
            if (mode == D2DMode.METRICS) {
                if (!accessType.equals("metric")) continue;
                sb = new StringBuilder();
                this.doIndent(indent, sb);
                sb.append("<metric property=\"");
                sb.append(entryName).append('\"');
                if (ptype == Type.STRING) {
                    sb.append(" dataType=\"trait\"");
                }
                String description = (String)props.get("description");
                this.appendDescription(sb, description);
                sb.append("/>");
                System.out.println(sb.toString());
                continue;
            }
            if (accessType.equals("metric")) continue;
            sb = this.generateProperty(indent, props, typeString, entryName, accessType);
            System.out.println(sb.toString());
        }
    }

    private void createOperation(String name, Map<String, Object> operationMap) {
        Map replyMap;
        if (operationMap == null) {
            return;
        }
        StringBuilder builder = new StringBuilder("<operation name=\"");
        builder.append(name).append('\"');
        String description = (String)operationMap.get("description");
        this.appendDescription(builder, description);
        builder.append(">\n");
        Map reqMap = (Map)operationMap.get("request-properties");
        if (reqMap != null && !reqMap.isEmpty()) {
            builder.append("  <parameters>\n");
            this.generatePropertiesForMap(builder, reqMap, true);
            builder.append("  </parameters>\n");
        }
        if ((replyMap = (Map)operationMap.get("reply-properties")) != null && !replyMap.isEmpty()) {
            builder.append("  <results>\n");
            this.generatePropertiesForMap(builder, replyMap, true);
            builder.append("  </results>\n");
        }
        builder.append("</operation>\n");
        System.out.println(builder.toString());
    }

    private void appendDescription(StringBuilder builder, String description) {
        if (description != null && !description.isEmpty()) {
            if (builder.length() > 120) {
                builder.append("\n        ");
            }
            builder.append(" description=\"");
            description = description.replace("<", "&lt;");
            description = description.replace(">", "&gt;");
            description = description.replace("\"", "'");
            builder.append(description);
            builder.append('\"');
        }
    }

    private void generatePropertiesForMap(StringBuilder builder, Map<String, Object> map, boolean forceReadWrite) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map entryValue = (Map)entry.getValue();
            String entryKey = entry.getKey();
            Type type = this.getTypeFromProps(entryValue);
            String typeString = this.getTypeStringForTypeAndName(type, entryKey);
            builder.append((CharSequence)this.generateProperty(4, entryValue, typeString, entryKey, null));
            builder.append('\n');
        }
    }

    private String getAccessType(Map<String, Object> props) {
        String accessType = (String)props.get("access-type");
        if (accessType == null) {
            accessType = "read-only";
        }
        return accessType;
    }

    private String getTypeStringForTypeAndName(Type ptype, String entryName) {
        String typeString;
        switch (ptype) {
            case INT: {
                typeString = "integer";
                break;
            }
            case STRING: {
                typeString = "string";
                break;
            }
            case BOOLEAN: {
                typeString = "boolean";
                break;
            }
            case LONG: {
                typeString = "long";
                break;
            }
            case BIG_DECIMAL: {
                typeString = "long";
                break;
            }
            case DOUBLE: {
                typeString = "long";
                break;
            }
            case LIST: {
                typeString = "-list-";
                break;
            }
            case OBJECT: {
                typeString = "-object-";
                break;
            }
            default: {
                typeString = "- unknown -";
                System.err.println("Unknown type " + (Object)((Object)ptype) + " for " + entryName);
            }
        }
        return typeString;
    }

    private StringBuilder generateProperty(int indent, Map<String, Object> props, String typeString, String entryName, String accessType) {
        StringBuilder sb = new StringBuilder();
        this.doIndent(indent, sb);
        sb.append("<c:simple-property name=\"");
        sb.append(entryName).append('\"');
        Object required = props.get("required");
        if (required != null && ((Boolean)required).booleanValue()) {
            sb.append(" required=\"true\"");
        } else {
            sb.append(" required=\"false\"");
        }
        sb.append(" type=\"").append(typeString).append("\"");
        sb.append(" readOnly=\"");
        if (accessType != null && accessType.equals("read-only")) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append('\"');
        Object defVal = props.get("default");
        if (defVal != null) {
            sb.append(" defaultValue=\"").append(defVal).append('\"');
        }
        String description = (String)props.get("description");
        this.appendDescription(sb, description);
        sb.append("/>");
        return sb;
    }

    private void doIndent(int indent, StringBuilder sb) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    private Type getTypeFromProps(Map<String, Object> props) {
        Map tMap = (Map)props.get("type");
        if (tMap == null) {
            return Type.OBJECT;
        }
        String type = (String)tMap.get("TYPE_MODEL_VALUE");
        Type ret = Type.valueOf(type);
        return ret;
    }

    public List<PROPERTY_VALUE> pathToAddress(String path) {
        String[] components;
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PROPERTY_VALUE> result = new ArrayList<PROPERTY_VALUE>();
        for (String component : components = path.split(",")) {
            String tmp = component.trim();
            if (!tmp.contains("=")) continue;
            if (tmp.startsWith("/")) {
                tmp = tmp.substring(1);
            }
            String[] pair = tmp.split("=");
            PROPERTY_VALUE valuePair = new PROPERTY_VALUE(pair[0], pair[1]);
            result.add(valuePair);
        }
        return result;
    }

    private static void usage() {
        System.out.println("Domain2Properties [-p|-m|-o] path type");
        System.out.println("   path is of kind 'key=value[,key=value]+");
        System.out.println(" -p create properties (default)");
        System.out.println(" -m create metrics");
        System.out.println(" -o create operations");
        System.out.println(" -U<user>:<pass>  - supply credentials to talk to AS7");
    }

    private static enum D2DMode {
        METRICS,
        PROPERTIES,
        OPERATION;

    }

    public static enum Type {
        STRING,
        INT,
        BOOLEAN,
        LONG,
        BIG_DECIMAL,
        OBJECT,
        LIST,
        DOUBLE;

    }
}

