/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.AbstractBaseDiscovery;
import org.rhq.modules.plugins.jbossas7.HostControllerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ManagedASDiscovery
extends AbstractBaseDiscovery
implements ResourceDiscoveryComponent {
    private HostControllerComponent parentComponent;

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        this.parentComponent = (HostControllerComponent)discoveryContext.getParentResourceComponent();
        Configuration hcConfig = this.parentComponent.getHCConfig();
        String hostName = hcConfig.getSimpleValue("domainHost", "master");
        HostInfo hostInfo = this.getHostInfo(hostName);
        if (hostInfo == null) {
            return discoveredResources;
        }
        try {
            List<ServerInfo> serverNames = this.getManagedServers(hostName);
            for (ServerInfo serverInfo : serverNames) {
                String resourceDescription;
                String version;
                Configuration config = discoveryContext.getDefaultPluginConfiguration();
                config.put((Property)new PropertySimple("domainHost", (Object)hostName));
                config.put((Property)new PropertySimple("group", (Object)serverInfo.group));
                if (serverInfo.bindingGroup != null) {
                    config.put((Property)new PropertySimple("socket-binding-group", (Object)serverInfo.bindingGroup));
                } else {
                    String group = this.resolveSocketBindingGroup(serverInfo.group);
                    config.put((Property)new PropertySimple("socket-binding-group", (Object)group));
                }
                config.put((Property)new PropertySimple("socket-binding-port-offset", (Object)serverInfo.portOffset));
                String path = "host=" + hostName + ",server-config=" + serverInfo.name;
                config.put((Property)new PropertySimple("path", (Object)path));
                String serverLog = hcConfig.getSimpleValue("baseDir", "/tmp") + File.separator + "domain/servers/" + serverInfo.name + "/log/server.log";
                this.initLogEventSourcesConfigProp(serverLog, config);
                String resourceName = serverInfo.name;
                if (hostInfo.productName.equalsIgnoreCase("eap")) {
                    version = "EAP " + hostInfo.productVersion;
                    resourceDescription = "Managed JBoss Enterprise Application Platform 6 server";
                    resourceName = "EAP " + resourceName;
                } else if (hostInfo.productName.equalsIgnoreCase("EDG")) {
                    version = "EDG " + hostInfo.productVersion;
                    resourceDescription = "Managed JBoss Enterprise Data Grid 6 server";
                } else {
                    resourceDescription = "Managed AS7 server";
                    version = hostInfo.releaseVersion;
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), hostName + "/" + serverInfo.name, resourceName, version, resourceDescription, config, null);
                discoveredResources.add(detail);
                this.log.info((Object)("Discovered new ...  " + discoveryContext.getResourceType() + ", " + serverInfo));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Discovery for a " + discoveryContext.getResourceType() + " failed for process " + " :" + e.getMessage()));
        }
        return discoveredResources;
    }

    private String resolveSocketBindingGroup(String serverGroup) {
        Address address = new Address("server-group", serverGroup);
        ReadAttribute operation = new ReadAttribute(address, "socket-binding-group");
        Result result = this.parentComponent.getASConnection().execute(operation);
        return (String)result.getResult();
    }

    private List<ServerInfo> getManagedServers(String domainHost) {
        Address address = new Address("host", domainHost);
        Operation operation = new ReadChildrenNames(address, "server-config");
        ASConnection connection = this.parentComponent.getASConnection();
        Result res = connection.execute(operation);
        List servers = (List)res.getResult();
        ArrayList<ServerInfo> ret = new ArrayList<ServerInfo>(servers.size());
        for (String server : servers) {
            ServerInfo info = new ServerInfo();
            info.name = server;
            ret.add(info);
            address = new Address("host", domainHost);
            address.add("server-config", server);
            operation = new ReadResource(address);
            ComplexResult cres = connection.executeComplex(operation);
            Object map = cres.getResult();
            info.group = (String)map.get("group");
            info.autoStart = (Boolean)map.get("auto-start");
            Integer offset = (Integer)map.get("socket-binding-port-offset");
            if (offset != null) {
                info.portOffset = offset;
            }
            info.bindingGroup = (String)map.get("socket-binding-group");
        }
        return ret;
    }

    private HostInfo getHostInfo(String domainHost) {
        Address address = new Address("host", domainHost);
        ReadResource operation = new ReadResource(address);
        HostInfo info = new HostInfo();
        ComplexResult cres = this.parentComponent.getASConnection().executeComplex(operation);
        if (!cres.isSuccess()) {
            return null;
        }
        Object map = cres.getResult();
        info.releaseCodeName = (String)map.get("release-codename");
        info.releaseVersion = (String)map.get("release-version");
        info.productName = (String)map.get("product-name");
        info.productVersion = (String)map.get("product-version");
        return info;
    }

    private void initLogEventSourcesConfigProp(String fileName, Configuration pluginConfiguration) {
        PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
        if (logEventSources == null) {
            return;
        }
        File serverLogFile = new File(fileName);
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    private static class HostInfo {
        String name;
        String productVersion;
        String releaseVersion;
        String productName;
        String releaseCodeName;

        private HostInfo() {
        }
    }

    private static class ServerInfo {
        String name;
        String group;
        boolean autoStart;
        int portOffset;
        String bindingGroup;

        private ServerInfo() {
        }

        public String toString() {
            return "ServerInfo{name='" + this.name + '\'' + ", group='" + this.group + '\'' + '}';
        }
    }
}

