/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ASConnection {
    public static final String HTTP_SCHEME = "http";
    public static final String MANAGEMENT_URI = "/management";
    public static boolean verbose = Boolean.getBoolean("as7plugin.verbose");
    @Deprecated
    public static final String MANAGEMENT = "/management";
    static final String FAILURE_NO_RESPONSE = "The server closed the connection before sending the response";
    private static final Log LOG = LogFactory.getLog(ASConnection.class);
    private static final int MAX_POOLED_CONNECTIONS = 10;
    private static final int DEFAULT_KEEPALIVE_TIMEOUT = 5000;
    private static final String ACCEPT_HTTP_HEADER = "Accept";
    private static final String JSON_NODE_FAILURE_DESCRIPTION = "failure-description";
    private static final ScheduledExecutorService cleanerExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        private AtomicInteger threadCounter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultThreadFactory.newThread(runnable);
            thread.setName("ASConnection Cleaner-" + this.threadCounter.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    });
    private String scheme = "http";
    private String host;
    private int port;
    private UsernamePasswordCredentials credentials;
    private long keepAliveTimeout;
    private String managementUrl;
    private DefaultHttpClient httpClient;
    private ObjectMapper mapper;

    public ASConnection(String host, int port, String user, String password) {
        this(host, port, user, password, null);
    }

    public ASConnection(String host, int port, String user, String password, Long managementConnectionTimeout) {
        if (host == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this.host = host;
        this.port = port;
        if (user != null && password != null) {
            this.credentials = new UsernamePasswordCredentials(user, password);
        }
        this.managementUrl = this.scheme + "://" + host + ":" + port + "/management";
        PoolingClientConnectionManager httpConnectionManager = new PoolingClientConnectionManager();
        httpConnectionManager.setDefaultMaxPerRoute(10);
        httpConnectionManager.setMaxTotal(10);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager);
        HttpParams httpParams = this.httpClient.getParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpParams, (boolean)false);
        this.keepAliveTimeout = managementConnectionTimeout == null ? 5000L : managementConnectionTimeout;
        this.httpClient.setReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(){

            public boolean keepAlive(HttpResponse response, HttpContext context) {
                return ASConnection.this.keepAliveTimeout > 0L && super.keepAlive(response, context);
            }
        });
        if (this.keepAliveTimeout > 0L) {
            this.httpClient.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    if (duration < 0L || duration > ASConnection.this.keepAliveTimeout) {
                        duration = ASConnection.this.keepAliveTimeout;
                    }
                    if (duration < ASConnection.this.keepAliveTimeout) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)(ASConnection.this.host + ":" + ASConnection.this.port + " declares a keep alive timeout value of [" + duration + "] ms. Will now use this value instead of the value from configuration [" + ASConnection.this.keepAliveTimeout + "] ms."));
                        }
                        ASConnection.this.keepAliveTimeout = duration;
                    }
                    return duration;
                }
            });
            cleanerExecutor.schedule(new ConnectionManagerCleaner(this), this.keepAliveTimeout / 2L, TimeUnit.MILLISECONDS);
        }
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)false);
        if (this.credentials != null) {
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)this.credentials);
        }
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static ASConnection newInstanceForServerPluginConfiguration(ServerPluginConfiguration serverPluginConfig) {
        return new ASConnection(serverPluginConfig.getHostname(), serverPluginConfig.getPort(), serverPluginConfig.getUser(), serverPluginConfig.getPassword(), serverPluginConfig.getManagementConnectionTimeout());
    }

    protected void finalize() throws Throwable {
        this.httpClient.getConnectionManager().shutdown();
    }

    public JsonNode executeRaw(Operation operation) {
        return this.executeRaw(operation, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode executeRaw(Operation operation, int timeoutSec) {
        long requestStartTime = System.currentTimeMillis();
        if (operation != null && operation.getAddress() != null && operation.getAddress().getPath() != null && this.containsSpaces(operation.getAddress().getPath())) {
            Result noResult = new Result();
            String outcome = "- Path '" + operation.getAddress().getPath() + "' is invalid as it contains spaces -";
            if (verbose) {
                LOG.error((Object)outcome);
            }
            noResult.setFailureDescription(outcome);
            noResult.setOutcome("failure");
            JsonNode invalidPathResult = this.mapper.valueToTree((Object)noResult);
            return invalidPathResult;
        }
        HttpPost httpRequest = new HttpPost(this.managementUrl);
        httpRequest.addHeader(ACCEPT_HTTP_HEADER, ContentType.APPLICATION_JSON.getMimeType());
        HttpParams httpParams = this.httpClient.getParams();
        int timeoutMillis = timeoutSec * 1000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeoutMillis);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutMillis);
        try {
            Result noResult;
            JsonNode operationResult;
            HttpEntity httpResponseEntity;
            String responseBody;
            String jsonToSend = this.mapper.writeValueAsString((Object)operation);
            if (verbose) {
                LOG.info((Object)("JSON to send: " + jsonToSend));
            }
            httpRequest.setEntity((HttpEntity)new StringEntity(jsonToSend, ContentType.APPLICATION_JSON));
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (this.isAuthorizationFailureResponse(statusLine)) {
                this.handleAuthorizationFailureResponse(operation, statusLine);
            }
            String string = responseBody = (httpResponseEntity = httpResponse.getEntity()) == null ? "" : EntityUtils.toString((HttpEntity)httpResponseEntity);
            if (statusLine.getStatusCode() >= 400) {
                if (verbose) {
                    LOG.debug((Object)(operation + " failed with " + ASConnection.statusAsString(statusLine) + " - response body was [" + responseBody + "]."));
                }
                if (responseBody.contains("JBAS014807") || responseBody.contains("JBAS010850") || responseBody.contains("JBAS014792") || responseBody.contains("JBAS014793")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Requested management resource not found: " + operation.getAddress().getPath()));
                    }
                } else {
                    LOG.warn((Object)("Received " + ASConnection.statusAsString(statusLine) + " response to " + operation + " - response body was [" + responseBody + "]."));
                }
            }
            if (!responseBody.isEmpty()) {
                try {
                    operationResult = this.mapper.readTree(responseBody);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Failed to deserialize response to " + operation + " to JsonNode - response status was " + ASConnection.statusAsString(statusLine) + ", and body was [" + responseBody + "]: " + ioe));
                    Result result = new Result();
                    result.setOutcome("failure");
                    result.setFailureDescription("Failed to deserialize response to " + operation + " to JsonNode - response status was " + ASConnection.statusAsString(statusLine) + ", and body was [" + responseBody + "]: " + ioe);
                    result.setRolledBack(responseBody.contains("rolled-back=true"));
                    result.setRhqThrowable(ioe);
                    operationResult = this.mapper.valueToTree((Object)result);
                }
                if (verbose) {
                    ObjectMapper om2 = new ObjectMapper();
                    om2.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                    try {
                        String resultString = om2.writeValueAsString((Object)operationResult);
                        LOG.info((Object)resultString);
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)("Failed to convert result of " + operation + " to string."), (Throwable)ioe);
                    }
                }
            } else {
                noResult = new Result();
                noResult.setOutcome("failure");
                noResult.setFailureDescription("- empty response body with HTTP status code " + ASConnection.statusAsString(statusLine) + " -");
                operationResult = this.mapper.valueToTree((Object)noResult);
            }
            noResult = operationResult;
            return noResult;
        }
        catch (NoHttpResponseException e) {
            JsonNode ret;
            Result failure = new Result();
            failure.setFailureDescription(FAILURE_NO_RESPONSE);
            failure.setOutcome("failure");
            failure.setRhqThrowable(e);
            JsonNode jsonNode = ret = this.mapper.valueToTree((Object)failure);
            return jsonNode;
        }
        catch (IOException e) {
            JsonNode ret;
            Result failure = new Result();
            failure.setFailureDescription(e.getMessage());
            failure.setOutcome("failure");
            failure.setRhqThrowable(e);
            JsonNode jsonNode = ret = this.mapper.valueToTree((Object)failure);
            return jsonNode;
        }
        finally {
            httpRequest.abort();
            long requestEndTime = System.currentTimeMillis();
            PluginStats stats = PluginStats.getInstance();
            stats.incrementRequestCount();
            stats.addRequestTime(requestEndTime - requestStartTime);
        }
    }

    private boolean isAuthorizationFailureResponse(StatusLine statusLine) {
        return statusLine.getStatusCode() == 401 || statusLine.getStatusCode() == 307;
    }

    private void handleAuthorizationFailureResponse(Operation operation, StatusLine statusLine) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Response to " + operation + " was " + ASConnection.statusAsString(statusLine) + " - throwing InvalidPluginConfigurationException..."));
        }
        String message = statusLine.getStatusCode() == 401 ? "Credentials for plugin to connect to AS7 management interface are invalid - update Connection Settings with valid credentials." : "Authorization to AS7 failed - did you install a management user?";
        throw new InvalidPluginConfigurationException(message);
    }

    private boolean containsSpaces(String path) {
        boolean includesSpaces = false;
        StringTokenizer components = new StringTokenizer(path, " ");
        if (components.countTokens() > 1) {
            includesSpaces = true;
        }
        return includesSpaces;
    }

    public Result execute(Operation op) {
        return this.execute(op, false, 10);
    }

    public Result execute(Operation op, int timeoutSec) {
        return this.execute(op, false, timeoutSec);
    }

    public ComplexResult executeComplex(Operation op) {
        return (ComplexResult)this.execute(op, true, 10);
    }

    public ComplexResult executeComplex(Operation op, int timeoutSec) {
        return (ComplexResult)this.execute(op, true, timeoutSec);
    }

    public Result execute(Operation op, boolean isComplex) {
        return this.execute(op, isComplex, 10);
    }

    public Result execute(Operation op, boolean isComplex, int timeoutSec) {
        JsonNode node = this.executeRaw(op, timeoutSec);
        if (node == null) {
            LOG.warn((Object)("Operation [" + op + "] returned null."));
            Result failure = new Result();
            failure.setFailureDescription("Operation [" + op + "] returned null.");
            return failure;
        }
        try {
            String as7ResultSerialization = node.toString();
            if (as7ResultSerialization.indexOf(JSON_NODE_FAILURE_DESCRIPTION) > -1 && verbose) {
                LOG.warn((Object)("------ Detected 'failure-description' when communicating with server." + as7ResultSerialization));
            }
            Result res = isComplex ? (Result)this.mapper.readValue(node, ComplexResult.class) : (Result)this.mapper.readValue(node, Result.class);
            return res;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            if (verbose) {
                LOG.error((Object)("----------- Operation execution unparsable. Request :[" + op + "] Response:<" + node + ">"));
            }
            Result failure = new Result();
            failure.setFailureDescription("Operation <" + op + "> returned unparsable JSON, <" + node + ">.");
            return failure;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.credentials.getUserName();
    }

    public String getPassword() {
        return this.credentials.getPassword();
    }

    static String statusAsString(StatusLine statusLine) {
        String reasonPhrase = statusLine.getReasonPhrase();
        StringBuilder builder = new StringBuilder(3 + (reasonPhrase == null ? 0 : 1 + reasonPhrase.length()));
        builder.append(statusLine.getStatusCode());
        if (statusLine != null) {
            builder.append(" ").append(statusLine.getReasonPhrase());
        }
        return builder.toString();
    }

    private static final class ConnectionManagerCleaner
    implements Runnable {
        private WeakReference<ASConnection> asConnectionWeakReference;

        private ConnectionManagerCleaner(ASConnection asConnection) {
            this.asConnectionWeakReference = new WeakReference<ASConnection>(asConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ASConnection asConnection = (ASConnection)this.asConnectionWeakReference.get();
            if (asConnection != null) {
                try {
                    asConnection.httpClient.getConnectionManager().closeExpiredConnections();
                    asConnection.httpClient.getConnectionManager().closeIdleConnections(asConnection.keepAliveTimeout, TimeUnit.MILLISECONDS);
                }
                finally {
                    cleanerExecutor.schedule(new ConnectionManagerCleaner(asConnection), asConnection.keepAliveTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

