/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.availability.AvailabilityCollectorRunnable;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.event.log.LogFileEventResourceComponentHelper;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.pluginapi.util.StartScriptConfiguration;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.PropertiesFileUpdate;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.AS7CommandLine;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.helper.HostConfiguration;
import org.rhq.modules.plugins.jbossas7.helper.HostPort;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public abstract class BaseServerComponent<T extends ResourceComponent<?>>
extends BaseComponent<T>
implements MeasurementFacet {
    private static final String SEPARATOR = "\n-----------------------\n";
    final Log log = LogFactory.getLog(BaseServerComponent.class);
    private ASConnection connection;
    private LogFileEventResourceComponentHelper logFileEventDelegate;
    private StartScriptConfiguration startScriptConfig;
    private ServerPluginConfiguration serverPluginConfig;
    private AvailabilityType previousAvailabilityType;
    private AvailabilityCollectorRunnable availabilityCollector;

    @Override
    public void start(ResourceContext<T> resourceContext) throws InvalidPluginConfigurationException, Exception {
        super.start(resourceContext);
        this.serverPluginConfig = new ServerPluginConfiguration(this.pluginConfiguration);
        this.connection = ASConnection.newInstanceForServerPluginConfiguration(this.serverPluginConfig);
        this.getAvailability();
        this.logFileEventDelegate = new LogFileEventResourceComponentHelper(this.context);
        this.logFileEventDelegate.startLogFileEventPollers();
        this.startScriptConfig = new StartScriptConfiguration(this.pluginConfiguration);
        Integer availabilityCheckPeriod = null;
        try {
            availabilityCheckPeriod = this.serverPluginConfig.getAvailabilityCheckPeriod();
        }
        catch (NumberFormatException e) {
            this.log.error((Object)("Avail check period config prop was not a valid number. Cause: " + e));
        }
        if (availabilityCheckPeriod != null) {
            long availCheckMillis = (long)availabilityCheckPeriod.intValue() * 1000L;
            this.availabilityCollector = resourceContext.getAvailabilityContext().createAvailabilityCollectorRunnable(new AvailabilityFacet(){

                public AvailabilityType getAvailability() {
                    return BaseServerComponent.this.getAvailabilityNow();
                }
            }, availCheckMillis);
            this.availabilityCollector.start();
        }
    }

    @Override
    public void stop() {
        this.logFileEventDelegate.stopLogFileEventPollers();
        this.previousAvailabilityType = null;
        if (this.availabilityCollector != null) {
            this.availabilityCollector.stop();
            this.availabilityCollector = null;
        }
    }

    @Override
    public AvailabilityType getAvailability() {
        if (this.availabilityCollector != null) {
            return this.availabilityCollector.getLastKnownAvailability();
        }
        return this.getAvailabilityNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AvailabilityType getAvailabilityNow() {
        AvailabilityType availabilityType;
        try {
            this.readAttribute("launch-type");
            availabilityType = AvailabilityType.UP;
        }
        catch (Exception e) {
            availabilityType = AvailabilityType.DOWN;
        }
        try {
            if (availabilityType == AvailabilityType.UP && this.previousAvailabilityType != AvailabilityType.UP) {
                this.validateServerAttributes();
                this.log.info((Object)(this.getResourceDescription() + " has just come UP."));
            }
        }
        finally {
            this.previousAvailabilityType = availabilityType;
        }
        return availabilityType;
    }

    private void validateServerAttributes() throws InvalidPluginConfigurationException {
        JBossProductType type;
        JBossProductType runtimeType;
        String mode;
        String runtimeMode;
        File runtimeBaseDir;
        File baseDir = null;
        try {
            String runtimeBaseDirString = this.readAttribute(this.getEnvironmentAddress(), this.getBaseDirAttributeName());
            runtimeBaseDir = new File(runtimeBaseDirString).getCanonicalFile();
            File baseDirTmp = this.serverPluginConfig.getBaseDir();
            if (baseDirTmp != null) {
                baseDir = baseDirTmp.getCanonicalFile();
            }
        }
        catch (Exception e) {
            runtimeBaseDir = null;
            baseDir = null;
            this.log.error((Object)("Failed to validate base dir for " + this.getResourceDescription() + "."), (Throwable)e);
        }
        if (runtimeBaseDir != null && baseDir != null && !runtimeBaseDir.equals(baseDir)) {
            throw new InvalidPluginConfigurationException("The server listening on " + this.serverPluginConfig.getHostname() + ":" + this.serverPluginConfig.getPort() + " has base dir [" + runtimeBaseDir + "], but the base dir we expected was [" + baseDir + "]. Perhaps the management hostname or port has been changed for the server with base dir [" + baseDir + "].");
        }
        try {
            runtimeMode = this.readAttribute("launch-type");
        }
        catch (Exception e) {
            runtimeMode = null;
            this.log.error((Object)("Failed to validate mode for " + this.getResourceDescription() + "."), (Throwable)e);
        }
        if (runtimeMode != null && !runtimeMode.equals(mode = this.getMode().name())) {
            throw new InvalidPluginConfigurationException("The original mode discovered for this AS7 server was " + (Object)((Object)this.getMode()) + ", but the server is now reporting its mode is [" + runtimeMode + "].");
        }
        try {
            String runtimeTypeString = this.readAttribute(this.getHostAddress(), "product-name");
            runtimeType = runtimeTypeString != null && !runtimeTypeString.isEmpty() ? JBossProductType.getValueByProductName(runtimeTypeString) : JBossProductType.AS;
        }
        catch (Exception e) {
            runtimeType = null;
            this.log.error((Object)("Failed to validate product type for " + this.getResourceDescription() + "."), (Throwable)e);
        }
        if (runtimeType != null && runtimeType != (type = this.serverPluginConfig.getProductType())) {
            throw new InvalidPluginConfigurationException("The original product type discovered for this AS7 server was " + (Object)((Object)type) + ", but the server is now reporting its product type is [" + (Object)((Object)runtimeType) + "].");
        }
    }

    public ServerPluginConfiguration getServerPluginConfiguration() {
        return this.serverPluginConfig;
    }

    public StartScriptConfiguration getStartScriptConfiguration() {
        return this.startScriptConfig;
    }

    @Override
    public ASConnection getASConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(ASConnection connection) {
        this.connection = connection;
    }

    @NotNull
    protected abstract AS7Mode getMode();

    protected OperationResult restartServer(Configuration parameters) throws Exception {
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Restarting")) {
            return operationResult;
        }
        List<String> errors = this.validateStartScriptPluginConfigProps();
        if (!errors.isEmpty()) {
            OperationResult result = new OperationResult();
            this.setErrorMessage(result, errors);
            return result;
        }
        OperationResult tmp = this.invokeOperation("shutdown", parameters);
        if (tmp.getErrorMessage() != null) {
            tmp.setErrorMessage("Restart failed while attempting to shut down: " + tmp.getErrorMessage());
            return tmp;
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return this.startServer();
    }

    protected boolean waitUntilDown() throws InterruptedException {
        boolean notAnswering = false;
        while (!notAnswering) {
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            try {
                Result res = this.getASConnection().execute(op);
                if (!res.isSuccess()) {
                    notAnswering = true;
                }
            }
            catch (Exception e) {
                notAnswering = true;
            }
            if (notAnswering) continue;
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        HostConfiguration hostConfig = this.getHostConfig();
        AS7CommandLine commandLine = new AS7CommandLine(new String[]{"java", "foo.Main", "org.jboss.as.host-controller"});
        HostPort hostPort = hostConfig.getDomainControllerHostPort(commandLine);
        if (hostPort.isLocal) {
            ProcessInfo processInfo = this.context.getNativeProcess();
            while (processInfo != null && processInfo.priorSnaphot().isRunning()) {
                if (this.context.getComponentInvocationContext().isInterrupted()) {
                    throw new InterruptedException();
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                processInfo = this.context.getNativeProcess();
            }
        }
        return notAnswering;
    }

    protected OperationResult startServer() throws InterruptedException {
        File startScriptFile;
        OperationResult operationResult = new OperationResult();
        if (this.isManuallyAddedServer(operationResult, "Starting")) {
            return operationResult;
        }
        List<String> errors = this.validateStartScriptPluginConfigProps();
        if (!errors.isEmpty()) {
            this.setErrorMessage(operationResult, errors);
            return operationResult;
        }
        String startScriptPrefix = this.startScriptConfig.getStartScriptPrefix();
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)startScriptPrefix, (File)(startScriptFile = this.getStartScriptFile()));
        ArrayList<String> arguments = processExecution.getArguments();
        if (arguments == null) {
            arguments = new ArrayList<String>();
            processExecution.setArguments(arguments);
        }
        List startScriptArgs = this.startScriptConfig.getStartScriptArgs();
        for (String startScriptArg : startScriptArgs) {
            startScriptArg = this.replacePropertyPatterns(startScriptArg);
            arguments.add(startScriptArg);
        }
        Map startScriptEnv = this.startScriptConfig.getStartScriptEnv();
        for (String envVarName : startScriptEnv.keySet()) {
            String envVarValue = (String)startScriptEnv.get(envVarName);
            envVarValue = this.replacePropertyPatterns(envVarValue);
            startScriptEnv.put(envVarName, envVarValue);
        }
        processExecution.setEnvironmentVariables(startScriptEnv);
        processExecution.setWorkingDirectory(startScriptFile.getParent());
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(0L);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        SystemInfo systemInfo = this.context.getSystemInformation();
        ProcessExecutionResults results = systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        if (results.getError() != null) {
            operationResult.setErrorMessage(results.getError().getMessage());
        } else if (results.getExitCode() != null && results.getExitCode() != 0) {
            operationResult.setErrorMessage("Start failed with error code " + results.getExitCode() + ":\n" + results.getCapturedOutput());
        } else {
            boolean up = this.waitForServerToStart();
            if (up) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to start the server");
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    public boolean isManuallyAddedServer() {
        return this.pluginConfiguration.get("manuallyAdded") != null;
    }

    private boolean isManuallyAddedServer(OperationResult operationResult, String operation) {
        if (this.isManuallyAddedServer()) {
            operationResult.setErrorMessage(operation + " is not enabled for manually added servers");
            return true;
        }
        return false;
    }

    private void setErrorMessage(OperationResult operationResult, List<String> errors) {
        StringBuilder buffer = new StringBuilder("This Resource's connection properties contain errors: ");
        int errorsSize = errors.size();
        for (int i = 0; i < errorsSize; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            String error = errors.get(i);
            buffer.append('[').append(error).append(']');
        }
        operationResult.setErrorMessage(buffer.toString());
    }

    private List<String> validateStartScriptPluginConfigProps() {
        ArrayList<String> errors = new ArrayList<String>();
        File startScriptFile = this.getStartScriptFile();
        if (!startScriptFile.exists()) {
            errors.add("Start script '" + startScriptFile + "' does not exist.");
        } else if (!startScriptFile.isFile()) {
            errors.add("Start script '" + startScriptFile + "' is not a regular file.");
        } else {
            if (!startScriptFile.canRead()) {
                errors.add("Start script '" + startScriptFile + "' is not readable.");
            }
            if (!startScriptFile.canExecute()) {
                errors.add("Start script '" + startScriptFile + "' is not executable.");
            }
        }
        Map startScriptEnv = this.startScriptConfig.getStartScriptEnv();
        if (startScriptEnv.isEmpty()) {
            errors.add("No start script environment variables are set. At a minimum, PATH should be set (on UNIX, it should contain at least /bin and /usr/bin). It is recommended that JAVA_HOME also be set, otherwise the PATH will be used to find java.");
        }
        return errors;
    }

    private File getStartScriptFile() {
        File startScriptFile = this.startScriptConfig.getStartScript();
        File homeDir = this.serverPluginConfig.getHomeDir();
        if (startScriptFile != null) {
            if (!startScriptFile.isAbsolute()) {
                startScriptFile = new File(homeDir, startScriptFile.getPath());
            }
        } else {
            String startScriptFileName = this.getMode().getStartScriptFileName();
            File binDir = new File(homeDir, "bin");
            startScriptFile = new File(binDir, startScriptFileName);
        }
        return startScriptFile;
    }

    private boolean waitForServerToStart() throws InterruptedException {
        boolean up = false;
        while (!up) {
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            try {
                Result res = this.getASConnection().execute(op);
                if (res.isSuccess()) {
                    up = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (up) continue;
            if (this.context.getComponentInvocationContext().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        return up;
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        this.log.info((Object)("Exit code from process execution: " + results.getExitCode()));
        this.log.info((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
    }

    protected OperationResult postProcessResult(String name, Result res) {
        OperationResult operationResult = new OperationResult();
        if (res == null) {
            operationResult.setErrorMessage("No result received from server");
            return operationResult;
        }
        if (name.equals("shutdown") || name.equals("restart") || name.equals("reload")) {
            if (!res.isSuccess()) {
                if (StringUtil.isNotBlank((String)res.getFailureDescription()) && res.getFailureDescription().startsWith("The server closed the connection before sending the response")) {
                    operationResult.setSimpleResult("Success");
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Got no response for operation '" + name + "'. " + "This is considered ok, as the remote server sometimes closes the communications " + "channel before sending a reply"));
                    }
                } else {
                    operationResult.setErrorMessage(res.getFailureDescription());
                }
            } else {
                operationResult.setSimpleResult("Success");
            }
        } else if (res.isSuccess()) {
            if (res.getResult() != null) {
                operationResult.setSimpleResult(res.getResult().toString());
            } else {
                operationResult.setSimpleResult("-None provided by server-");
            }
        } else {
            operationResult.setErrorMessage(res.getFailureDescription());
        }
        return operationResult;
    }

    protected OperationResult installManagementUser(Configuration parameters, Configuration pluginConfig) {
        boolean userAlreadyExisted;
        String encryptedPassword;
        String user = parameters.getSimpleValue("user", "");
        String password = parameters.getSimpleValue("password", "");
        OperationResult result = new OperationResult();
        PropertySimple remoteProp = pluginConfig.getSimple("manuallyAdded");
        if (remoteProp != null && remoteProp.getBooleanValue() != null && remoteProp.getBooleanValue().booleanValue()) {
            result.setErrorMessage("This is a manually added server. This operation can not be used to install a management user. Use the server's 'bin/add-user.sh'");
            return result;
        }
        if (user.isEmpty() || password.isEmpty()) {
            result.setErrorMessage("User and Password must not be empty");
            return result;
        }
        File baseDir = this.serverPluginConfig.getBaseDir();
        if (baseDir == null) {
            result.setErrorMessage("'baseDir' plugin config prop is not set.");
            return result;
        }
        HostConfiguration hostConfig = this.getHostConfig();
        String realm = pluginConfig.getSimpleValue("realm", "ManagementRealm");
        File propertiesFile = hostConfig.getSecurityPropertyFile(baseDir, this.getMode(), realm);
        if (!propertiesFile.canWrite()) {
            result.setErrorMessage("Management users properties file [" + propertiesFile + "] is not writable.");
            return result;
        }
        try {
            UsernamePasswordHashUtil hashUtil = new UsernamePasswordHashUtil();
            encryptedPassword = hashUtil.generateHashedHexURP(user, realm, password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encrypt password.", e);
        }
        try {
            PropertiesFileUpdate propsFileUpdate = new PropertiesFileUpdate(propertiesFile.getPath());
            userAlreadyExisted = propsFileUpdate.update(user, encryptedPassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update management users properties file [" + propertiesFile + "].", e);
        }
        String verb = userAlreadyExisted ? "updated" : "added";
        result.setSimpleResult("Management user [" + user + "] " + verb + ".");
        this.log.info((Object)("Management user [" + user + "] " + verb + " for " + this.context.getResourceType().getName() + " server with key [" + this.context.getResourceKey() + "]."));
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        this.context.getInventoryContext().requestDeferredChildResourcesDiscovery();
        return result;
    }

    public void requestDeferredChildResourcesDiscovery() {
        this.context.getInventoryContext().requestDeferredChildResourcesDiscovery();
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> skmRequests = new HashSet<MeasurementScheduleRequest>(requests.size());
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            if (requestName.equals("startTime")) {
                this.collectStartTimeTrait(report, request);
                continue;
            }
            if (requestName.startsWith("_skm:")) {
                skmRequests.add(request);
                continue;
            }
            leftovers.add(request);
        }
        if (skmRequests.size() > 0) {
            this.collectServerKindTraits(report, skmRequests);
        }
        super.getValues(report, leftovers);
    }

    private void collectStartTimeTrait(MeasurementReport report, MeasurementScheduleRequest request) {
        Long startTime;
        Address address = new Address(this.getHostAddress());
        address.add("core-service", "platform-mbean");
        address.add("type", "runtime");
        try {
            startTime = this.readAttribute(address, "start-time", Long.class);
        }
        catch (Exception e) {
            startTime = null;
        }
        if (startTime != null) {
            MeasurementDataTrait data = new MeasurementDataTrait(request, new Date(startTime).toString());
            report.addData(data);
        }
    }

    @NotNull
    protected abstract Address getEnvironmentAddress();

    @NotNull
    protected abstract Address getHostAddress();

    @NotNull
    protected abstract String getBaseDirAttributeName();

    protected void collectConfigTrait(MeasurementReport report, MeasurementScheduleRequest request) {
        String config;
        try {
            config = this.readAttribute(this.getEnvironmentAddress(), request.getName(), String.class);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to read attribute [" + request.getName() + "]: " + e), (Throwable)e);
            config = null;
        }
        if (config != null) {
            MeasurementDataTrait data = new MeasurementDataTrait(request, new File(config).getName());
            report.addData(data);
        }
    }

    private HostConfiguration getHostConfig() {
        HostConfiguration hostConfig;
        File configFile;
        block4: {
            try {
                String config = this.readAttribute(this.getEnvironmentAddress(), this.getMode().getHostConfigAttributeName());
                configFile = new File(config);
            }
            catch (Exception e) {
                configFile = this.serverPluginConfig.getHostConfigFile();
                if (configFile != null) break block4;
                throw new RuntimeException("Failed to determine config file path.", e);
            }
        }
        try {
            hostConfig = new HostConfiguration(configFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse configuration file [" + configFile + "].", e);
        }
        return hostConfig;
    }

    private void collectServerKindTraits(MeasurementReport report, Set<MeasurementScheduleRequest> skmRequests) {
        Address address = new Address();
        ReadResource op = new ReadResource(address);
        op.includeRuntime(true);
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (res.isSuccess()) {
            Object props = res.getResult();
            for (MeasurementScheduleRequest request : skmRequests) {
                String requestName = request.getName();
                String realName = requestName.substring(requestName.indexOf(58) + 1);
                String val = null;
                if (props.containsKey(realName)) {
                    val = this.getStringValue(props.get(realName));
                }
                if ("null".equals(val)) {
                    if (realName.equals("product-name")) {
                        val = "JBoss AS";
                    } else if (realName.equals("product-version")) {
                        val = this.getStringValue(props.get("release-version"));
                    } else {
                        this.log.debug((Object)("Value for " + realName + " was 'null' and no replacement found"));
                    }
                }
                MeasurementDataTrait data = new MeasurementDataTrait(request, val);
                report.addData(data);
            }
        } else {
            this.log.debug((Object)("getSKMRequests failed: " + res.getFailureDescription()));
        }
    }

    private String replacePropertyPatterns(String value) {
        Pattern pattern = Pattern.compile("(%([^%]*)%)");
        Matcher matcher = pattern.matcher(value);
        Configuration pluginConfig = this.context.getPluginConfiguration();
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String propName = matcher.group(2);
            PropertySimple prop = pluginConfig.getSimple(propName);
            String propValue = prop != null && prop.getStringValue() != null ? prop.getStringValue() : "";
            String propPattern = matcher.group(1);
            String replacement = prop != null ? propValue : propPattern;
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

