/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.JBossProductType;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class DatasourceComponent
extends BaseComponent<BaseComponent<?>>
implements OperationFacet,
ConfigurationFacet,
CreateChildResourceFacet {
    private static final Log LOG = LogFactory.getLog(DatasourceComponent.class);
    private static final String NOTSET = "-notset-";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String ENABLE_OPERATION = "enable";
    private static final String DISABLE_OPERATION = "disable";
    private static final String ALLOW_MULTIPLE_USERS_ATTRIBUTE = "allow-multiple-users";

    @Override
    public OperationResult invokeOperation(String operationName, Configuration parameters) throws Exception {
        Operation op;
        OperationResult operationResult = new OperationResult();
        ASConnection connection = this.getASConnection();
        if (operationName.equals("addDriver")) {
            String drivername = parameters.getSimpleValue("driver-name", NOTSET);
            Address theAddress = new Address(this.address);
            theAddress.add("jdbc-driver", drivername);
            op = new Operation("add", theAddress);
            op.addAdditionalProperty("driver-name", drivername);
            op.addAdditionalProperty("deployment-name", parameters.getSimpleValue("deployment-name", NOTSET));
            op.addAdditionalProperty("driver-class-name", parameters.getSimpleValue("driver-class-name", NOTSET));
        } else {
            op = new Operation(operationName, this.address);
        }
        Result res = connection.execute(op);
        if (res.isSuccess()) {
            operationResult.setSimpleResult("Success");
        } else {
            operationResult.setErrorMessage(res.getFailureDescription());
        }
        return operationResult;
    }

    @Override
    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        PropertySimple enabledProperty;
        List validationErrors = ConfigurationUtility.validateConfiguration((Configuration)createResourceReport.getResourceConfiguration(), (ConfigurationDefinition)createResourceReport.getResourceType().getResourceConfigurationDefinition());
        if (!validationErrors.isEmpty()) {
            createResourceReport.setErrorMessage(validationErrors.toString());
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            return createResourceReport;
        }
        final CreateResourceReport resourceReport = super.createResource(createResourceReport);
        if (resourceReport.getStatus() != CreateResourceStatus.SUCCESS) {
            return resourceReport;
        }
        if (createResourceReport.getResourceType().getName().toLowerCase().contains("xa")) {
            PropertyList listPropertyWrapper = createResourceReport.getResourceConfiguration().getList("*2");
            List listProperty = listPropertyWrapper.getList();
            String baseAddress = resourceReport.getResourceKey();
            CompositeOperation cop = new CompositeOperation();
            for (Property p : listProperty) {
                PropertyMap map = (PropertyMap)p;
                String key = map.getSimpleValue("key", null);
                String value = map.getSimpleValue("value", null);
                if (key == null || value == null) continue;
                Address propertyAddress = new Address(baseAddress);
                propertyAddress.add("xa-datasource-properties", key);
                Operation op = new Operation("add", propertyAddress);
                op.addAdditionalProperty("value", value);
                cop.addStep(op);
            }
            Result res = this.getASConnection().execute(cop);
            if (!res.isSuccess()) {
                resourceReport.setErrorMessage("Datasource was added, but setting xa-properties failed: " + res.getFailureDescription());
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                return resourceReport;
            }
        }
        Boolean enabledPropertyValue = (enabledProperty = createResourceReport.getResourceConfiguration().getSimple(ENABLED_ATTRIBUTE)) == null ? Boolean.TRUE : enabledProperty.getBooleanValue();
        EnabledAttributeHelper.on(new Address(resourceReport.getResourceKey())).with(this.getASConnection()).setAttributeValue(enabledPropertyValue, new EnabledAttributeHelperCallbacks(){

            @Override
            public void onReadAttributeFailure(Result opResult) {
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                resourceReport.setErrorMessage("Data source was added, but could not read its configuration after creation: " + opResult.getFailureDescription());
            }

            @Override
            public void onEnableOperationFailure(Result opResult) {
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                resourceReport.setErrorMessage("Datasource was added but not enabled: " + opResult.getFailureDescription());
            }

            @Override
            public void onDisableOperationFailure(Result opResult) {
                resourceReport.setStatus(CreateResourceStatus.INVALID_ARTIFACT);
                resourceReport.setErrorMessage("Datasource was added but not disabled: " + opResult.getFailureDescription());
            }
        });
        return resourceReport;
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = super.loadResourceConfiguration();
        PropertySimple enabled = configuration.getSimple(ENABLED_ATTRIBUTE);
        if (enabled.getStringValue() == null) {
            enabled.setBooleanValue(Boolean.FALSE);
        }
        return configuration;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> metrics = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().equals("connectionAvailable")) {
                report.addData(this.getConnectionAvailable(request));
                continue;
            }
            if (request.getName().equals("max-pool-size")) {
                this.getRCAsMetric(report, request);
                continue;
            }
            if (request.getName().equals("min-pool-size")) {
                this.getRCAsMetric(report, request);
                continue;
            }
            metrics.add(request);
        }
        ReadResource op = new ReadResource(this.address);
        op.includeRuntime(true);
        op.recursive(true);
        ComplexResult res = this.getASConnection().executeComplex(op);
        if (!res.isSuccess()) {
            return;
        }
        HashMap results = new HashMap();
        Map statistics = (Map)res.getResult().get("statistics");
        if (statistics != null) {
            results.putAll((Map)statistics.get("pool"));
            results.putAll((Map)statistics.get("jdbc"));
            for (MeasurementScheduleRequest metric : metrics) {
                String name = metric.getName();
                Object o = results.get(name);
                if (o == null) continue;
                String tmp = (String)o;
                Double val = Double.valueOf(tmp);
                MeasurementDataNumeric data = new MeasurementDataNumeric(metric, val);
                report.addData(data);
            }
        }
    }

    @Override
    public void updateResourceConfiguration(final ConfigurationUpdateReport configurationUpdateReport) {
        Configuration config = configurationUpdateReport.getConfiguration();
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        this.replaceWithDefaultIfNull("max-pool-size", config, configDef);
        this.replaceWithDefaultIfNull("min-pool-size", config, configDef);
        this.replaceWithDefaultIfNull("pool-prefill", config, configDef);
        this.replaceWithDefaultIfNull("pool-use-strict-min", config, configDef);
        this.replaceWithDefaultIfNull("blocking-timeout-wait-millis", config, configDef);
        this.replaceWithDefaultIfNull("idle-timeout-minutes", config, configDef);
        this.replaceWithDefaultIfNull("background-validation-millis", config, configDef);
        this.replaceWithDefaultIfNull("background-validation-minutes", config, configDef);
        this.replaceWithDefaultIfNull("background-validation", config, configDef);
        ConfigurationDefinition configDefCopy = this.copyConfigurationDefinition(configDef);
        configDefCopy.getPropertyDefinitions().remove(ENABLED_ATTRIBUTE);
        if (this.getServerComponent().getServerPluginConfiguration().getProductType() == JBossProductType.AS) {
            configDefCopy.getPropertyDefinitions().remove(ALLOW_MULTIPLE_USERS_ATTRIBUTE);
        }
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDefCopy, this.getASConnection(), this.address);
        delegate.updateResourceConfiguration(configurationUpdateReport);
        if (configurationUpdateReport.getStatus() != ConfigurationUpdateStatus.SUCCESS) {
            return;
        }
        Boolean configValue = config.getSimple(ENABLED_ATTRIBUTE).getBooleanValue();
        if (configValue == null) {
            configValue = Boolean.TRUE;
        }
        EnabledAttributeHelper.on(this.address).with(this.getASConnection()).setAttributeValue(configValue, new EnabledAttributeHelperCallbacks(){

            @Override
            public void onReadAttributeFailure(Result opResult) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("Data source was updated, but could not read its configuration after the update: " + opResult.getFailureDescription());
            }

            @Override
            public void onEnableOperationFailure(Result opResult) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("Data source was updated but not enabled: " + opResult.getFailureDescription());
            }

            @Override
            public void onDisableOperationFailure(Result opResult) {
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                configurationUpdateReport.setErrorMessage("Data source was updated but not disabled: " + opResult.getFailureDescription());
            }
        });
    }

    private void getRCAsMetric(MeasurementReport report, MeasurementScheduleRequest request) {
        ReadAttribute op = new ReadAttribute(this.getAddress(), request.getName());
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            Integer tmp = (Integer)res.getResult();
            if (tmp == null) {
                tmp = request.getName().equals("max-pool-size") ? Integer.valueOf(20) : (request.getName().equals("min-pool-size") ? Integer.valueOf(0) : Integer.valueOf(-1));
            }
            Double val = (double)tmp;
            MeasurementDataNumeric data = new MeasurementDataNumeric(request, val);
            report.addData(data);
        } else {
            LOG.warn((Object)("Could not read [" + request.getName() + "] on " + this.getAddress() + ": " + res.getFailureDescription()));
        }
    }

    private MeasurementDataTrait getConnectionAvailable(MeasurementScheduleRequest request) {
        Operation op = new Operation("test-connection-in-pool", this.getAddress());
        Result res = this.getASConnection().execute(op);
        MeasurementDataTrait trait = new MeasurementDataTrait(request, String.valueOf(res.isSuccess()));
        return trait;
    }

    private void replaceWithDefaultIfNull(String propertyName, Configuration config, ConfigurationDefinition configDef) {
        String propertyValue;
        PropertyDefinitionSimple propertyDefinition = configDef.getPropertyDefinitionSimple(propertyName);
        if (propertyDefinition != null && ((propertyValue = config.getSimpleValue(propertyName)) == null || propertyValue.isEmpty())) {
            config.put((Property)new PropertySimple(propertyName, (Object)propertyDefinition.getDefaultValue()));
        }
    }

    private ConfigurationDefinition copyConfigurationDefinition(ConfigurationDefinition configurationDefinition) {
        ConfigurationDefinition configDefCopy = new ConfigurationDefinition(configurationDefinition.getName(), configurationDefinition.getDescription());
        configDefCopy.setConfigurationFormat(configurationDefinition.getConfigurationFormat());
        configDefCopy.setPropertyDefinitions(new HashMap(configurationDefinition.getPropertyDefinitions()));
        return configDefCopy;
    }

    static interface EnabledAttributeHelperCallbacks {
        public void onReadAttributeFailure(Result var1);

        public void onEnableOperationFailure(Result var1);

        public void onDisableOperationFailure(Result var1);
    }

    private static class EnabledAttributeHelper {
        Address datasourceAddress;
        ASConnection asConnection;

        EnabledAttributeHelper(Address datasourceAddress) {
            this.datasourceAddress = datasourceAddress;
        }

        static EnabledAttributeHelper on(Address datasourceAddress) {
            return new EnabledAttributeHelper(datasourceAddress);
        }

        EnabledAttributeHelper with(ASConnection asConnection) {
            this.asConnection = asConnection;
            return this;
        }

        void setAttributeValue(Boolean attributeValue, EnabledAttributeHelperCallbacks callbacks) {
            if (this.asConnection == null) {
                throw new IllegalStateException("No ASConnection instance provided");
            }
            if (attributeValue == null) {
                throw new IllegalArgumentException("Argument attributeValue is null");
            }
            ReadAttribute readAttribute = new ReadAttribute(this.datasourceAddress, DatasourceComponent.ENABLED_ATTRIBUTE);
            Result readAttributeResult = this.asConnection.execute(readAttribute);
            if (!readAttributeResult.isSuccess()) {
                if (callbacks != null) {
                    callbacks.onReadAttributeFailure(readAttributeResult);
                }
                return;
            }
            Boolean currentAttributeValue = (Boolean)readAttributeResult.getResult();
            if (currentAttributeValue == null) {
                currentAttributeValue = Boolean.FALSE;
            }
            if (currentAttributeValue != attributeValue) {
                if (attributeValue == Boolean.TRUE) {
                    Operation operation = new Operation(DatasourceComponent.ENABLE_OPERATION, this.datasourceAddress);
                    Result res = this.asConnection.execute(operation);
                    if (!res.isSuccess()) {
                        if (callbacks != null) {
                            callbacks.onEnableOperationFailure(res);
                        }
                        return;
                    }
                } else {
                    Operation operation = new Operation(DatasourceComponent.DISABLE_OPERATION, this.datasourceAddress);
                    Result res = this.asConnection.execute(operation);
                    if (!res.isSuccess()) {
                        if (callbacks != null) {
                            callbacks.onDisableOperationFailure(res);
                        }
                        return;
                    }
                }
            }
        }
    }
}

